/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.utils;

import com.vmware.srm.client.topology.impl.common.Utils;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RefreshManager<Client, Product> {
    private static final ScheduledTaskGCThread GC = new ScheduledTaskGCThread();
    private static final ReferenceQueue<Object> CLIENT_REF_QUEUE = new ReferenceQueue();
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshManager.class);
    private static final ScheduledExecutorService EXEC = Utils.getScheduledExecutor();
    private final ConcurrentMap<Client, CompletableFuture<Product>> _productFutureByClient = new ConcurrentHashMap<Client, CompletableFuture<Product>>();
    protected final long minTimeBeforeRenew;

    protected RefreshManager(long minTimeBeforeRenew) {
        this.minTimeBeforeRenew = minTimeBeforeRenew;
    }

    protected abstract void onRequestExists(CompletableFuture<Product> var1);

    protected abstract void refreshProduct(Client var1, Product var2, CompletableFuture<Product> var3);

    protected abstract Date getExpirationTime(Product var1);

    protected CompletableFuture<Product> getProduct(Client client, BiConsumer<Client, CompletableFuture<Product>> consumer) {
        CompletableFuture productFuture = new CompletableFuture();
        if (this._productFutureByClient.putIfAbsent(client, productFuture) != null) {
            this.onRequestExists(productFuture);
            return productFuture;
        }
        try {
            consumer.accept(client, productFuture);
        }
        catch (Throwable t) {
            productFuture.completeExceptionally(t);
        }
        return productFuture.whenComplete((product, fault) -> {
            if (fault != null) {
                LOGGER.warn("Failed to create product for client {}", client, fault);
                this._productFutureByClient.remove(client, productFuture);
                return;
            }
            this.scheduleRenewTaskFor(client, productFuture, product);
        });
    }

    protected CompletableFuture<Product> getCurrentRequestFor(Client client) {
        return (CompletableFuture)this._productFutureByClient.get(client);
    }

    protected CompletableFuture<Product> refreshNow(Client client) {
        CompletableFuture currentFuture;
        CompletableFuture newProductFuture = new CompletableFuture();
        do {
            if ((currentFuture = (CompletableFuture)this._productFutureByClient.get(client)) == null || !currentFuture.isDone()) {
                return currentFuture;
            }
            if (!currentFuture.isCompletedExceptionally()) continue;
            return null;
        } while (!this._productFutureByClient.replace(client, currentFuture, newProductFuture));
        try {
            this.refreshProduct(client, currentFuture.get(), newProductFuture);
        }
        catch (Throwable t) {
            newProductFuture.completeExceptionally(t);
        }
        newProductFuture.whenComplete((product, fault) -> {
            if (fault != null) {
                LOGGER.warn("Executing 'refresh product' for client {} failed.", client, fault);
                this._productFutureByClient.remove(client, newProductFuture);
                return;
            }
            this.scheduleRenewTaskFor(client, newProductFuture, product);
        });
        return newProductFuture;
    }

    protected void releaseClient(Client client) {
        CompletableFuture productFuture = (CompletableFuture)this._productFutureByClient.remove(client);
        if (productFuture != null) {
            productFuture.cancel(false);
        }
    }

    private void scheduleRenewTaskFor(Client client, CompletableFuture<Product> productFuture, Product currentProduct) {
        Date exp = this.getExpirationTime(currentProduct);
        long lifetimeMillis = exp.getTime() - System.currentTimeMillis();
        long lifetimeSecs = TimeUnit.MILLISECONDS.toSeconds(lifetimeMillis);
        long interval = Math.max(0L, lifetimeSecs - this.minTimeBeforeRenew);
        RenewTask renewTask = new RenewTask(client, productFuture, currentProduct);
        renewTask.setScheduledTask(EXEC.schedule(renewTask, interval, TimeUnit.SECONDS));
    }

    static {
        GC.start();
    }

    private static final class ScheduledTaskGCThread
    extends Thread {
        ScheduledTaskGCThread() {
            super("scheduled-task-gc-thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Ref ref = (Ref)CLIENT_REF_QUEUE.remove();
                    Future<?> scheduledTask = ref.scheduledTask;
                    ref.scheduledTask = null;
                    if (scheduledTask == null) continue;
                    scheduledTask.cancel(false);
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("task-handle-gc-thread interrupted.");
                this.interrupt();
                return;
            }
        }
    }

    private static final class Ref
    extends WeakReference<CompletableFuture> {
        volatile Future<?> scheduledTask;

        Ref(CompletableFuture future) {
            super(future, CLIENT_REF_QUEUE);
        }
    }

    private class RenewTask
    implements Runnable {
        private final Client _client;
        private final Ref _prevProductFutureRef;
        private final Product _prevProduct;

        RenewTask(Client client, CompletableFuture<Product> prevProductFuture, Product prevProduct) {
            this._client = client;
            this._prevProductFutureRef = new Ref(prevProductFuture);
            this._prevProduct = prevProduct;
        }

        @Override
        public void run() {
            CompletableFuture prevProductFuture = (CompletableFuture)this._prevProductFutureRef.get();
            if (prevProductFuture == null) {
                return;
            }
            CompletableFuture newProductFuture = new CompletableFuture();
            if (!RefreshManager.this._productFutureByClient.replace(this._client, prevProductFuture, newProductFuture)) {
                LOGGER.debug("Unable to start 'refresh product' for client {}", this._client);
                return;
            }
            try {
                RefreshManager.this.refreshProduct(this._client, this._prevProduct, newProductFuture);
            }
            catch (Throwable t) {
                newProductFuture.completeExceptionally(t);
            }
            newProductFuture.whenComplete((product, fault) -> {
                if (fault != null) {
                    LOGGER.warn("Executing 'refresh product' for client {} failed.", this._client, fault);
                    RefreshManager.this._productFutureByClient.remove(this._client, newProductFuture);
                    return;
                }
                RefreshManager.this.scheduleRenewTaskFor(this._client, newProductFuture, product);
            });
        }

        void setScheduledTask(Future<?> task) {
            this._prevProductFutureRef.scheduledTask = task;
        }
    }
}

