/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.view.availability;

import com.vmware.dr.ui.tools.reactive.Stream;
import com.vmware.dr.ui.tools.reactive.impl.CachingStream;
import com.vmware.dr.ui.tools.reactive.impl.StreamImpl;
import com.vmware.srm.client.topology.client.view.availability.ExtensionServer;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.srm.client.topology.client.view.certificate.CertificateValidityInfo;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.Service;
import com.vmware.srm.client.topology.impl.view.ServerImpl;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.view.availability.PairSetupImpl;
import com.vmware.vim.binding.vmodl.ManagedObject;
import java.net.URI;
import java.util.List;

public abstract class ExtensionServerImpl<S extends ManagedObject, T extends Service<S, ?>, U extends PairSetup<? extends ExtensionServer<T>>, V extends PairSetupImpl<? extends ExtensionServer<T>>>
extends ServerImpl<S, T>
implements ExtensionServer<T> {
    private final ServersViewImpl _view;
    private final VcServer _vc;
    private final StreamImpl<V> _pairStream = new CachingStream();

    public ExtensionServerImpl(ServersViewImpl view, URI url, T service, String guid, boolean isLocal, List<CertificateValidityInfo> certificateIssues, VcServer vc) {
        super(url, service, guid, isLocal, certificateIssues);
        this._view = view;
        this._vc = vc;
    }

    @Override
    public VcServer vc() {
        return this._vc;
    }

    public void add(V pair) {
        this._pairStream.publishNext(pair);
        this._view.addPairSetup((PairSetupImpl<?>)pair);
    }

    public void complete(Exception err) {
        this._pairStream.publishError((Exception)new ExtensionServer.GetPairFailedException(this._url, err));
    }

    public void complete() {
        this._pairStream.publishComplete();
    }

    @Override
    public Stream<U> getPairs() {
        return this._pairStream.map(pairImpl -> pairImpl);
    }
}

