/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.http;

import com.vmware.dr.ui.tools.reactive.Promise;
import com.vmware.dr.ui.tools.reactive.impl.PromiseImpl;
import com.vmware.dr.ui.tools.reactive.impl.utils.Exceptions;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteListenerPromise
extends PromiseImpl<Void>
implements WriteListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteListenerPromise.class);
    private static final int CHUNK_SIZE = 1024;
    private final ServletOutputStream _output;
    private final PromiseImpl<byte[]> _inputBuffer = new PromiseImpl();
    private volatile int _offset = 0;

    public WriteListenerPromise(ServletOutputStream output) {
        this._output = output;
    }

    public void onWritePossible() {
        this._inputBuffer.thenApply(inputBuffer -> {
            try {
                this.doWrite((byte[])inputBuffer);
            }
            catch (Exception exc) {
                LOGGER.error("Error writing input buffer", (Throwable)exc);
                this.setError(exc);
            }
            return null;
        });
    }

    public void onError(Throwable t) {
        this.setError(Exceptions.wrap((Throwable)t));
    }

    public Promise<Void> setInputBuffer(byte[] inputBuffer) {
        this._inputBuffer.setResult((Object)inputBuffer);
        return this;
    }

    private void doWrite(byte[] inputBuffer) throws IOException {
        int toWrite = Math.min(1024, inputBuffer.length - this._offset);
        while (toWrite > 0) {
            if (!this._output.isReady()) {
                return;
            }
            this._output.write(inputBuffer, this._offset, toWrite);
            this._offset += toWrite;
            toWrite = Math.min(1024, inputBuffer.length - this._offset);
        }
        if (this._output.isReady()) {
            this._output.flush();
            this.setResult(null);
        }
    }
}

