/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.infrastructure.pc.utils;

import com.vmware.srm.client.infrastructure.pc.utils.PcResultImpl;
import com.vmware.srm.client.infrastructure.pc.utils.PcResultItem;
import com.vmware.srm.client.infrastructure.utils.MixedUtil;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuccessPcResultItem
extends PcResultItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuccessPcResultItem.class);
    private final Collection<PropertyCollector.RetrieveResult> _retrievedResult;

    public SuccessPcResultItem(String guid, Collection<PropertyCollector.RetrieveResult> retrievedResult) {
        super(guid);
        this._retrievedResult = retrievedResult;
    }

    public Collection<PropertyCollector.RetrieveResult> getRetrievedResult() {
        return this._retrievedResult;
    }

    @Override
    public PcResultImpl applyResult(PcResultImpl pcResult) {
        Collection<PropertyCollector.RetrieveResult> items = this.getRetrievedResult();
        for (PropertyCollector.RetrieveResult item : items) {
            for (PropertyCollector.ObjectContent content : item.objects) {
                pcResult.addMoRefInResult(content.obj);
                if (!pcResult.getMoRefs().contains(content.obj)) {
                    pcResult.addMoRef(content.obj);
                }
                if (content.missingSet != null) {
                    for (PropertyCollector.MissingProperty missingProperty : content.missingSet) {
                        LOGGER.warn("Adding missing property for [{}]. Property '{}'. Reason: {}.", new Object[]{content.obj, missingProperty.path, missingProperty.fault});
                        pcResult.addPropertyError(content.obj, missingProperty.path, missingProperty.fault);
                    }
                }
                if (content.propSet == null) continue;
                for (PropertyCollector.MissingProperty missingProperty : content.propSet) {
                    Object value = missingProperty.getVal();
                    if (missingProperty.getName().equals("name")) {
                        value = MixedUtil.unescapeVimEntityNameSpecialChars((String)value);
                    }
                    pcResult.addPropertyValue(content.obj, missingProperty.getName(), value);
                }
            }
        }
        return pcResult;
    }
}

