@echo off

echo.
echo *******************************************************************************
echo                               Mirage WinPE Builder
echo *******************************************************************************
echo.

set exit_code=0

if [%~2] == [x86] goto serverAddress
if [%~2] == [x64] goto serverAddress
echo Invalid Architecture value %~2
goto usage

:serverAddress
for /f "eol= " %%a in ("%~3") do if "%%a" neq "%~3" echo Spaces not allowed in Server Address, value "%~3" && goto usage
if [%~3a] == [a] echo Empty Server Address value && goto usage
set server_address=%~3

for /f "eol= " %%a in ("%~4") do if "%%a" neq "%~4" echo Spaces not allowed in Server Port, value "%~4" && goto usage
if [%~4a] == [a] echo Empty Server Port value && goto usage
set number_only_check=
for /F "delims=1234567890" %%i in ("%~4") do set number_only_check=%%i
if [%number_only_check%a] == [a] goto serverPort
echo Invalid Server Port value %~4
goto usage

:serverPort
set server_port=%~4

for /f "eol= " %%a in ("%~5") do if "%%a" neq "%~5" echo Spaces not allowed in Use SSL, value "%~5" && goto usage
if [%~5a] == [a] echo Empty Use SSL value && goto usage
if /I [%~5] == [true] goto checkCertificatesFolder
if /I [%~5] == [false] goto useSslOk
echo Invalid Use SSL value %~5
goto usage

:checkCertificatesFolder
for %%j in ("%~dp0..\Certificates\*") DO goto useSslOk
echo Missing certificates while Use SSL value is true
set exit_code=1
goto end

:useSslOk
set use_ssl=%~5


if /I [%~6] == [true] set total_steps=15 && goto handleSelfKitting
if /I [%~6] == [false] set total_steps=14 && goto handleSelfKitting
echo Invalid Use Self Service Provisioning value %~6
goto usage

:handleSelfKitting
set use_selfkitting=%~6

set web_selfkitting_url=[]
if /I [%~6] == [false] goto noselfkitting
if [%~7] == []  echo Empty Self Service Provisioning URL value while Self Service is enabled && goto usage
set web_selfkitting_url=%~7

echo %web_selfkitting_url% | findstr /I "http:// https:// http:\\ https:\\" 1>nul 2>&1
if errorlevel 1 echo Invalid Self Service Provisioning URL value while Self Service is enabled && goto usage

:noselfkitting
set output_path_maybe_with_space=%~9
set output_path_without_trailing=%output_path_maybe_with_space:~0,-1%
set output_path_maybe_with_space="%output_path_maybe_with_space%"
set output_path_without_trailing="%output_path_without_trailing% "
if %output_path_maybe_with_space% == %output_path_without_trailing% echo Trailing spaces not allowed in Output Path, value "%~9" && goto usage
if ["%~9a"] == ["a"] echo Empty Output Path value && goto usage
for /f "tokens=2-4 delims=/ " %%a in ('date /t') do (set mydate=%%c-%%a-%%b)
for /f "tokens=1-2 delims=/:" %%a in ("%TIME%") do (set mytime=%%a-%%b)
if ["%mytime:~0,1%a"] neq [" a"] goto padded
for /f "tokens=1-2 delims=/ " %%a in ("%mytime%") do (set mytime=0%%a%%b)

:padded


rem shift argument, then 7 is lanuage, 8 is output, 9 is log level
shift /7

set locale="en-us"
if [%~7a] == [a] goto languageOk
if /I [%~7] == [zh-cn] set locale="zh-cn,en-us" && goto languageOk
if /I [%~7] == [zh-tw] set locale="zh-tw,en-us" && goto languageOk
if /I [%~7] == [de-de] set locale="de,en-us" && goto languageOk
if /I [%~7] == [fr-fr] set locale="fr,en-us" && goto languageOk
if /I [%~7] == [ja-jp] set locale="ja,en-us" && goto languageOk
if /I [%~7] == [ko-kr] set locale="ko,en-us" && goto languageOk
if /I [%~7] == [es-es] set locale="es,en-us" && goto languageOk
echo Invalid language value %~7
goto usage

:languageOk
set result_dir=%~8
if %result_dir:~-1% == \ SET result_dir=%result_dir:~0,-1%
set result_dir="%result_dir%\MirageWinPE\%mydate% %mytime%"

for /f "eol= " %%a in ("%~9") do if "%%a" neq "%~9" echo Spaces not allowed in Log Level, value "%~9" && goto usage
if [%~9a] == [a] echo Empty Log Level value && goto usage
if /I [%~9] == [debug] goto logLevelOk
if /I [%~9] == [trace] goto logLevelOk
if /I [%~9] == [warn] goto logLevelOk
if /I [%~9] == [info] goto logLevelOk
if /I [%~9] == [verbose] goto logLevelOk
echo Invalid Log Level value %~9
goto usage

:logLevelOk
set log_level=%~9
set logs_dir=%~dp0..\logs\%mydate% %mytime%
set log_file="%logs_dir%\%~n1.log"

if EXIST "%logs_dir%" rmdir /s /q "%logs_dir%"
mkdir "%logs_dir%"
if %errorlevel% neq 0 echo Could not create logs directory && goto errend

rem Do not move the logging lines below. They must be after the log files directory creation.
echo ******************************************************************************* >> %log_file%
echo                             Mirage WinPE %~2 Builder >> %log_file%
echo ******************************************************************************* >> %log_file%

echo Stand by, this process might take a few minutes...
echo.


set cur_step=1

rem =======================
rem ======== Setup ========
rem =======================
echo --- Setup                                                       (Step %cur_step%  of %total_steps%)
echo --- Setup >> %log_file%

set arch=%~2
set mount_dir=%result_dir%\MirageMountDir
set mount_dir_unquoted=%mount_dir:"=%
set iso_name=Mirage_WinPE_%arch%.iso
set wim_name=Mirage_WinPE.wim
set startnet=%mount_dir%\windows\system32\startnet.cmd
set browser_process1=plugin-container
set browser_process2=firefox
set startbrowser=%mount_dir%\windows\system32\startbrowser.cmd
set closebrowser=%mount_dir%\windows\system32\closebrowser.cmd

set adk_dir=%ProgramFiles%\Windows Kits\8.1\Assessment and Deployment Kit
set x86bit_adk=0
if exist "%adk_dir%\" set x86bit_adk=1

set browser_path=\Program Files\Browser\
set browser_exe=App\Firefox\firefox.exe

if 0 == %x86bit_adk% set adk_dir=%ProgramFiles(x86)%\Windows Kits\8.1\Assessment and Deployment Kit

set mount_args=/Mount-Wim /WimFile
if 0 == %x86bit_adk% set mount_args=/Mount-Image /ImageFile

set unmount_args=/Unmount-Wim
if 0 == %x86bit_adk% set unmount_args=/Unmount-Image

set iso_arch=%arch%
if [%arch%] == [x64] set iso_arch=amd64

set adk_preinstall_dir=%adk_dir%\Windows Preinstallation Environment\%iso_arch%
set adk_deployment_tools_dir=%adk_dir%\Deployment Tools\x86
if 0 == %x86bit_adk% set adk_deployment_tools_dir=%adk_dir%\Deployment Tools\amd64

set dism_prog="%adk_deployment_tools_dir%\DISM\dism.exe"

%dism_prog% %unmount_args% /MountDir:%mount_dir% /discard >> %log_file%
if EXIST %result_dir% rmdir /s /q %result_dir%
if EXIST %mount_dir% rmdir /s /q %mount_dir%


set /a cur_step=%cur_step%+1
rem ===========================================
rem ======== Creating output directory ========
rem ===========================================
echo --- Creating output directory                                   (Step %cur_step%  of %total_steps%)
echo --- Creating output directory >> %log_file%

mkdir %result_dir%
if %errorlevel% neq 0 echo Failed creating output directory, with error %errorlevel% && goto errend


set /a cur_step=%cur_step%+1
rem ==========================================
rem ======== Creating mount directory ========
rem ==========================================
echo --- Creating mount directory                                    (Step %cur_step%  of %total_steps%)
echo --- Creating mount directory >> %log_file%

mkdir %mount_dir%
if %errorlevel% neq 0 echo Failed creating mount directory, with error %errorlevel% && goto errend


set /a cur_step=%cur_step%+1
rem =====================================================
rem ======== Copying the WinPE.wim file from ADK ========
rem =====================================================
echo --- Copying the WinPE.wim file from ADK                         (Step %cur_step%  of %total_steps%)
echo --- Copying the WinPE.wim file from ADK >> %log_file%

xcopy "%adk_preinstall_dir%\en-us\winpe.wim" %result_dir%\ /h /f /Y >> %log_file%
if %errorlevel% neq 0 echo Failed copying the WinPE.wim file from ADK, with error %errorlevel% && goto errend


set /a cur_step=%cur_step%+1
rem ==========================================
rem ======== Mounting the WinPE image ========
rem ==========================================
echo --- Mounting the WinPE image                                    (Step %cur_step%  of %total_steps%)
echo --- Mounting the WinPE image >> %log_file%e

%dism_prog% %mount_args%:%result_dir%\winpe.wim /Index:1 /MountDir:%mount_dir% >> %log_file%
if %errorlevel% neq 0 echo Failed mounting the WinPE image, with error %errorlevel% && goto errend


set /a cur_step=%cur_step%+1
rem ==================================================
rem ======== Adding components to WinPE image ========
rem ==================================================
echo --- Adding components to WinPE image                            (Step %cur_step%  of %total_steps%)
echo --- Adding components to WinPE image >> %log_file%

set components_dir=%adk_preinstall_dir%\WinPE_OCs
set language=%~7

if [%~7] == [] (
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-WMI.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-WMI.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\en-us\WinPE-WMI_en-us.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-WMI_en-us.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-NetFx.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-NetFx.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\en-us\WinPE-NetFx_en-us.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-NetFx_en-us.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-Scripting.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-Scripting.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\en-us\WinPE-Scripting_en-us.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-Scripting_en-us.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-PowerShell.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-PowerShell.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\en-us\WinPE-PowerShell_en-us.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-PowerShell_en-us.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-StorageWMI.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-StorageWMI.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\en-us\WinPE-StorageWMI_en-us.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-StorageWMI_en-us.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-Dot3Svc.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-Dot3Svc.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\en-us\WinPE-Dot3Svc_en-us.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-Dot3Svc_en-us.cab, with error %errorlevel% && goto errend
) ELSE (
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\%language%\lp.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component lp.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-WMI.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-WMI.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\%language%\WinPE-WMI_%language%.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-WMI_%language%.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-NetFx.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-NetFx.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\%language%\WinPE-NetFx_%language%.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-NetFx_%language%.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-Scripting.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-Scripting.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\%language%\WinPE-Scripting_%language%.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-Scripting_%language%.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-PowerShell.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-PowerShell.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\%language%\WinPE-PowerShell_%language%.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-PowerShell_%language%.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-StorageWMI.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-StorageWMI.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\%language%\WinPE-StorageWMI_%language%.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-StorageWMI_%language%.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-Dot3Svc.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-Dot3Svc.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\%language%\WinPE-Dot3Svc_%language%.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-Dot3Svc_%language%.cab, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /add-package /packagepath:"%components_dir%\WinPE-FontSupport-%language%.cab" 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed adding component WinPE-FontSupport-%language%.cab, with error %errorlevel% && goto errend
	
	%dism_prog% /image:%mount_dir% /Set-SysLocale:%language% 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed setting sys locale to %language%, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /Set-UserLocale:%language% 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed setting user locale to %language%, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /Set-InputLocale:%language% 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed setting input locale to %language%, with error %errorlevel% && goto errend
	%dism_prog% /image:%mount_dir% /Set-UILang:%language% 1>> %log_file% 2>&1
	if %errorlevel% neq 0 echo Failed setting ui language to %language%, with error %errorlevel% && goto errend
	
)


set /a cur_step=%cur_step%+1
rem ==============================================
rem ======== Adding Mirage to WinPE image ========
rem ==============================================
echo --- Adding Mirage to WinPE image                                (Step %cur_step%  of %total_steps%)
echo --- Adding Mirage to WinPE image >> %log_file%

echo wpeinit > %startnet%
if %errorlevel% neq 0 echo Failed to add step 1 to WinPE startup, with error %errorlevel% && goto errend
echo "x:\Program Files\Wanova\Mirage Service\MirageWinPe%arch%.cmd" %server_address% %server_port% %use_ssl% %use_selfkitting% %log_level% >> %startnet%
if %errorlevel% neq 0 echo Failed to add step 2 to WinPE startus, with error %errorlevel% && goto errend
mkdir "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service"
if %errorlevel% neq 0 echo Failed creating Mirage directory in WinPE image, with error %errorlevel% && goto errend
xcopy "%~dp0..\MirageBins\*" "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service" /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying Mirage binaries to WinPE image, with error %errorlevel% && goto errend

rem Removing alternate data streams content, in case files were copied from internet/network
for /R "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service" %%i in (*) do echo. > %%i:Zone.Identifier


if /I [%~6] == [false] goto skipUseSelfKitting

set /a cur_step=%cur_step%+1
rem ====================================================
rem === Adding Self Kitting components to WinPE image ==
rem ====================================================
echo --- Adding Self Kitting components to WinPE image               (Step %cur_step%  of %total_steps%)
echo --- Adding Self Kitting components to WinPE image >> %log_file%

set certutil=%~dp0..\Utils\nss-3.12.4\bin\certutil.exe
cd %~dp0..\Certificates\Browser
for %%j in (*.cer) DO %certutil% -A -n "%%j" -t "CT,C,C" -d %~dp0..\Browser\Data\Profiles -i "%%j" >> %log_file%
for %%k in (*.crt) DO %certutil% -A -n "%%k" -t "CT,C,C" -d %~dp0..\Browser\Data\Profiles -i "%%k" >> %log_file%
for %%l in (*.pfx) DO %certutil% -A -n "%%l" -t "CT,C,C" -d %~dp0..\Browser\Data\Profiles -i "%%l" >> %log_file%

mkdir "%mount_dir_unquoted%\%browser_path%"
if %errorlevel% neq 0 echo Failed creating Browser directory in WinPE image, with error %errorlevel% && goto errend
xcopy "%~dp0..\Browser\*" "%mount_dir_unquoted%\%browser_path%" /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying Browser to WinPE image, with error %errorlevel% && goto errend

set mozillacfg="%~dp0..\Browser\App\Firefox\mozilla.cfg"
set mozillacfgmodified="%~dp0..\Browser\App\Firefox\mozilla.cfg.modified"
set mozillacfgremote="%mount_dir_unquoted%\%browser_path%\App\Firefox\mozilla.cfg"
copy /Y %mozillacfg% %mozillacfgmodified% >> %log_file%
if %errorlevel% neq 0 echo Failed copying mozilla.cfg for modifying, with error %errorlevel% && goto errend
echo: >> %mozillacfgmodified%
echo lockPref("intl.accept_languages",%locale%); >> %mozillacfgmodified%
copy /Y %mozillacfgmodified% %mozillacfgremote% >> %log_file%
if %errorlevel% neq 0 echo Failed copying mozilla.cfg to WinPE image, with error %errorlevel% && goto errend
del %mozillacfgmodified%

set start_browser_shell="x:\%browser_path%%browser_exe%"
set start_browser_profile="x:\%browser_path%\Data\Profiles"
set start_browser_args="%web_selfkitting_url%/#type=provision&machineName=%%~1"

echo %start_browser_shell% -profile %start_browser_profile% %start_browser_args% > %startbrowser%
if %errorlevel% neq 0 echo Failed to add start browser to WinPE startup, with error %errorlevel% && goto errend
echo powershell -command Stop-Process -processname %browser_process1%* > %closebrowser%
if %errorlevel% neq 0 echo Failed to add start browser to WinPE startup, with error %errorlevel% && goto errend
echo powershell -command Stop-Process -processname %browser_process2%* >> %closebrowser%
if %errorlevel% neq 0 echo Failed to add start browser to WinPE startup, with error %errorlevel% && goto errend

:skipUseSelfKitting
set /a cur_step=%cur_step%+1
rem ====================================================
rem ======== Adding Certificates to WinPE image ========
rem ====================================================
echo --- Adding Certificates to WinPE image                          (Step %cur_step%  of %total_steps%)
echo --- Adding Certificates to WinPE image >> %log_file%

mkdir %mount_dir%\Certificates
if %errorlevel% neq 0 echo Failed creating Certificates directory in WinPE image, with error %errorlevel% && goto errend
xcopy "%~dp0..\Certificates\*" %mount_dir%\Certificates /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying Certificates to WinPE image, with error %errorlevel% && goto errend


set /a cur_step=%cur_step%+1
rem ===============================================
rem ======== Adding Drivers to WinPE image ========
rem ===============================================
echo --- Adding Drivers to WinPE image                               (Step %cur_step%  of %total_steps%)
echo --- Adding Drivers to WinPE image >> %log_file%

%dism_prog% /image:%mount_dir% /add-driver /Driver:"%~dp0..\Drivers" /Recurse 1>> %log_file% 2>&1
rem we want to check this but if no drivers are supplied, dism fails as well...
rem if %errorlevel% neq 0 goto errend 


set /a cur_step=%cur_step%+1
rem ====================================================
rem ========== Adding Scripts to WinPE image ===========
rem ====================================================
echo --- Adding Scripts to WinPE image                               (Step %cur_step%  of %total_steps%)
echo --- Adding Scripts to WinPE image >> %log_file%

mkdir %mount_dir%\Scripts
if %errorlevel% neq 0 echo Failed creating Scripts directory in WinPE image, with error %errorlevel% && goto errend
xcopy "%~dp0..\Scripts\*" %mount_dir%\Scripts /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying Scripts to WinPE image, with error %errorlevel% && goto errend


set /a cur_step=%cur_step%+1
rem ===================================================================
rem ======== Takeown and Grant Permission to Windows Directory ========
rem ===================================================================
echo --- Takeown and Grant Permission to Windows Directory           (Step %cur_step%  of %total_steps%)
echo --- Takeown and Grant Permission to Windows Directory >> %log_file%

takeown /F %mount_dir%\Windows\WinSxs\Backup /A /R /D Y 1>> "%logs_dir%\takeown.log" 2>&1
if %errorlevel% neq 0 echo Failed taking ownership of WinSxs backup directory in WinPE image, with error %errorlevel% && goto errend
takeown /F %mount_dir%\Windows\System32 /A /R /D Y 1>> "%logs_dir%\takeown.log" 2>&1
if %errorlevel% neq 0 echo Failed taking ownership of System32 directory in WinPE image, with error %errorlevel% && goto errend

Icacls %mount_dir%\Windows\WinSxs\Backup /grant BUILTIN\Administrators:M /T /C /Q 1>> "%logs_dir%\icacls.log" 2>&1
if %errorlevel% neq 0 echo Failed granting permissions to WinSxs backup directory in WinPE image, with error %errorlevel% && goto errend
Icacls %mount_dir%\Windows\System32	 /grant BUILTIN\Administrators:M /T /C /Q 1>> "%logs_dir%\icacls.log" 2>&1
if %errorlevel% neq 0 echo Failed granting permissions to System32 directory in WinPE image, with error %errorlevel% && goto errend


set /a cur_step=%cur_step%+1
rem ==========================================================================
rem ======== Removing unneeded files and directories from WinPE image ========
rem ==========================================================================
echo --- Removing unneeded files and directories from WinPE image    (Step %cur_step%  of %total_steps%)
echo --- Removing unneeded files and directories from WinPE image >> %log_file%

rmdir /S /Q %mount_dir%\Windows\WinSxs\Backup 1>> "%logs_dir%\cleanup.log" 2>&1

rmdir /S /Q %mount_dir%\Windows\System32\ar-SA 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\bg-BG 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\cs-CZ 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\da-DK 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\el-GR 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\en-GB 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\es-ES 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\et-EE 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\fi-FI 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\he-IL 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\hr-HR 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\hu-HU 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\it-IT 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\lt-LT 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\lv-LV 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\nb-NO 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\nl-NL 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\pl-PL 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\pt-BR 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\pt-PT 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\ro-RO 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\ru-RU 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\sk-SK 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\sl-SI 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\sr-Latn-CS 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\sr-Latn-RS 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\sv-SE 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\th-TH 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\tr-TR 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\uk-UA 1>> "%logs_dir%\cleanup.log" 2>&1
rmdir /S /Q %mount_dir%\Windows\System32\zh-HK 1>> "%logs_dir%\cleanup.log" 2>&1

if /I NOT [%language%] == [zh-tw] (
	rmdir /S /Q %mount_dir%\Windows\System32\zh-TW 1>> "%logs_dir%\cleanup.log" 2>&1
	rmdir /S /Q "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service\zh-TW" 1>> "%logs_dir%\cleanup.log" 2>&1
)
if /I NOT [%language%] == [zh-cn] (
	rmdir /S /Q %mount_dir%\Windows\System32\zh-CN 1>> "%logs_dir%\cleanup.log" 2>&1
	rmdir /S /Q "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service\zh-CN" 1>> "%logs_dir%\cleanup.log" 2>&1
)
if /I NOT [%language%] == [ja-jp] (
	rmdir /S /Q %mount_dir%\Windows\System32\ja-JP 1>> "%logs_dir%\cleanup.log" 2>&1
	rmdir /S /Q "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service\ja" 1>> "%logs_dir%\cleanup.log" 2>&1
)
if /I NOT [%language%] == [ko-kr] (
	rmdir /S /Q %mount_dir%\Windows\System32\ko-KR 1>> "%logs_dir%\cleanup.log" 2>&1
	rmdir /S /Q "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service\ko" 1>> "%logs_dir%\cleanup.log" 2>&1
)
if /I NOT [%language%] == [fr-fr] (
	rmdir /S /Q %mount_dir%\Windows\System32\fr-FR 1>> "%logs_dir%\cleanup.log" 2>&1
	rmdir /S /Q "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service\fr" 1>> "%logs_dir%\cleanup.log" 2>&1
)
if /I NOT [%language%] == [de-de] (
	rmdir /S /Q %mount_dir%\Windows\System32\de-DE 1>> "%logs_dir%\cleanup.log" 2>&1
	rmdir /S /Q "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service\de" 1>> "%logs_dir%\cleanup.log" 2>&1
)
if /I NOT [%language%] == [es-es] (
	rmdir /S /Q %mount_dir%\Windows\System32\es-ES 1>> "%logs_dir%\cleanup.log" 2>&1
	rmdir /S /Q "%mount_dir_unquoted%\Program Files\Wanova\Mirage Service\es" 1>> "%logs_dir%\cleanup.log" 2>&1
)



set /a cur_step=%cur_step%+1
rem ========================================
rem ======== Committing the changes ========
rem ========================================
echo --- Committing the changes                                      (Step %cur_step%  of %total_steps%)
echo --- Committing the changes >> %log_file%

%dism_prog% %unmount_args% /MountDir:%mount_dir% /Commit >> %log_file%
if %errorlevel% neq 0 echo Failed unmounting WinPE image, with error %errorlevel% && goto errend

rmdir /s /q %mount_dir%


set /a cur_step=%cur_step%+1
rem ========================================
rem ======== Creating the ISO image ========
rem ========================================
echo --- Creating the ISO image                                      (Step %cur_step%  of %total_steps%)
echo --- Creating the ISO image >> %log_file%

mkdir %result_dir%\ISO
if %errorlevel% neq 0 echo Failed creating ISO image directory, with error %errorlevel% && goto errend

set adk_media_dir=%adk_preinstall_dir%\Media

xcopy "%adk_media_dir%\Boot\en-us" %result_dir%\ISO\Boot\en-us /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying boot language to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\Boot\Fonts" %result_dir%\ISO\Boot\Fonts /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying boot fonts to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\Boot\Resources" %result_dir%\ISO\Boot\Resources /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying boot resources to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\Boot\BCD" %result_dir%\ISO\Boot /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying BCD to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\Boot\BOOT.SDI" %result_dir%\ISO\Boot /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying boot.sdi file to ISO image, with error %errorlevel% && goto errend

if [%MIRAGE_VINO_SKIP_BOOTFIX%a] neq [a] goto after_boot_fix
xcopy "%adk_media_dir%\Boot\BOOTFIX.BIN" %result_dir%\ISO\Boot /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying bootfix application to ISO image, with error %errorlevel% && goto errend

:after_boot_fix
xcopy "%adk_media_dir%\Boot\MEMTEST.EXE" %result_dir%\ISO\Boot /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying memtest application to ISO image, with error %errorlevel% && goto errend

xcopy "%adk_media_dir%\en-us" %result_dir%\ISO\en-us /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying language to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\bootmgr" %result_dir%\ISO /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying bootmgr file to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\bootmgr.efi" %result_dir%\ISO /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying bootmgr.efi file to ISO image, with error %errorlevel% && goto errend

mkdir %result_dir%\ISO\EFI\Boot
if %errorlevel% neq 0 echo Failed copying EFI boot directory to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\EFI\Boot\en-us" %result_dir%\ISO\EFI\Boot\en-us /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying EFI boot language to ISO image, with error %errorlevel% && goto errend

set efi_boot_file=bootx64.efi
set efi_boot="%adk_media_dir%\EFI\Boot\%efi_boot_file%"
if not exist %efi_boot% set efi_boot_file=bootia32.efi
set efi_boot="%adk_media_dir%\EFI\Boot\%efi_boot_file%"
xcopy %efi_boot% %result_dir%\ISO\EFI\Boot /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying EFI boot file %efi_boot_file% to ISO image, with error %errorlevel% && goto errend

mkdir %result_dir%\ISO\EFI\Microsoft\Boot
if %errorlevel% neq 0 echo Failed copying EFI boot (MS) to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\EFI\Microsoft\Boot\en-us" %result_dir%\ISO\EFI\Microsoft\Boot\en-us /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying EFI boot (MS) language to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\EFI\Microsoft\Boot\Fonts" %result_dir%\ISO\EFI\Microsoft\Boot\Fonts /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying EFI boot (MS) fonts to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\EFI\Microsoft\Boot\Resources" %result_dir%\ISO\EFI\Microsoft\Boot\Resources /e /h /f /i >> %log_file%
if %errorlevel% neq 0 echo Failed copying EFI boot (MS) resources to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\EFI\Microsoft\Boot\BCD" %result_dir%\ISO\EFI\Microsoft\Boot\ /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying EFI boot (MS) BCD to ISO image, with error %errorlevel% && goto errend
xcopy "%adk_media_dir%\EFI\Microsoft\Boot\memtest.efi" %result_dir%\ISO\EFI\Microsoft\Boot\ /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying EFI boot (MS) memtest.efi file to ISO image, with error %errorlevel% && goto errend


mkdir %result_dir%\ISO\Sources
if %errorlevel% neq 0 echo Failed creating Sources directory in ISO image, with error %errorlevel% && goto errend
move /y %result_dir%\winpe.wim %result_dir%\%wim_name% >> %log_file%
if %errorlevel% neq 0 echo Failed renaming winpe.wim file, with error %errorlevel% && goto errend
xcopy %result_dir%\%wim_name% %result_dir%\ISO\Sources\ /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed moving winpe.wim file to ISO image, with error %errorlevel% && goto errend
move /y %result_dir%\ISO\Sources\%wim_name% %result_dir%\ISO\Sources\boot.wim >> %log_file%
if %errorlevel% neq 0 echo Failed renaming winpe.wim file in ISO image, with error %errorlevel% && goto errend

xcopy "%adk_deployment_tools_dir%\Oscdimg\etfsboot.com" %result_dir%\ /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying etfsboot.com file to ISO image, with error %errorlevel% && goto errend

set efiboot_file=efisys.bin
if [%MIRAGE_VINO_SKIP_BOOTFIX%a] equ [a] goto efiboot_file_determined
set efiboot_file=efisys_noprompt.bin

:efiboot_file_determined
xcopy "%adk_deployment_tools_dir%\Oscdimg\%efiboot_file%" %result_dir%\ /h /f >> %log_file%
if %errorlevel% neq 0 echo Failed copying %efiboot_file% file to ISO image, with error %errorlevel% && goto errend

"%adk_deployment_tools_dir%\Oscdimg\oscdimg" -m -o -n -bootdata:2#p0,e,b%result_dir%\etfsboot.com#pEF,e,b%result_dir%\%efiboot_file% %result_dir%\ISO %result_dir%\%iso_name% 1>> %log_file% 2>&1
if %errorlevel% neq 0 echo Failed making ISO image bootable, with error %errorlevel% && goto errend

rmdir /s /q %result_dir%\ISO
del /f /q %result_dir%\etfsboot.com
del /f /q %result_dir%\efisys.bin

For %%I in (%result_dir%) do set clean_result_dir=%%~I

echo.
echo Operation completed successfully.
echo.
echo *******************************************************************************
echo Mirage WinPE ISO and WIM image are located in:
echo %clean_result_dir%\
echo --- ISO file is %iso_name%
echo --- WIM file is %wim_name%
echo *******************************************************************************

echo Operation completed successfully. >> %log_file%
echo ******************************************************************************* >> %log_file%
echo Your Mirage WinPE ISO and WIM image are ready here: >> %log_file%
echo %clean_result_dir%\ >> %log_file%
echo ISO file is %iso_name% >> %log_file%
echo WIM file is %wim_name% >> %log_file%
echo ******************************************************************************* >> %log_file%
goto end

:errend
echo.
echo Attempting to unmount image for failure cleanup
echo Attempting to unmount image for failure cleanup >> %log_file%
%dism_prog% %unmount_args% /MountDir:%mount_dir% /discard >> %log_file%

echo.
echo *******************************************************************************
echo Error creating Mirage WinPE ISO
echo - Verify that you are using elevated privileges ("run as administrator").
echo - Verify that you installed Windows ADK for Windows 8.1 Update:
echo - - http://www.microsoft.com/en-us/download/details.aspx?id=39982
echo - Output path must not direct to a network location.
echo - Security products, e.g. Antivirus, may be blocking this script.
echo *******************************************************************************
echo ******************************************************************************* >> %log_file%
echo Error creating Mirage WinPE ISO >> %log_file%
echo - Check that you are using an elevated environment ("run as administrator"). >> %log_file%
echo - Make sure Windows ADK for Windows 8.1 Update is installed: >> %log_file%
echo - - http://www.microsoft.com/en-us/download/details.aspx?id=39982 >> %log_file%
echo - Output path cannot point to a network location. >> %log_file%
echo - Security products e.g. Antivirus, may be blocking this script. >> %log_file%
echo ******************************************************************************* >> %log_file%
set exit_code=2
goto end

:usage
echo.
echo *******************************************************************************
echo Edit the script at "%~1" with the following settings:
echo. 
echo   --  ARCHITECTURE   = Must be x86 or amd64
echo.
echo   --  SERVER_ADDRESS = IP address of Mirage server that will manage the
echo                        provisioning operation.
echo.
echo   --  SERVER_PORT    = Port of Mirage server that will manage the
echo                        provisioning operation.
echo.
echo   --  USE_SSL        = Should Mirage client connect to Mirage server
echo                        using SSL. Must be TRUE or FALSE.
echo.
echo   --  USE_SELF_SERVICE_PROVISIONING 
echo                      = Value must be TRUE or FALSE
echo.
echo   --  WEB_SELF_SERVICE_PROVISIONING_URL 
echo                      = Enter the Self Service Provisioning Web Console
echo                        URL, for example: https://address:7443/ssp
echo. 
echo   --  Language       = WinPE locale.
echo.                     = Valid values: 
echo.                     =    zh-CN, zh-TW, de-DE, fr-FR, ja-JP, ko-KR, es-ES
echo                      = Leave it empty will use English locale
echo.         
echo   --  OUTPUT_PATH    = Directory path into which the WinPE creation binaries
echo                        will be compiled. It cannot be a network path.
echo.
echo   --  LOG_LEVEL      = Mirage log level when running in the WinPE environment.
echo                      = Valid values: DEBUG, TRACE, INFO, WARN, VERBOSE
echo                      = Recommended values: DEBUG or TRACE
echo *******************************************************************************
set exit_code=3
goto end

:end
exit /b %exit_code%