''''' Variables '''''
dim sysreportName 
set shellObj = WScript.CreateObject("WScript.Shell")
set fsObj = WScript.CreateObject("Scripting.FileSystemObject")
dim computerName : computerName = GetComputerName()
dim shortPathScriptName : shortPathScriptName = """" & fsObj.GetFile(WScript.ScriptFullName).ShortPath & """"
If computerName = "" Then
	computerName = "UnknownMachineName"
End If
If WScript.Arguments.Count < 2 Then 
	Usage
	Wscript.Quit
End If
Set flags = WScript.Arguments.Named
dim sysReportType : sysReportType = lCase(WScript.Arguments(0))
dim targetFolder : targetFolder = WScript.Arguments(1)
dim forcedSysreportName : forcedSysreportName = nil
if flags.exists("name") then
	forcedSysreportName = flags.item("name")
end if
dim splitSysreport : splitSysreport = -1
if flags.exists("split") then
	splitSysreport = flags.item("split")
end if
if flags.exists("noOutputExtension") then
	noOutputExtension = true
end if
dim maxLogFileSize : maxLogFileSize = 20000000
dim logFileExtenstions : logFileExtenstions = Array("txt","log")
dim winDir
dim tempDir
dim allUsersProfileDir
dim fullProgramFilesDir
dim programFilesDir
dim programDataDir
dim offlineSysreport : offlineSysreport = False
If flags.exists("systemDrive") Then
	offlineSysreport = True
	dim systemDrive : systemDrive = flags.item("systemDrive")
	If flags.exists("winDir") Then 
		winDir = FullFolderShortPath(flags.item("winDir"))
	Else
		winDir = FullFolderShortPath(systemDrive & "\Windows\")
	End If
	If flags.exists("temp") Then 
		tempDir = FullFolderShortPath(flags.item("temp"))
	ElseIf fsObj.FolderExists(FullFolderShortPath(systemDrive & "\temp\")) Then
		tempDir = FullFolderShortPath(systemDrive & "\temp\")
	Else
		tempDir = FullFolderShortPath(shellObj.ExpandEnvironmentStrings("%Temp%"))
	End If
	If flags.exists("allUsersProfile") Then 
		allUsersProfileDir = FullFolderShortPath(flags.item("allUsersProfile"))
	Else
		allUsersProfileDir = FullFolderShortPath(systemDrive & "\Documents and Settings\All Users\")
	End If
	If flags.exists("programFiles") Then 
		fullProgramFilesDir = flags.item("programFiles")
		programFilesDir = FullFolderShortPath(fullProgramFilesDir)
	Else
		fullProgramFilesDir = FullFolderShortPath(systemDrive & "\Program Files\")
		programFilesDir = FullFolderShortPath(fullProgramFilesDir)
	End If
	If flags.exists("programData") Then 
		programDataDir = FullFolderShortPath(flags.item("programData"))
	Else
		programDataDir = FullFolderShortPath(systemDrive & "\ProgramData\")
	End If
Else
	systemDrive = shellObj.ExpandEnvironmentStrings("%SystemDrive%")
	tempDir = FullFolderShortPath(shellObj.ExpandEnvironmentStrings("%Temp%"))
	winDir = FullFolderShortPath(shellObj.ExpandEnvironmentStrings("%windir%"))
	allUsersProfileDir = FullFolderShortPath(shellObj.ExpandEnvironmentStrings("%ALLUSERSPROFILE%"))
	fullProgramFilesDir = shellObj.ExpandEnvironmentStrings("%programfiles%")
	programFilesDir = FullFolderShortPath(shellObj.ExpandEnvironmentStrings("%programfiles%"))
	programDataDir = FullFolderShortPath(shellObj.ExpandEnvironmentStrings("%ProgramData%"))
End If
dim winPeFlag : winPeFlag = flags.exists("winPeFlag")
dim CollectCrashDumpsFlag : CollectCrashDumpsFlag = Not flags.exists("noCrashDumps")
dim quietFlag : quietFlag = flags.exists("quiet")
dim noPrivacyFlag : noPrivacyFlag = flags.exists("noPrivacy")
dim logShell : logShell = true
dim logToFile : logToFile = true
dim logVerbose : logVerbose = false
Dim tempWinDir : tempWinDir = winDir & "\Temp"
dim docsAndsettingsDirWinXp : docsAndsettingsDirWinXp = FullFolderShortPath(allUsersProfileDir & "\..\")
dim microsoftSharedDir : microsoftSharedDir = FullFolderShortPath(fullProgramFilesDir & "\Common Files\Microsoft Shared\")
dim wanovaAppDataDir : wanovaAppDataDir = systemDrive & "\Wanova Volume Information\"
dim clientAppDir : clientAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Mirage Service\")
dim clientLogDir : clientLogDir = FullFolderShortPath(clientAppDir & "\Logs\")
dim serverAppDir : serverAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Mirage Server\")
dim preLayerRecordingDir : preLayerRecordingDir = wanovaAppDataDir & "PreLayerRecording"
dim postLayerRecordingDir : postLayerRecordingDir = wanovaAppDataDir & "PostLayerRecording"
dim managementConsoleAppDir : managementConsoleAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Mirage Management Console\")
dim managementServerAppDir : managementServerAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Mirage Management Server\")
dim webAccessAppDir : webAccessAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Mirage Web Access\")
dim adminWebAccessAppDir : adminWebAccessAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Mirage Admin Web Access\")
dim webManagementAppDir : webManagementAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Mirage Web Management\")
dim rvmWebManagementAppDir : rvmWebManagementAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Rvm\")
dim mirageApiAppDir : mirageApiAppDir = FullFolderShortPath(programFilesDir & "\Wanova\Mirage API\")
dim wanovaProgramDataDir : wanovaProgramDataDir = FullFolderShortPath(programDataDir & "\Wanova Mirage\")
dim mirageEdgeServerDir : mirageEdgeServerDir = FullFolderShortPath(programFilesDir & "\VMware\Mirage Edge Server\")
dim stagingAreaConfigDir : stagingAreaConfigDir = wanovaAppDataDir & "\stagingArea\windows\system32\config\"

dim SccmServerDIR : SccmServerDIR = FullFolderShortPath(programFilesDir & "\SMS_CCM\Logs\")
dim SccmClient32 : SccmClient32 = FullFolderShortPath(winDir & "\System32\CCM\Logs\")
dim SccmClient64: SccmClient64 = FullFolderShortPath(winDir & "\SysWOW64\CCM\Logs\")
dim SccmClient2012 : SccmClient2012 = FullFolderShortPath(winDir & "\CCM\Logs\")

dim IsSccmInstalled : IsSccmInstalled = fsObj.FolderExists(SccmClient64) Or fsObj.FolderExists(SccmClient32) Or fsObj.FolderExists(SccmServerDIR) Or fsObj.FolderExists(SccmClient2012)

Dim scratchPadDir : scratchPadDir = wanovaAppDataDir & "Scratchpad"
dim collectDir : collectDir = tempDir & "\sysreport"
dim ddfFile : ddfFile = tempDir & "\sysreport.ddf"
dim cscript : cscript = winDir & "\system32\cscript.exe"
dim sevenzBinDir : sevenzBinDir = clientAppDir
dim serverToolsExe : serverToolsExe = managementServerAppDir & "\Wanova.Server.Tools.exe"
dim isServerInstalled : isServerInstalled = fsObj.FolderExists(serverAppDir)
dim isClientInstalled : isClientInstalled = fsObj.FolderExists(clientAppDir)
dim isManagementConsoleInstalled : isManagementConsoleInstalled = fsObj.FolderExists(managementConsoleAppDir)
dim isManagementServerInstalled : isManagementServerInstalled = fsObj.FolderExists(managementServerAppDir)
dim isWebAccessInstalled : isWebAccessInstalled = fsObj.FolderExists(webAccessAppDir)
dim isAdminWebAccessInstalled : isAdminWebAccessInstalled = fsObj.FolderExists(adminWebAccessAppDir)
dim isWebManagementInstalled : isWebManagementInstalled = fsObj.FolderExists(webManagementAppDir)
dim isRvmWebManagementInstalled : isRvmWebManagementInstalled = fsObj.FolderExists(RvmWebManagementAppDir)
dim isMirageApiInstalled : isMirageApiInstalled = fsObj.FolderExists(mirageApiAppDir)
Dim edgeServicePath : edgeServicePath = GetServicePathByName("VMware Mirage Edge Service")
Dim IsEdgeServerInstalled : IsEdgeServerInstalled = fsObj.FolderExists(mirageEdgeServerDir)
Dim isEdgeServiceInstalled
If edgeServicePath <> "" Then
	isEdgeServiceInstalled = true
Else
	isEdgeServiceInstalled = false
End If
dim SkipPatrialLogBookCollection : SkipPatrialLogBookCollection = False
dim defaultTimeoutSeconds : defaultTimeoutSeconds = 60 * 5
Dim oneMinuteTimeoutSeconds : oneMinuteTimeoutSeconds = 60
dim twentyMinutesTimeoutSeconds : twentyMinutesTimeoutSeconds = 20*60
dim twoHoursTimeoutSeconds : twoHoursTimeoutSeconds = 120*60
dim stepNum : stepNum = 1
dim productName : productName = "VMware Mirage"
dim IISAppDataDir : IISAppDataDir = systemDrive & "\inetpub"
dim IISLogsDir : IISLogsDir = IISAppDataDir & "\logs\LogFiles"

dim typeOfSysReport : typeOfSysReport = ""
sub initializeTypeOFSysReport()
	if isServerInstalled Then typeOfSysReport = typeOfSysReport & "Server_"
	if isManagementConsoleInstalled Then typeOfSysReport = typeOfSysReport & "MMC_"
	if isManagementServerInstalled Then typeOfSysReport = typeOfSysReport & "Management_"
	if isClientInstalled Then typeOfSysReport = typeOfSysReport & "Client_"
	if isWebAccessInstalled Then typeOfSysReport = typeOfSysReport & "WebAccess_"
	if isAdminWebAccessInstalled Then typeOfSysReport = typeOfSysReport & "AdminWebAccess_"
	if isWebManagementInstalled Then typeOfSysReport = typeOfSysReport & "WMC_"
	if isRvmWebManagementInstalled Then typeOfSysReport = typeOfSysReport & "RvmWMC_"
	if isMirageApiInstalled Then typeOfSysReport = typeOfSysReport & "API_"
end sub


initializeTypeOFSysReport() 

'''' A/V and security product ''''

''' dim mcafeeDesktopProtectionPath : mcafeeDesktopProtectionPath = shellObj.ExpandEnvironmentStrings("%DEFLOGDIR%") '''
dim mcafeeCommonFrameworkPath : mcafeeCommonFrameworkPath = FullFolderShortPath(programDataDir & "\McAfee\Common Framework\DB\")
dim mcafeeDesktopProtectionPath : mcafeeDesktopProtectionPath = FullFolderShortPath(programDataDir & "\McAfee\DesktopProtection\")
dim isMcafeeInstalled : isMcafeeInstalled = fsObj.FolderExists(mcafeeCommonFrameworkPath) or fsObj.FolderExists(mcafeeDesktopProtectionPath)
dim symantecPath : symantecPath = FullFolderShortPath(programDataDir & "\Symantec\Symantec Endpoint Protection")
dim symantecLogsPath : symantecLogsPath = FullFolderShortPath(programDataDir & "\Symantec\Symantec Endpoint Protection\CurrentVersion\Data\Logs\")
dim isSymantecInstalled : isSymantecInstalled = fsObj.FolderExists(symantecPath)

dim kasperskyLogsPath : kasperskyLogsPath = FullFolderShortPath(programDataDir & "\Kaspersky Lab\AVP8\")
dim kasperskyEndPointSecurityLogsPath : kasperskyEndPointSecurityLogsPath = FullFolderShortPath(programDataDir & "\Kaspersky Lab")
dim kasperskyFilterDriverPath : kasperskyFilterDriverPath = winDir & "\system32\drivers\klif.sys"
dim isKasperskyInstalled : isKasperskyInstalled = fsObj.FileExists(kasperskyFilterDriverPath)

dim trendmicroLogsPath : trendmicroLogsPath = FullFolderShortPath(programDataDir & "\Trend Micro\Internet Security\Log\")
dim isTrendMicroInstalled : isTrendMicroInstalled = fsObj.FolderExists(trendmicroLogsPath)
dim sophosAVLogsPath : sophosAVLogsPath = FullFolderShortPath(programDataDir & "\Sophos\Sophos Anti-Virus\logs\")
dim sophosFWLogsPath : sophosFWLogsPath = FullFolderShortPath(programDataDir & "\Sophos Client Firewall\Logs\")
dim isSophosInstalled : isSophosInstalled = fsObj.FolderExists(sophosAVLogsPath) or fsObj.FolderExists(sophosFWLogsPath)
dim isRunningOn64Bit : isRunningOn64Bit = Is64BitOs()
'''' Make sure cscript is used ''''

ForceUseCScript
ElevateToAdmin

sub Usage()
	Wscript.Echo "Usage: cscript " & fsObj.GetFile(WScript.ScriptFullName).Name & " [Level] [Path]" & vbNewLine & vbNewLine & _ 
	 "Optional: /Quiet - Quiet mode, no message boxes" & vbNewLine & _  
	 "Optional: /NoCrashDumps - No crash dumps" & vbNewLine & _ 
	 "Optional: /name:[name] - Force Sysreport name" & vbNewLine & _ 
	 "Optional: /split:[sizeMB] - split the sysreport to files of size in MB" & vbNewLine & _ 
	 "Optional: /systemDrive:[systemDrive] - offline sysreport capture, example: /systemDrive:z:" & vbNewLine & _ 
	 "Optional: /winDir:[winDir] - only works in offline, default value:'Windows'" & vbNewLine & _ 
	 "Optional: /temp:[tempDir] - only works in offline, default value:'%WinDir%\temp'" & vbNewLine & _ 
	 "Optional: /allUsersProfile:[allUsersProfileDir] - only works in offline, default value:'%systemDrive%\Documents and Settings\All Users\'" & vbNewLine & _ 
	 "Optional: /programFiles:[programFilesDir] - only works in offline, default value:'%systemDrive%\Program Files\'" & vbNewLine & _ 
	 "Optional: /programData:[programDataDir] - only works in offline, default value:'%systemDrive%\ProgramData\'"
End Sub

Function GetComputerName()
	On Error Resume Next
		set ntInfoObj = CreateObject("WinNTSystemInfo")
		GetComputerName = lcase(ntInfoObj.ComputerName)
End Function

Sub ForceUseCScript()
	If right(lCase(wscript.fullname),11) = "wscript.exe" then
		dim args : args = ""
		for i = 0 to wscript.arguments.count-1
			args = args & wscript.arguments(i) & " "
		next
		shellObj.Run cscript & " " & shortPathScriptName & " " & args, 0, true
		WScript.Quit 0
	End If
End Sub 

Function IsXP()
	strComputer = "."
	Set objWMIService = GetObject("winmgmts:" _
	& "{impersonationLevel=impersonate}!\\" _
	& strComputer & "\root\cimv2")
	Set colOperatingSystems = objWMIService.ExecQuery _
	    ("Select * from Win32_OperatingSystem")
	For Each objOperatingSystem in colOperatingSystems
		if InStr (objOperatingSystem.Caption,"XP") <> 0 Then
			IsXP = True
			Exit Function
		End If
	Next
	IsXP = False
End Function

Sub ElevateToAdmin()
	If IsXP or quietFlag Then
		exit Sub
	End If
	If flags.Exists("elevated") = False Then
		dim args : args = ""
		for i = 0 to wscript.arguments.count-1
			args = args & wscript.arguments(i) & " "
		next
		CreateObject("Shell.Application").ShellExecute cscript , shortPathScriptName & " " & args & " /elevated", "", "runas", 2
		WScript.Quit 0
	End If
End Sub 

''''' Open Log File '''''

CreateCollectDir()
set logFile = fsObj.CreateTextFile(collectDir &  "\sysreport.log", True, True)
Log("Temp dir = " & tempDir & ", system drive = " & systemDrive)

if isServerInstalled Then Log("Mirage Server is installed!")
if isManagementConsoleInstalled Then Log("Mirage Management Console is installed!")
if isManagementServerInstalled Then Log("Mirage Management Server is installed!")
if isClientInstalled Then Log("Mirage Client is installed!")
if isWebAccessInstalled Then Log("Web Access is installed!")
if isAdminWebAccessInstalled Then Log("Admin Web Access is installed!")
if isWebManagementInstalled Then Log("Web Management is installed!")
if isRvmWebManagementInstalled Then Log("Rvm Web Management is installed!")

''''' Helper functions '''''

Function FullFolderShortPath(relPath)
	On Error Resume Next
	if fsObj.FolderExists(relPath) Then
		FullFolderShortPath = fsObj.GetFolder(relPath).ShortPath
	else
		FullFolderShortPath = relPath
	end if
End Function

Function TimeStamp()
	 TimeStamp = Date() & " " & Time()
End Function

Sub PrintStep(message)
	dim fullMessage : fullMessage = TimeStamp() & "  -- Step " & stepNum & ":  " & message & ".."
	stepNum = stepNum + 1
	if (not quietFlag) then
		Wscript.StdOut.WriteLine(fullMessage)
	end if
	On Error Resume Next
	if logToFile Then logFile.WriteLine(fullMessage)
End Sub


Sub Log(message)
	dim fullMessage : fullMessage = TimeStamp() & " " &  message
	if (not quietFlag) then
		if logVerbose Then Wscript.StdOut.WriteLine(fullMessage)
	end if
	On Error Resume Next
	if logToFile Then logFile.WriteLine(fullMessage)
End Sub

Sub RunShellInDir(command, workingDirectory)
    RunShellWithTimeoutInDir command, workingDirectory, defaultTimeoutSeconds
End Sub

Sub RunShellWithTimeoutInDir(command, workingDirectory, timeoutSeconds)
	if (Not fsObj.FolderExists(workingDirectory)) Then
		If logShell Then Log("Skipping " & Command & ", working directory does not exist: " & workingDirectory)
		Exit Sub
	end if

	If logShell Then Log("Changing directory to: " & workingDirectory)
	dim previousDirectory :	previousDirectory = shellObj.CurrentDirectory
	shellObj.CurrentDirectory = workingDirectory
	RunShellWithTimeout Command, timeoutSeconds
	shellObj.CurrentDirectory = previousDirectory
End Sub

Sub RunShell(command)
    RunShellWithTimeout command, defaultTimeoutSeconds
End Sub

Sub RunShellWithTimeout(command, timeoutSeconds)
	command = "cmd /C """ & command & """"
	If logShell Then Log("Running shell command: " & command)
	set execObj = shellObj.Exec(command)
	for i = 0 to (10 * timeoutSeconds)
	    if (execObj.Status = 1) then exit for
	    Wscript.sleep 100
	next
	if (execObj.Status = 0) then
	    Log("Execution of shell command: <" & command & "> timed out after (" & timeoutSeconds & ") seconds. Terminating.")
	    execObj.Terminate
	else
	    If logShell Then Log("Completed execution of shell command: <" & command & "> With status (" & execObj.ExitCode & ")")
	    If not (execObj.ExitCode = 0) Then Log("FAILED execution of shell command: <" & command & "> With status (" & execObj.ExitCode & ")")
	end if
End Sub

function RunShellWithTimeoutAndReturnValue(command, timeoutSeconds)
	command = "cmd /C """ & command & """"
	If logShell Then Log("Running shell command: " & command)
	set execObj = shellObj.Exec(command)
	for i = 0 to (10 * timeoutSeconds)
	    if (execObj.Status = 1) then exit for
	    Wscript.sleep 100
	next
	if (execObj.Status = 0) then
	    Log("Execution of shell command: <" & command & "> timed out after (" & timeoutSeconds & ") seconds. Terminating.")
	    execObj.Terminate
	else
	    If logShell Then Log("Completed execution of shell command: <" & command & "> With status (" & execObj.ExitCode & ")")
	    If not (execObj.ExitCode = 0) Then Log("FAILED execution of shell command: <" & command & "> With status (" & execObj.ExitCode & ")")
	end if
	RunShellWithTimeoutAndReturnValue = execObj.ExitCode
End function

Sub RunShellWithTimeoutAndShowOutput(command, timeoutSeconds)
	command = "cmd /C """ & command & """"
	If logShell Then Log("Running shell command: " & command)
	set execObj = shellObj.Exec(command)
	for i = 0 to (10 * timeoutSeconds)
		if Not execObj.StdOut.AtEndOfStream then
			stdoutRead = execObj.StdOut.ReadAll()
			if (not quietFlag) then
				Log stdoutRead
				if not logVerbose Then Wscript.StdOut.WriteLine(stdoutRead)
			end if
		end if
	    if (execObj.Status = 1) then exit for
	    Wscript.sleep 100
	next
	if (execObj.Status = 0) then
	    Log("Execution of shell command: <" & command & "> timed out after (" & timeoutSeconds & ") seconds. Terminating.")
	    execObj.Terminate
	else
	    If logShell Then Log("Completed execution of shell command: <" & command & "> With status (" & execObj.ExitCode & ")")
	    If not (execObj.ExitCode = 0) Then Log("FAILED execution of shell command: <" & command & "> With status (" & execObj.ExitCode & ")")
	end if
End Sub

Sub Unlock()
	if isClientInstalled Then RunShell("""" & clientAppDir & "\Wanova.Desktop.Control.exe"" unlock")
End Sub

Sub Lock()
	if isClientInstalled Then RunShell("""" & clientAppDir & "\Wanova.Desktop.Control.exe"" lock")
End Sub

Sub CollectLog(outputFilename)
	Log("Collecting " & outputFilename)
End Sub

Sub CollectCommand(command, outputFilename)
	CollectLog(outputFilename)
	RunShell(command & " > """ & collectDir & "\" & outputFilename & """")
End Sub

function CollectCommandWithTimeoutReturnValue(command, outputFilename, timeoutSeconds)
	CollectLog(outputFilename)
	CollectCommandWithTimeoutReturnValue = RunShellWithTimeoutAndReturnValue(command & " > """ & collectDir & "\" & outputFilename & """", timeoutSeconds)
End function 

Sub CollectCommandWithTimeout(command, outputFilename, timeoutSeconds)
	CollectLog(outputFilename)
	RunShellWithTimeout command & " > """ & collectDir & "\" & outputFilename & """", timeoutSeconds
End Sub

Sub CollectCommandInDir(command, workingDirectory, outputFilename)
	CollectLog(outputFilename)
	RunShellInDir command & " > " & collectDir & "\" & outputFilename, workingDirectory
End Sub

Sub CollectCommandNoOutput(command)
	CollectLog(command)
	RunShell(command)
End Sub

Sub CollectCommandNoOutputWithTimeout(Command, timeoutSeconds)
	CollectLog(Command)
	RunShellWithTimeout Command, timeoutSeconds
End Sub

Sub CollectFile(path, outputFilename)
	dim filesize : filesize = 0
	if not fsObj.FileExists(path) then
		Log("Collecting <" & path & "> may fail as it doesn't seem to exist! (unless it's a wildcard)")
	else
		set file = fsObj.GetFile(path)
		filesize = file.size
	end if
	CollectLog(path & "-->" & outputFilename)
	Err.Clear
	On Error Resume Next
	fsObj.CopyFile path, collectDir & "\" & outputFilename
	if Err.Number <> 0 then Log("FAILED copying! Error number: " & Err.Number & " " & "Error description: " & Err.Description)
End Sub

Sub MakeDirectory(path)
	If (not fsObj.FolderExists(path)) Then
		fsObj.CreateFolder(path)
	End If
End Sub

Sub MakeCollectSubDir(subDir)
	MakeDirectory(collectDir & "\" & subDir)
End Sub

Sub CreateCollectDir()
	If (fsObj.FolderExists(collectDir)) Then
		fsObj.DeleteFolder collectDir, true
	End If
	fsObj.CreateFolder(collectDir)
End Sub

Sub CollectSecurityProductsLogs()
	PrintStep("Collecting A/V and security products logs")
	const recursive = True
	MakeCollectSubDir "Security"
	if isMcafeeInstalled then
		CollectSecurityFolderFiles mcafeeCommonFrameworkPath, "Security\McAfee CommonFramework", recursive
		CollectSecurityFolderFiles mcafeeDesktopProtectionPath, "Security\McAfee DesktopProtection", recursive
	end if
	if isSymantecInstalled then
		CollectSecurityFolderFiles symantecLogsPath, "Security\Symantec", recursive 
	end if
	if isKasperskyInstalled then
		CollectSecurityFolderFiles kasperskyLogsPath, "Security\Kaspersky", recursive
	end if
	if isTrendMicroInstalled then
		CollectSecurityFolderFiles trendmicroLogsPath, "Security\Trend Micro", recursive
	end if
	if isSophosInstalled then
		CollectSecurityFolderFiles sophosAVLogsPath, "Security\Sophos Anti-Virus", recursive
		CollectSecurityFolderFiles sophosFWLogsPath, "Security\Sophos Client Firewall", recursive
	end if
End Sub

Sub CollectIISFiles()
	PrintStep("Collecting IIS information")
	const recursive = True
	MakeCollectSubDir "IIS"
	CollectFolderFiles IISLogsDir, "IIS\LogFiles", recursive
	CollectFolderFiles winDir & "\System32\LogFiles\HTTPERR",  "IIS\HTTPERR", recursive
	CollectCommand winDir & "\system32\inetsrv\appcmd list apppools /xml", "IIS\application_pools.txt"
	CollectCommand winDir & "\system32\inetsrv\appcmd list config /xml", "IIS\IIS_config.txt"
End Sub

Sub CollectSrumDb()
	CollectFile winDir & "\System32\sru\SRUDB.dat", "SystemLogs\SRUDB.dat.edb"
End Sub

Sub CollectEventLogsWithEventquery (eventQueryPath)
	CollectCommand "cscript " & eventQueryPath & " /V /r 5000 /l system", "EventLogs\system.txt"
	CollectCommand "cscript " & eventQueryPath & " /v /r 5000 /l application", "EventLogs\application.txt"
	CollectCommand "cscript " & eventQueryPath & " /v /r 5000 /l security", "EventLogs\security.txt"
	CollectCommand "cscript " & eventQueryPath & " /v /r 5000 /l ""Wanova Mirage""", "EventLogs\wanova.txt"
End Sub

Sub CollectEventLogWithWevtutil (eventLogName)
	RunShell("wevtutil epl " & eventLogName & " " & collectDir & "\EventLogs\" & eventLogName & ".evtx 2>1 > NUL")
	CollectCommand "wevtutil qe " & eventLogName & " /f:text /c:10000 /rd", "EventLogs\" & eventLogName & ".evtx.txt" 
End Sub

Sub CollectEventLogsWithWevtutil ()
	CollectCommand "wevtutil el", "EventLogs\AllMachineLogs.txt"
	CollectDirList winDir & "\system32\Winevt\Logs" , "EventLogs\LogFilesInWinevtFolder.txt"
	CollectEventLogWithWevtutil("system")
	CollectEventLogWithWevtutil("application")
	CollectEventLogWithWevtutil("security")
End Sub

Sub CollectEventLogWithWmi (eventLogName)
	strComputer = "." 
	Set objWMIServiceBackup = GetObject("winmgmts:" _ 
		& "{impersonationLevel=impersonate,(Backup,Security)}!\\" & _ 
			strComputer & "\root\cimv2") 
 
	Set colLogFiles = objWMIServiceBackup.ExecQuery _ 
	    ("Select * from Win32_NTEventLogFile where LogFileName='" & eventLogName & "'") 
 
	For Each objLogfile in colLogFiles 
	    errBackupLog = objLogFile.BackupEventLog(collectDir & "\EventLogs\" & eventLogName & ".evt") 
	    If errBackupLog <> 0 Then         
	        Wscript.Echo "The " & eventLogName & " event log could not be backed up." 
	    End If
	Next 
End Sub

Sub CollectEventLogsWithWmi()
	CollectEventLogWithWmi("Application")
	CollectEventLogWithWmi("System")
	CollectEventLogWithWmi("Security")
End Sub

Sub CollectEventLog()
	PrintStep("Collecting primary event logs")
	MakeCollectSubDir "EventLogs"
	Dim eventQuery
	eventQueryPath = winDir & "\system32\eventquery.vbs"
	wevtutilPath = winDir & "\system32\wevtutil.exe"
	If fsObj.FileExists(eventQueryPath) then
		CollectEventLogsWithEventquery(eventQueryPath)
	ElseIf fsObj.FileExists(wevtutilPath) then
		CollectEventLogsWithWevtutil()
	Else
		CollectEventLogsWithWmi()
	End If
End Sub

Sub CollectExtendedEventLog()
	PrintStep("Collecting extra event logs")
	dim logName
	const ReadingMode=1
	LogsList = collectDir & "\EventLogs\AllMachineLogs.txt"
	On Error Resume Next
	If fsObj.FileExists(LogsList) Then
		MakeCollectSubDir "EventLogs\OtherLogs"
		Set FileObject = fsObj.OpenTextFile(LogsList, ReadingMode)
		Do While FileObject.AtEndOfStream <> true
			logName = FileObject.ReadLine
			RunShell("wevtutil epl """ & logName & """ """ & collectDir & "\EventLogs\OtherLogs\" & Replace(logName,"/","%4") & ".evtx""  2>1 > NUL")
		Loop
	FileObject.Close
	Else
		Log("The file AllMachineLogs.txt is missing. File should be present on Windows 7 machine.")
	End If
End Sub

Sub CollectVssAdmin()
	PrintStep("Collecting vss admin files")
	MakeCollectSubDir "VSS"
	CollectCommand "vssadmin list writers", "VSS\writers.txt"
	CollectCommand "vssadmin list providers", "VSS\providers.txt"
	CollectCommand "vssadmin list shadows", "VSS\shadows.txt"
	CollectCommand "vssadmin list shadowstorage", "VSS\shadowstorage.txt"
End Sub

sub PingServer(output)	
	dim configPath
	If fsObj.FileExists(clientAppDir + "/Wanova.Desktop.Service.exe.config") then 
		configPath = clientAppDir + "/Wanova.Desktop.Service.exe.config"
	ElseIf fsObj.FileExists(clientAppDir + "/Wanova.Desktop.PE.exe.config") then 
		configPath = clientAppDir + "/Wanova.Desktop.PE.exe.config"
	Else
		Exit Sub
	End if
	
	PingServerByConfig configPath, output
End sub

sub PingServerByConfig(configPath, output)	
	set objXML = CreateObject("Microsoft.XMLDOM")
	objXML.load(configPath)
	dim ServerAdress : ServerAdress = Cstr(objXML.SelectSingleNode("/configuration/appSettings/add[@key='serverAddress']/@value").text)
	if InStr(ServerAdress,":") then
		ServerAdress = Left(ServerAdress,InStr(ServerAdress,":")-1)
	End if
	CollectCommand "ping " & ServerAdress, output
End sub


Function GetServicePathByName(strServiceName)
	dim servicePath : servicePath = ""
	strComputer = "."
	Set objWinMgmt = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")
	Set lstServices = objWinMgmt.ExecQuery("SELECT * from Win32_Service WHERE Name = '" & strServiceName & "'")
	For Each service in lstServices
		servicePath = service.PathName
	Next
	If servicePath <> "" Then
		Dim strippedServicePath : strippedServicePath = ""
		strippedServicePath = Replace(servicePath, """", "")
		If fsObj.FileExists(strippedServicePath) Then
			Set objFile = fsObj.GetFile(strippedServicePath)
			strFileName = objFile.Name
			strFilePath = objFile.Path
			servicePath = Left(strFilePath, Len(strFilePath) - Len(strFileName))
		Else
			servicePath = ""
		End If
	End If
	GetServicePathByName = servicePath
End Function

Sub CollectCommonCommands()
	MakeCollectSubDir "Commands"
	if isClientInstalled Then PingServer "Commands\pingServer.txt"
	CollectCommand "hostname", "Commands\hostname.txt"
	CollectCommand "netstat -r", "Commands\route.txt"
	CollectCommand "net use", "Commands\netuse.txt"
	CollectCommand "fltmc", "Commands\fltmc.txt"
	CollectCommand "driverquery /V", "Commands\driversVerboseInfo.txt"
	CollectCommand "driverquery /SI", "Commands\driversSignatureInfo.txt"
	CollectCommand "typeperf ""\Processor(_Total)\% Processor Time"" ""\Memory\Available MBytes"" ""\LogicalDisk(_Total)\Avg. Disk Bytes/Read"" ""\LogicalDisk(_Total)\Avg. Disk Bytes/Write"" ""\LogicalDisk(_Total)\Avg. Disk Bytes/Transfer"" -sc 10", "Commands\perfmon.txt" 
	CollectCommand "cscript %SystemDrive%\Inetpub\AdminScripts\AdsUtil.vbs enum w3svc", "Commands\iis_info.txt"
	CollectCommand "%windir%\system32\inetsrv\appcmd list app", "Commands\iis_apps.txt"
	CollectCommand "%windir%\system32\inetsrv\appcmd list apppool", "Commands\iis_apppools.txt"
	CollectCommand "%windir%\system32\inetsrv\appcmd list vdir", "Commands\iis_vdirs.txt"
	CollectCommand "%windir%\system32\inetsrv\appcmd list config", "Commands\iis_config.xml"
	CollectCommand "%windir%\system32\inetsrv\appcmd list module", "Commands\iis_modules.txt"

	if IsNt6() then
		CollectCommandWithTimeout "wmic /namespace:\\root\Microsoft\Windows\Storage PATH MSFT_Disk", "Commands\MsftDisk.txt", oneMinuteTimeoutSeconds
		CollectCommandWithTimeout "wmic /namespace:\\root\Microsoft\Windows\Storage PATH MSFT_Volume", "Commands\MsftVolume.txt", oneMinuteTimeoutSeconds
		CollectCommandWithTimeout "wmic /namespace:\\root\Microsoft\Windows\Storage PATH MSFT_Partition", "Commands\MsftPartition.txt", oneMinuteTimeoutSeconds
	
		CollectCommandWithTimeout "wmic PATH SoftwareLicensingProduct", "Commands\SoftwareLicenses.txt", oneMinuteTimeoutSeconds
		CollectCommandWithTimeout "wmic PATH SoftwareLicensingProduct where LicenseStatus=1", _
					  "Commands\LicensedSoftwareLicenses.txt", _
					  oneMinuteTimeoutSeconds
		CollectCommandWithTimeout  "wmic path win32_DisplayConfiguration", "Commands\DisplaySettings.txt", oneMinuteTimeoutSeconds
		CollectCommand cscript & " /NoLogo " & winDir & "\system32\slmgr.vbs /xpr", "Commands\slmgr_xpr.txt"
		CollectCommand cscript & " /NoLogo " & winDir & "\system32\slmgr.vbs /dlv", "Commands\slmgr_dlv.txt"
		CollectCommand "powershell -Command Get-ChildItem -Recurse Cert:", "Commands\Certificates.txt"
	end if

	CollectCommandWithTimeout "wmic PATH OfficeSoftwareProtectionProduct", _
				  "Commands\OfficeSoftwareProtectionProduct.txt", _
				  oneMinuteTimeoutSeconds
	CollectCommand cscript & " /NoLogo """ & programFilesDir & "\Microsoft Office\Office14\ospp.vbs"" /dstatusall", "Commands\ospp_dstatusall.txt"
	CollectCommand cscript & " /NoLogo """ & programFilesDir & "\Microsoft Office\Office15\ospp.vbs"" /dstatusall", "Commands\ospp_dstatusall.txt"
	CollectVssAdmin()
End Sub

Sub CollectAdditionallCommands()
	CollectCommand "ipconfig /all", "Commands\ipconfig.txt"
	CollectCommand "netstat -aon", "Commands\connections.txt"
	CollectCommand "netstat -es", "Commands\netstat.txt"
	CollectCommand "systeminfo", "Commands\systeminfo.txt"
	CollectCommand "tasklist /V /FO CSV", "Commands\tasklist.csv"
End Sub

Sub CollectFullCommands()
	PrintStep("Collecting information about current system status")
	CollectCommonCommands()
	if sysReportType <> "view" then 
		CollectAdditionallCommands()
	end if

End Sub

Sub CollectDirList(path, outputFilename)
	if not fsObj.FolderExists(path) then
		Log("Collecting folder <" & path & "> may fail as it doesn't seem to exist! (unless it's a wildcard)")
		exit sub
	end if
	CollectLog(outputFilename)
	CollectCommand "dir /s /x /q """ & path & """", outputFilename
End Sub

Sub CollectDirLists()
	MakeCollectSubDir "DirLists"
	if isClientInstalled Then CollectDirList clientAppDir, "DirLists\client_app.txt"
	if isClientInstalled Then CollectDirList wanovaAppDataDir, "DirLists\client_data.txt"
	if isServerInstalled Then CollectDirList serverAppDir, "DirLists\server_app.txt"
	if isManagementConsoleInstalled Then CollectDirList managementConsoleAppDir, "DirLists\management_console_app.txt"
	if isManagementServerInstalled Then CollectDirList managementServerAppDir, "DirLists\management_server_app.txt"
	if isManagementServerInstalled Then RunShellWithTimeout serverToolsExe & " VolumeDirList localhost "& collectDir & "\DirLists\volumes_root.txt" , twentyMinutesTimeoutSeconds
End Sub

Sub CollectFiles()
	CollectSystemFiles()
	if isClientInstalled Then CollectDesktopFiles()
	if isServerInstalled Then CollectServerFiles()
	if isManagementServerInstalled Then CollectManagementServerFiles()
	if isWebAccessInstalled Then CollectWebAccessFiles()
	if isAdminWebAccessInstalled Then CollectAdminWebAccessFiles()
	if isWebManagementInstalled Then CollectWebManagementFiles()
	if isRvmWebManagementInstalled Then CollectRvmWebManagementFiles()
	if isMirageApiInstalled Then CollectMirageApiFiles()
	if IsSccmInstalled Then CollectSccmLogs()
	CollectSecurityProductsLogs()
	CollectSrumDb()
End Sub

Sub CollectSystemLogs()
	PrintStep("Collecting system log files")
	MakeCollectSubDir "SystemLogs"
	MakeCollectSubDir "SystemLogs\WindowsUpdateLogs"
	CollectFile winDir & "\WindowsUpdate.log", "SystemLogs\WindowsUpdateLogs\WindowsUpdate.log"
	CollectFile winDir & "\System32\catroot2\dberr.txt", "SystemLogs\catroot2_dberr.txt"
	CollectFile winDir & "\dpinst.log", "SystemLogs\dpinst.log"
	CollectFile winDir & "\setupapi.log", "SystemLogs\setupapi.log"
	CollectFile winDir & "\setupact.log", "SystemLogs\setupact.log"
	CollectFile winDir & "\setuperr.log", "SystemLogs\setuperr.log"
	CollectFile winDir & "\inf\setupapi.app.log", "SystemLogs\setupapi.app.log"
	CollectFile winDir & "\inf\setupapi.dev.log", "SystemLogs\setupapi.dev.log"
	CollectFile winDir & "\inf\setupapi.offline.log", "SystemLogs\setupapi.offline.log"
	CollectFile winDir & "\debug\netsetup.log", "SystemLogs\netsetup.log"
	CollectFile winDir & "\Wdf*.log", "SystemLogs\"
	CollectFile winDir & "\Logs\CBS\*", "SystemLogs\"
	CollectFile winDir & "\Logs\WindowsUpdate\*", "SystemLogs\WindowsUpdateLogs\"
End Sub

Sub CollectUsmtLogs()
	PrintStep("Collecting usmt log files")
	MakeCollectSubDir "UsmtLogs"
	
	CollectFile winDir & "\WDL\USMT\Launch_USMT.cmd", "\UsmtLogs\Launch_USMT.cmd"
	CollectFile "c:\Windows.old\Offline.xml", "\UsmtLogs\Offline.xml"
	
	If NOT fsObj.FolderExists(tempWinDir) Then
		Exit Sub
	End If
	
    Set files = fsObj.GetFolder(tempWinDir).Files
    For each file In files
		Dim fileName : fileName = file.Name
		If (InStr(fileName, "scanstate") = 1) Or (InStr(fileName, "loadstate") = 1) Or (InStr(fileName, "scan_progress") = 1) Or (InStr(fileName, "load_progress") = 1) Or (InStr(fileName, "usmt_script_progress") = 1) Or (InStr(fileName, "MigLog") = 1) Then
			CollectFile tempWinDir & "\" & fileName, "\UsmtLogs\" & fileName
		End If	
    Next

End Sub

Sub CollectSystemFiles()
	PrintStep("Collecting system configuration files")
	MakeCollectSubDir "SystemFiles"
	CollectFile systemDrive & "\boot.ini", "SystemFiles\boot.ini"
	CollectFile systemDrive & "\autoexec.bat", "SystemFiles\autoexec.bat"
	CollectFile docsAndsettingsDirWinXp & "\default user\ntuser.dat", "SystemFiles\default_xp_ntuser.dat"
	CollectFile systemDrive & "\Users\Default\ntuser.dat", "SystemFiles\default_7_ntuser.dat"
End Sub

Sub CollectMetroDb()
	MakeCollectSubDir "SystemFiles\Metro"
	CollectFile programDataDir & "\Microsoft\Windows\AppRepository\StateRepository-*", "SystemFiles\Metro\"
End Sub

Sub CollectDesktopFiles()
	PrintStep("Collecting mirage client files")
	MakeCollectSubDir "DesktopFiles"
	CollectFolderFiles wanovaAppDataDir, "DesktopFiles", False
	CollectFile clientAppDir & "\Wanova.Desktop.Service.exe.config", "DesktopFiles\Wanova.Desktop.Service.exe.config"
End Sub

Sub CollectServerFiles()
	PrintStep("Collecting mirage server files")
	MakeCollectSubDir "ServerFiles"
	CollectFile serverAppDir &  "\*.config",  "ServerFiles\"
End Sub

Sub CollectServerLogs()
	PrintStep("Collecting mirage server logs")
	MakeCollectSubDir "ServerLogs"
	CollectFile serverAppDir &  "\logs\server.log*.*",  "ServerLogs\"
	CollectFile serverAppDir &  "\logs\server-long-duration.log*.*",  "ServerLogs\"
	CollectFile serverAppDir &  "\logs\server_stat.log*.*",  "ServerLogs\"
	CollectFile serverAppDir &  "\logs\server_activity.log*.*",  "ServerLogs\"
End Sub

Sub CollectServerDbAsCsv()
	PrintStep("Collecting DB information as csv")
	MakeCollectSubDir "ServerDB"
	exportDbFlags = " /timeinterval:60 /maxevents:100000 /parse "
	collectDbCmd = """" & serverToolsExe & """ ExportDatabase """ & managementServerAppDir & """" & exportDbFlags
	collectDbResult = CollectCommandWithTimeoutReturnValue (collectDbCmd, "ServerDB\ExportedMirageDB.csv", twentyMinutesTimeoutSeconds)
	if collectDbResult <> 0 then 
		Log ("No connetion to DB")
		if quietFlag = True Then
			Exit Sub
		End If

		dim answer
		answer = msgbox ("Can't connect to SQL database, please check user credentials and SQL server connectivity."  & vbCRLF &  "Ok to gather partial sysreport, Cancel to abort.", 49 , productName)
		if answer = 2 then
			Log ("User chose to quit because there was no connection to the DB")
			WScript.Quit 0
		end if
		Log("User chose to continue without connection to DB")
	end if
End Sub

Sub CollectServerDbAsBak()
	PrintStep("Collecting DB information as bak")
	MakeCollectSubDir "ServerDB"
	CollectCommandWithTimeout """" & serverToolsExe & """ BackupDatabase """ & managementServerAppDir & """ " & tempWinDir & "\MirageDB.bak", "ServerDB\LogServerDb.txt", twentyMinutesTimeoutSeconds
	CollectFile tempWinDir & "\MirageDB.bak",  "ServerDB\"
End Sub

Sub StorageBlockSizeCalculator()
	PrintStep("Collecting storage's block size log")
	MakeCollectSubDir "StorageBlockSizeCalculator"
	CollectCommandNoOutputWithTimeout serverToolsExe & " StorageBlockSizeCalculator localhost " & tempDir, twentyMinutesTimeoutSeconds
	CollectFile tempDir &  "\StorageBlockSizeCalculator.txt",  "StorageBlockSizeCalculator\"
End Sub

Sub CollectServerSis()
	PrintStep("Collecting Sis information")
	MakeCollectSubDir "ServerSis"
	CollectCommandNoOutputWithTimeout serverToolsExe & " ExportManagementServerFiles localhost " & tempDir, twentyMinutesTimeoutSeconds
	CollectFile tempDir &  "\Mirage.*",  "ServerSis\"
End Sub

Sub CollectOtherServerLogs()
	PrintStep("Collecting other servers Logs")
	MakeCollectSubDir "OtherServersLogs"
	CollectCommandNoOutputWithTimeout serverToolsExe & " logcourier localhost " & collectDir & "\" & "OtherServersLogs" , twentyMinutesTimeoutSeconds
End Sub

Sub CollectManagementConsoleLogs()
	PrintStep("Collecting management console logs")
	MakeCollectSubDir "ManagementConsoleFiles"
	CollectFile managementConsoleAppDir &  "\logs\console.log*.*",  "ManagementConsoleFiles\"
	CollectFile managementConsoleAppDir &  "\console.svclog",  "ManagementConsoleFiles\"
End Sub

Sub CollectEdgeServerLogs()
	PrintStep("Collecting Edge Server logs")
	MakeCollectSubDir "EdgeServerLogs"
	CollectFile edgeServicePath & "*.log.*", "EdgeServerLogs"
	CollectFile edgeServicePath & "*.log", "EdgeServerLogs"
End Sub

Sub CollectManagementServerFiles()
	PrintStep("Collecting management server configuration files")
	MakeCollectSubDir "ManagementServerFiles"
	CollectFile managementServerAppDir &  "\*.config",  "ManagementServerFiles\"
End Sub

Sub CollectWebAccessFiles()
	PrintStep("Collecting web access information")
	MakeCollectSubDir "WebAccessFiles"
	CollectFile webAccessAppDir &  "\*.config",  "WebAccessFiles\"
End Sub

Sub CollectAdminWebAccessFiles()
	PrintStep("Collecting admin web access information")
	MakeCollectSubDir "AdminWebAccessFiles"
	CollectFile adminWebAccessAppDir &  "\*.config",  "AdminWebAccessFiles\"
End Sub

Sub CollectWebManagementFiles()
	PrintStep("Collecting web management information")
	MakeCollectSubDir "WebManagementFiles"
	CollectFile webManagementAppDir &  "\*.config",  "WebManagementFiles\"
End Sub

Sub CollectRvmWebManagementFiles()
	PrintStep("Collecting Rvm web management information")
	MakeCollectSubDir "RvmWebManagementFiles"
	CollectFile webManagementAppDir &  "\*.config",  "RvmWebManagementFiles\"
End Sub

Sub CollectMirageApiFiles()
	PrintStep("Collecting Mirage Api information")
	MakeCollectSubDir "MirageApiFiles"
	CollectFile mirageApiAppDir &  "\*.config",  "MirageApiFiles\"
End Sub

Sub CollectManagementServerLogs()
	PrintStep("Collecting management server logs")
	MakeCollectSubDir "ManagementServerLogs"
	CollectFile managementServerAppDir &  "\logs\mgmtservice.log*.*",  "ManagementServerLogs\"
	CollectFile managementServerAppDir &  "\logs\mgmtservice-long-duration.log*.*",  "ManagementServerLogs\"
	CollectFile managementServerAppDir &  "\logs\mgmt_stat.log*.*",  "ManagementServerLogs\"
	CollectFile managementServerAppDir &  "\logs\mgmt_activity.log*.*",  "ManagementServerLogs\"
	CollectFile managementServerAppDir &  "\app_tracelog.svclog",  "ManagementServerLogs\"
	CollectFile managementServerAppDir &  "\MongoDB\logs\*.*",  "ManagementServerLogs\"
	CollectFile managementServerAppDir &  "\MongoDB\config\*.*",  "ManagementServerLogs\"
End Sub

Sub CollectWebAccessLogs()
	PrintStep("Collecting web access logs")
	MakeCollectSubDir "WebAccessLogs"
	CollectFile wanovaProgramDataDir &  "\Web Access\logs\webapp.log*.*",  "WebAccessLogs\"
End Sub

Sub CollectAdminWebAccessLogs()
	PrintStep("Collecting web access admin logs")
	MakeCollectSubDir "AdminWebAccessLogs"
	CollectFile wanovaProgramDataDir &  "\Admin Web Access\logs\webapp.log*.*",  "AdminWebAccessLogs\"
End Sub

Sub CollectWebManagementLogs()
	PrintStep("Collecting web management logs")
	MakeCollectSubDir "WebManagementLogs"
	CollectFile wanovaProgramDataDir &  "\Web Management\logs\webapp.log*.*",  "WebManagementLogs\"
End Sub

Sub CollectRvmWebManagementLogs()
	PrintStep("Collecting Rvm web management logs")
	MakeCollectSubDir "RvmWebManagementLogs"
	CollectFile wanovaProgramDataDir &  "\rvm\logs\webapp.log*.*",  "RvmWebManagementLogs\"
End Sub

Sub CollectMirageApiLogs()
	PrintStep("Collecting mirage api logs")
	MakeCollectSubDir "MirageApiLogs"
	CollectFile wanovaProgramDataDir &  "\Web Management\logs\mirage_api.log*.*",  "MirageApiLogs\"
End Sub

Sub CollectMsInfo()
	CollectLog("msinfo32.txt")
	RunShellWithTimeoutInDir """" & fullProgramFilesDir & "\Common Files\Microsoft Shared\MSInfo\msinfo32.exe"" /report " & collectDir & "\msinfo32.txt 2>1 > NUL", microsoftSharedDir & "\MSInfo", twentyMinutesTimeoutSeconds
End Sub

Sub CollectRegistryKey(regKey, outputFilename)
	CollectLog(outputFilename)
	RunShell "reg export """ & regKey & """ " & collectDir & "\" & outputFilename & " 2>1 > NUL"
End Sub

Sub CollectDesktopRegistryKeys()
	PrintStep("Collecting mirage registry keys")
	MakeCollectSubDir "DesktopRegistryKeys"
	CollectRegistryKey "HKLM\SYSTEM\CurrentControlset\Services\Mirage", "DesktopRegistryKeys\mirage_driver.reg"
	CollectRegistryKey "HKLM\SYSTEM\CurrentControlset\Control\Session Manager", "DesktopRegistryKeys\session_manager.reg"
	CollectRegistryKey "HKLM\SOFTWARE\Wanova", "DesktopRegistryKeys\mirage_service.reg"
End Sub

Sub SaveLocalHive(hiveName)
	If offlineSysreport Then 
		CollectFile winDir & "\System32\config\" & hiveName, "\RegistryHives\" & hiveName & ".Local.hiv"
		Exit Sub
	End If
	If isKasperskyInstalled And Not IsNt6() Then
		Log("Not saving local hive " & hiveName & ", because kaspersky is installed")
		Exit Sub
	End If 
	dim hivePath : hivePath = "HKLM\" & hiveName
	If hiveName = "default" Then
		hivePath = "HKU\.Default"
	End If
	MakeCollectSubDir "RegistryHives"    
	CollectCommandNoOutputWithTimeout "reg save " & hivePath & " " & collectDir & "\RegistryHives\" & hiveName & ".Local.hiv", twentyMinutesTimeoutSeconds
End Sub

Sub CollectHive(hiveName)
	MakeCollectSubDir "RegistryHives"
	SaveLocalHive(hiveName)
End Sub

Sub CollectSccmLogs()
	PrintStep("Collecting SCCM files")
	MakeCollectSubDir "SccmLogs"
	CollectFile SccmServerDIR & "\*", "SccmLogs\" 
	CollectFile SccmClient32 & "\*", "SccmLogs\"
	CollectFile SccmClient64 & "\*", "SccmLogs\"
	CollectFile SccmClient2012 & "\*", "SccmLogs\"
End Sub

Function isArrayContain(value, arr)
	dim result : result = false
	for each arrElement in arr
		if not result and arrElement = value then
			result = true
		end if
	next
	isArrayContain = result
End Function 

Function GetFileSize(path)
	dim filesize : filesize = 0
	if not fsObj.FileExists(path) then
		Log("Collecting <" & path & "> may fail as it doesn't seem to exist! (unless it's a wildcard)")
	else
		set file = fsObj.GetFile(path)
		filesize = file.size
	end if
	GetFileSize = filesize
End Function

Function GetFileExtension(path)
	dim fileextension
	if not fsObj.FileExists(path) then
		Log("Collecting <" & path & "> may fail as it doesn't seem to exist! (unless it's a wildcard)")
	else
		fileextension = fsObj.GetExtensionName(path)
	end if
	GetFileExtension = fileextension
End Function

Sub CollectFileByConditions(filePath, pathInReport)
	dim fileSize : fileSize = GetFileSize(filePath)
	dim fileExtension : fileExtension = GetFileExtension(filePath)
	if fileSize < maxLogFileSize and isArrayContain(fileExtension, logFileExtenstions) then
		CollectFile filePath, pathInReport
	end if
End Sub

Sub CollectFileForAV(filePath, pathInReport)
	dim fileSize : fileSize = GetFileSize(filePath)
	if fileSize < maxLogFileSize then
		CollectFile filePath, pathInReport
	end if
End Sub

Sub CollectDrivesFreespace()
	CollectCommand "wmic logicaldisk get size,freespace,caption", "Commands\disks_space.txt"
End Sub

Sub CollectSecurityFolderFiles(path, name, recursive)
	MakeCollectSubDir name
	Err.Clear
	On Error Resume Next
	set folder = fsObj.GetFolder(path)
	if Err.Number <> 0 then
		Log("FAILED Collecting folder <" & path & ">! Error number: " & Err.Number & " " & "Error description: " & Err.Description)	
		exit sub
	end If
	
	For Each file In folder.Files
		CollectFileForAV file.Path, name & "\" & file.Name
	Next

	if recursive then
		For Each fldr In folder.SubFolders
			CollectSecurityFolderFiles fldr.Path, name & "\" & fldr.Name, recursive
		Next
	end if
End Sub

Sub CollectFolderFiles(path, name, recursive)
	MakeCollectSubDir Name
	Err.Clear
	On Error Resume Next
	set folder = fsObj.GetFolder(path)
	if Err.Number <> 0 then
		Log("FAILED Collecting folder <" & path & ">! Error number: " & Err.Number & " " & "Error description: " & Err.Description)	
		exit sub
	end If
	
	For Each file In folder.Files
		CollectFile file.Path, name & "\" & file.Name
	Next

	if recursive then
		For Each fldr In folder.SubFolders
			CollectFolderFiles fldr.Path, name & "\" & fldr.Name, recursive
		Next
	end if
End Sub

Sub CollectFolderFilesIfFresh(path, name, recursive)
	MakeCollectSubDir Name
	Err.Clear
	On Error Resume Next
	set folder = fsObj.GetFolder(path)
	if Err.Number <> 0 then
		Log("FAILED Collecting folder <" & path & ">! Error number: " & Err.Number & " " & "Error description: " & Err.Description)	
		exit sub
	end If
	
	For Each file In folder.Files
		CollectFileIfFresh file.Path, name & "\" & file.Name
	Next

	if recursive then
		For Each fldr In folder.SubFolders
			CollectFolderFiles fldr.Path, name & "\" & fldr.Name, recursive
		Next
	end if
End Sub

Sub CollectCrashDumps()
	PrintStep("Collecting crash dumps")
	MakeCollectSubDir "CrashDumps"

	const nonRecursive = False
	const recursive = True
	CollectFolderFilesIfFresh winDir & "\LiveKernelReports\WATCHDOG", "CrashDumps\LiveKernelReports", nonRecursive
	CollectFolderFilesIfFresh programDataDir & "\Microsoft\Windows\WER\ReportArchive", "CrashDumps\WER_ReportArchive", recursive
	CollectFolderFilesIfFresh programDataDir & "\Microsoft\Windows\WER\ReportQueue", "CrashDumps\WER_ReportQueue", recursive
	CollectFolderFilesIfFresh winDir & "\Minidump", "CrashDumps\Minidump", nonRecursive
	CollectFileIfFresh winDir & "\MEMORY.DMP", "CrashDumps\MEMORY.DMP"
End Sub

Sub CollectUsersHive()
	PrintStep("Collecting users hive")
	
	MakeCollectSubDir "RegistryHives"
	dim profilesCollectionFolder : profilesCollectionFolder = "RegistryHives\Users" 
	MakeCollectSubDir profilesCollectionFolder  

	Err.Clear
	On Error Resume Next
	dim profilesFolder : profilesFolder = fsObj.GetParentFolderName(shellObj.ExpandEnvironmentStrings("%USERPROFILE%"))
	set folder = fsObj.GetFolder(profilesFolder)
	if Err.Number <> 0 then
		Log("FAILED Collecting folder <" & path & ">! Error number: " & Err.Number & " " & "Error description: " & Err.Description)	
		exit sub
	end If
	
	For Each fldr In folder.SubFolders
		dim currentProfileCollectionFolder : currentProfileCollectionFolder = profilesCollectionFolder & "\" & fldr.Name
		MakeCollectSubDir currentProfileCollectionFolder
		CollectFile fldr.Path & "\NTUSER.DAT" , currentProfileCollectionFolder & "\NTUSER.DAT"
	Next
	
	dim hivePath : hivePath = "HKCU"
	dim userHiveFileName : userHiveFileName = "CurrentUser-" & shellObj.ExpandEnvironmentStrings("%USERNAME%") & ".hiv" 
	CollectCommandNoOutputWithTimeout "reg save " & hivePath & " " & collectDir & "\RegistryHives\" & userHiveFileName, twentyMinutesTimeoutSeconds

End Sub

Sub CollectUsmtCustomizations()
	PrintStep("Collecting usmt customization files")
	MakeCollectSubDir "UsmtCustomizations"
	MakeCollectSubDir "UsmtCustomizations\amd64"
	MakeCollectSubDir "UsmtCustomizations\x86"
	
	CollectFile winDir & "\WDL\USMT\*.*", "UsmtCustomizations\"
	CollectFile winDir & "\WDL\USMT\amd64\*.xml", "UsmtCustomizations\amd64"
	CollectFile winDir & "\WDL\USMT\x86\*.xml", "UsmtCustomizations\x86"
End Sub

Sub CollectFileIfFresh(path, pathInReport)
	If Not fsObj.FileExists(path) Then
		Exit Sub
	End If

	set fileObj = fsObj.GetFile(path)
	dim fileAgeInDays: fileAgeInDays = DateDiff("d", CDATE( fileObj.DateLastModified), Now)
	If fileAgeInDays < 14 Then
		CollectFile path, pathInReport
	Else
		Log("Skipping file " & path & " as it is too old (age in days: " & fileAgeInDays & ")")
	End If
End Sub

Sub CollectClientLogFolder()
	PrintStep("Collecting mirage client logs")
	const recursive = True
	CollectFolderFiles clientLogDir, "DesktopLogs", recursive
	CollectFile winDir & "\MirageNative.log", "DesktopLogs\MirageNative.Log"
 	CollectFile tempWinDir & "\mirage.upgrade*.log", "DesktopLogs\"
 	CollectFile tempWinDir & "\DesktopBundle.log", "DesktopLogs\"
End Sub

Sub CollectClientLogFolderFromWindowsOld()
	PrintStep("Collecting old windows client logs")
	const recursive = True
	dim windowsOldLogDir : windowsOldLogDir = FullFolderShortPath(PathInWindowsOld(fullProgramFilesDir & "\Wanova\Mirage Service\Logs"))
	dim windowsOldWinDir : windowsOldWinDir = FullFolderShortPath(PathInWindowsOld("c:\windows"))
	dim windowsOldWinntDir : windowsOldWinntDir = FullFolderShortPath(PathInWindowsOld("c:\winnt"))
	dim TempDir : TempDir = "\Temp"

	CollectFolderFiles windowsOldLogDir, "DesktopLogsInWindowsOld", recursive
	CollectFile windowsOldWinDir & "\MirageNative.log", "DesktopLogsInWindowsOld\MirageNative.Log"
	CollectFile windowsOldWinntDir & "\MirageNative.log", "DesktopLogsInWindowsOld\MirageNative.WINNT.Log"
 	CollectFile windowsOldWinDir & TempDir &"\mirage.upgrade*.log", "DesktopLogsInWindowsOld\"
	CollectFile windowsOldWinntDir & TempDir &"\mirage.upgrade*.log", "DesktopLogsInWindowsOld\"
End Sub

Sub CollectBareMetalLogFolder()
	PrintStep("Collecting Bare Metal client logs")
	const recursive = True
	dim bareMetalLogsDir : bareMetalLogsDir = wanovaAppDataDir & "\BareMetalLogs"

	CollectFolderFiles bareMetalLogsDir, "DesktopBareMetalLogs", recursive
End Sub

Function PathInWindowsOld(realPath)
	dim pathWithoutVolume : pathWithoutVolume = Right(realPath, Len(realPath) - 3)
	dim volume : volume = Left(realPath, 3)
	PathInWindowsOld = volume & "Windows.Old\" & pathWithoutVolume
End Function

Sub CollectLogBook()
	const recursive = True
	CollectFolderFiles wanovaAppDataDir & "\LogBook", "LogBook", recursive
End Sub

Sub CollectTempManifests()
	const recursive = True
	CollectFolderFiles wanovaAppDataDir & "\Ephemeral", "Ephemeral", recursive
End Sub

Sub CollectLayerRecording()
	const recursive = True
	CollectFolderFiles preLayerRecordingDir, "PreLayerRecording", recursive
	CollectFolderFiles postLayerRecordingDir, "PostLayerRecording", recursive
End Sub

Sub CollectImageCache()
	const recursive = True
	CollectFolderFiles wanovaAppDataDir & "\ImageCache", "ImageCache", recursive
	CollectFolderFiles wanovaAppDataDir & "\NewImageCache", "NewImageCache", recursive
End Sub

Sub CollectManifestCache()
	const recursive = True
	CollectFolderFiles wanovaAppDataDir & "\ManifestCache", "ManifestCache", recursive
End Sub

Function Min( v1, v2 )
	If v1 >= v2 Then Min = v2 Else Min = v1
End Function

Function IsNt6()
	strVersion = shellObj.regread("HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\CurrentVersion")
	if left(strVersion, 2) = "6." then
		IsNt6 = True
	else
		IsNt6 = False
	end if
End Function

Function Sort( lst ) 
	For i = (UBound(lst) - 1) to 0 Step -1
		For j= 0 to i
			If UCase(lst(j)) > UCase(lst(j+1)) Then
				strHolder = lst(j+1)
				lst(j+1) = lst(j)
				lst(j) = strHolder
			End If
		Next
	Next
End Function

Sub CollectLogBookPartial(numberOfCapsules)
	Log("CollectLogBookPartial " & numberOfCapsules)
	MakeCollectSubDir "LogBook"
	Err.Clear
	On Error Resume Next
	dim path : path = wanovaAppDataDir & "\LogBook"
	set folder = fsObj.GetFolder(path)
	if Err.Number <> 0 then
		Log("FAILED Collecting folder <" & path & ">! Error number: " & Err.Number & " " & "Error description: " & Err.Description)	
		exit sub
	end if

	Dim subFolderList()
	ReDim subFolderList(1)
	Dim i : i = 0

	For Each fldr In folder.SubFolders
		ReDim Preserve subFolderList(i)
		subFolderList(i) = fldr.Name
		i = i + 1
	Next

	Sort(subFolderList)

	Const recursive = True
	Dim numOfFolders : numOfFolders = UBound(subFolderList) + 1
	Dim collectedAgentManifests : collectedAgentManifests = False
	dim numberOfCapsulesToCollect : numberOfCapsulesToCollect = Min(numberOfCapsules, numOfFolders)
	for i = numOfFolders - numberOfCapsulesToCollect to numOfFolders - 1
		Log(folder.Path & "\" & subFolderList(i))
		If subFolderList(i) = "AgentManifests" Then
			collectedAgentManifests = True
		End if
		CollectFolderFiles folder.Path & "\" & subFolderList(i), "LogBook\" & subFolderList(i), recursive
	Next
	If (Not collectedAgentManifests) then
		CollectFolderFiles folder.Path & "\" & "AgentManifests", "LogBook\AgentManifests", recursive
	End if
End Sub

Sub CollectClientFolders()
	PrintStep("Collecting mirage files")
	const nonRecursive = False
	CollectFolderFiles clientAppDir, "AppDir", nonRecursive
	CollectFolderFiles scratchPadDir, "ScratchPad", nonRecursive
End Sub

Sub SaveDirIntoCab(ddfTextFile, folder, cabPath)
	cabPathWithSlash = cabPath
	if Len(cabPath) <> 0 then cabPathWithSlash = cabPath & "\"

	ddfTextFile.WriteLine(".Set DestinationDir=" & cabPath)
	For Each file In folder.Files
		ddfTextFile.WriteLine("""" & file & """")
	Next
	For Each fldr In folder.SubFolders
		SaveDirIntoCab ddfTextFile, fldr, cabPathWithSlash & fldr.Name
	Next
End Sub

Sub CreateZipFile(sysReportType)
	If forcedSysreportName <> nil Then
		sysreportName = forcedSysreportName
	else
		sysreportName = typeOfSysReport & "sysreport-" & computerName & "." & Year(Now()) & "-" & Month(Now()) & "-" & Day(Now()) & "." & Hour(Now()) & "-" & Minute(Now()) & "-" & sysReportType
	End if
	if NOT noOutputExtension Then
		extension = ".zip"
	else
		extension = ""
	End If
	
	PrintStep("Compressing sysreport file, which will be located at " & targetFolder & "\" & sysreportName & extension)
	set folder = fsObj.GetFolder(collectDir)
	Log("Target folder: " & targetFolder)
	Set7zLocation()
	command7z = """" & FullFolderShortPath(sevenzBinDir) & """ a -y """ & tempDir & "\" & sysreportName & ".zip"" """ & folder & "\*"" -mm=deflate -mx5 "
	if splitSysreport <> -1 then command7z = command7z & " -v" & Cstr(splitSysreport) & "m "
	command7z = command7z & " 2>&1 "
	RunShellWithTimeoutAndShowOutput command7z , twoHoursTimeoutSeconds 
	On Error Resume Next
	fsObj.MoveFile tempDir & "\" & sysreportName & ".zip" , targetFolder & "\" & sysreportName & extension
	if Err.Number <> 0 then
		Log("FAILED Moving sysreport to " & targetFolder & ", Error number: " & Err.Number & " " & "Error description: " & Err.Description)
	end if
End Sub

Sub SwitchToLastLogFile()
	logFile.Close()
	set logFile = fsObj.CreateTextFile (tempDir &  "\sysreport-last.log", True, True)
End Sub

Sub CloseLogFile()
	logToFile = false
	logFile.Close()
End Sub

Sub AddLogFileToZipFile()
	If fsObj.FileExists( FullFolderShortPath(targetFolder & "\" & sysreportName & ".zip") ) Then
		RunShellWithTimeout FullFolderShortPath(sevenzBinDir) & " a -y """ & targetFolder & "\" & sysreportName & ".zip"" """ & tempDir &  "\sysreport-last.log"" -mm=deflate -mx5 " , oneMinuteTimeoutSeconds 
	End if
End Sub

Sub NotifyWhenCreationCompletes()
	if quietFlag = false Then
		If fsObj.FileExists( FullFolderShortPath(targetFolder & "\" & sysreportName & ".zip") ) Then
			msgbox "Sysreport creation completed." &  vbCRLF & "Sysreport file can be found at: " & targetFolder & "\" & sysreportName & ".zip" , vbOKOnly + vbInformation , productName
		else
			msgbox "Sysreport wasn't fully created." &  vbCRLF & "Partial sysreport can be found at: " & tempDir , vbOKOnly + vbExclamation , productName
		end if
	end if
End Sub

''''' Reports '''''

Sub SysReportLogs()
	if isClientInstalled Then CollectClientLogFolder()
	if isClientInstalled Then CollectClientLogFolderFromWindowsOld()
	if isClientInstalled Then CollectBareMetalLogFolder()
	if isClientInstalled Then CollectUsmtLogs()
	if isServerInstalled Then CollectServerLogs()
	if isManagementConsoleInstalled Then CollectManagementConsoleLogs()    
	if isManagementServerInstalled Then CollectManagementServerLogs()    
	if isWebAccessInstalled Then CollectWebAccessLogs()    
	if isAdminWebAccessInstalled Then CollectAdminWebAccessLogs()    
	if isWebManagementInstalled Then CollectWebManagementLogs()    
	if isRvmWebManagementInstalled Then CollectRvmWebManagementLogs()    
	if isMirageApiInstalled Then CollectMirageApiLogs()
	if isEdgeServiceInstalled Then CollectEdgeServerLogs()
	if (isWebAccessInstalled or isAdminWebAccessInstalled or isWebManagementInstalled or isRvmWebManagementInstalled) then CollectIISFiles()
	if Not offlineSysreport Then CollectEventLog()
	CollectSystemLogs()
End Sub

Sub SysReportMedium()
	if isManagementServerInstalled and Not offlineSysreport Then CollectServerDbAsCsv()
	SysReportLogs()
	If Not offlineSysreport Then CollectExtendedEventLog()
	CollectFiles()
	CollectFullCommands()
	CollectDirLists()
	if isClientInstalled And Not offlineSysreport Then CollectDesktopRegistryKeys()
	if isClientInstalled And Not SkipPatrialLogBookCollection Then CollectLogBookPartial(3)
	if isClientInstalled Then CollectUsmtCustomizations()
	CollectHive("system")
	CollectLayerRecording()
	CollectDrivesFreespace()
End Sub

Sub SysReportFull()
	SkipPatrialLogBookCollection = True
	SysReportMedium()
	if isClientInstalled then CollectLogBook()
	if isClientInstalled then CollectTempManifests()
	if isManagementServerInstalled and Not offlineSysreport Then CollectServerDbAsBak()
	if isManagementServerInstalled and Not offlineSysreport Then CollectServerSis()
	if isManagementServerInstalled and Not offlineSysreport Then CollectOtherServerLogs()
	if isManagementServerInstalled and Not offlineSysreport Then StorageBlockSizeCalculator()
	if isClientInstalled Then CollectClientFolders()
	if isClientInstalled Then CollectImageCache()
	if isClientInstalled Then CollectManifestCache()
	if isClientInstalled Then CollectHive("software")
	if isClientInstalled Then CollectHive("default")
	if isClientInstalled Then CollectMetroDb()
	if Not offlineSysreport Then CollectMsInfo()
	if isClientInstalled and Not offlineSysreport Then CollectUsersHive()	
	if CollectCrashDumpsFlag Then CollectCrashDumps()
End Sub

Sub LogEvent(message)
	typeInformation = 4
	On Error Resume Next
	shellObj.LogEvent typeInformation, message
	if Err.Number <> 0 then Log("FAILED to log event! Error number: " & Err.Number & " " & "Error description: " & Err.Description)
End Sub


'''' VMware legal notice ''''
if (not quietFlag) and (not noPrivacyFlag) then
	answer = MsgBox ("IMPORTANT NOTICE:" & vbCRLF & "Log files, system reports and support data generated in order to obtain support from VMware may contain sensitive, confidential or personal information, including file and folder names and information about installed programs and user settings. You should consider your privacy and regulatory requirements before sending support data to VMware.", 49 , productName)
	if answer = 2 then
		Log ("User chose to quit because privacy notice")
		WScript.Quit 0
	end if
end if

''''' Main '''''
Log("Mirage system report started")

LogEvent("Mirage Client sysreport collection has started")
Unlock()

Select Case sysReportType
	Case "logs"
		SysReportLogs()
	Case "medium"
		SysReportMedium()
	Case "full"
		SysReportFull()
	Case "view"
		SysReportFull()
	Case Else
		Log("Invalid system report type")
End Select

Function Is64BitOs()
	Is64BitOs = False
	On Error Resume Next

	If GetObject("winmgmts:root\cimv2:Win32_Processor='cpu0'").AddressWidth = 64 Then
		Is64BitOs = True
	End If
End Function

Function Check7zipLocation(isInstalled , basePath, sevenZipFileName)
	if isInstalled AND fsObj.FileExists(basePath & sevenZipFileName) then
		sevenzBinDir = basePath & sevenZipFileName
		Log("Using " & sevenzBinDir & " to create the .zip file")
		Check7zipLocation = True
	else
		Check7zipLocation = False
	end if
End Function

Sub Set7zLocation()
	Dim sevenZipFileName : sevenZipFileName = "\7za.exe"
	if winPeFlag AND isRunningOn64Bit then
		sevenZipFileName = "\7z.exe"
	end if
	
	if (Check7zipLocation(isClientInstalled,clientAppDir, sevenZipFileName)) OR _ 
	Check7zipLocation( isServerInstalled , serverAppDir, sevenZipFileName ) OR _ 
	Check7zipLocation( isManagementServerInstalled , managementServerAppDir, sevenZipFileName ) OR _ 
	Check7zipLocation( isManagementConsoleInstalled , managementConsoleAppDir, sevenZipFileName ) OR _ 
	Check7zipLocation( isWebAccessInstalled , webAccessAppDir & "\bin", sevenZipFileName ) OR _ 
	Check7zipLocation( isAdminWebAccessInstalled , adminWebAccessAppDir & "\bin", sevenZipFileName ) OR _
	Check7zipLocation( isWebManagementInstalled , webManagementAppDir & "\bin", sevenZipFileName ) OR _
	Check7zipLocation( isRvmWebManagementInstalled , rvmWebManagementAppDir & "\bin", sevenZipFileName ) OR _
	Check7zipLocation( isEdgeServerInstalled, mirageEdgeServerDir, sevenZipFileName) then
		exit sub
	else
		sevenzBinDir = fsObj.GetParentFolderName(Wscript.ScriptFullName) & sevenZipFileName
		Log("Unable to locate 7za.exe in any predefined path! Trying to use " & sevenzBinDir & " (if this path doesn't exist, no zip file will be created)")
	end if
End Sub

SwitchToLastLogFile()
CreateZipFile(sysReportType)

Lock()
LogEvent("Mirage Client sysreport collection has finished")
PrintStep(productName & " system report completed")
CloseLogFile()
AddLogFileToZipFile()
NotifyWhenCreationCompletes()
