Include "W_ZTIUtility.vbs"

'//////////////////////////////////////////////////
'//
'// Script File:
'//
'//   ZHALDetect.vbs
'//
'//   This script updates sysprep.inf with correct HAL Type
'//   The Reference (master) image should have an Advanced ACPI HAL type.
'//
'//   This version does not require the MDT 2008 environement being present, 
'//   E.g. can be used with Intel LANDesk or Altiris (Note: ZTIUtility.vbs from
'//   MDT 2008 must be added to the same folder)
'//
'//   This script assumes the following files are being present in C:\Drivers\UniProcHAL
'//   hal.dll (Renamed from halaacpi.dll to hal.dll)
'//   ntkrnlpa.exe
'//   ntoskrnl.exe
'//   
'//   Origial Author: Johan Arwidmark	
'//   URL: http://www.deployvista.com
'//
'//   Adapted by: WANOVA
'//   
'//   Disclaimer
'//   This script is provided "AS IS" without express 
'//   or implied warranty of any kind.
'//
'//////////////////////////////////////////////////


' Customize the local sysprep.inf file based on the HAL type

Call UpdateSysprepinf ()

' Done, quit.

WScript.Quit

Sub UpdateSysprepinf ()

	' Set Sysprep Path

	If oFSO.FileExists("w:\sysprep\Sysprep.inf") then

		sSysprepInf = "w:\sysprep\Sysprep.inf"
		oLogging.CreateEntry "Found sysprep in " & sSysprepInf, LogTypeInfo

	Else

		oLogging.CreateEntry "Could not locate Sysprep", LogTypeWarning

	End if

   ' Find out the HAL type

    sHalType = oShell.RegRead("HKLM\SYSTEM\CurrentControlSet\Enum\Root\ACPI_HAL\0000\HardwareID")

   If sHalType(0) = "acpiapic" Then

	if oShell.Environment.item("NUMBER_OF_PROCESSORS") = 1 then

     		WriteIni sSysprepInf, "Unattended", "UpdateUPHAL", "ACPIAPIC_UP,C:\Windows\Inf\Hal.inf"
		oLogging.CreateEntry "HAL Type is ACPIAPIC_UP, updating sysprep.inf", LogTypeInfo

		Call CopyHalFiles()

	else
		writeini sSysprepInf, "Unattended", "UpdateHAL", "ACPIAPIC_MP,C:\Windows\Inf\Hal.inf"
		oLogging.CreateEntry "HAL Type is ACPIAPIC_MP, updating sysprep.inf", LogTypeInfo
	
		Call CopyHalFiles()

	end if

   ElseIf sHalType(0) = "acpiapic_up" Then

	WriteIni sSysprepInf, "Unattended", "UpdateUPHAL", "ACPIAPIC_UP,C:\Windows\Inf\Hal.inf"
	oLogging.CreateEntry "HAL Type is ACPIAPIC_UP, updating sysprep.inf", LogTypeInfo

	Call CopyHalFiles()


   ElseIf sHalType(0) = "acpiapic_mp" Then

	writeini sSysprepInf, "Unattended", "UpdateHAL", "ACPIAPIC_MP,C:\Windows\Inf\Hal.inf"
	oLogging.CreateEntry "HAL Type is ACPIAPIC_MP, updating sysprep.inf", LogTypeInfo

	Call CopyHalFiles()

   Else

	oLogging.CreateEntry "HAL Type is ACPIPIC, Do nothing", LogTypeInfo

   End if


End Sub

Sub CopyHalFiles()


	sSourceFolder = "w:\D\ACPI_UP"
	sDestinationFolder = "w:\Windows\System32"

    oLogging.CreateEntry "Checking for" & sSourceFolder, LogTypeInfo

	If oFSO.FolderExists(sSourceFolder) then 

        oLogging.CreateEntry "Folder " & sSourceFolder & " Found", LogTypeInfo
		oLogging.CreateEntry "Copying HAL files for UniProc and MultiProc Comatibility", LogTypeInfo

		For Each sFile In oFSO.GetFolder(sSourceFolder).Files

			oFSO.GetFile(sFile).Copy sDestinationFolder & "\" & oFSO.GetFileName(sFile),True
			oLogging.CreateEntry "Copying " & oFSO.GetFileName(sFile) & " to " & sDestinationFolder, LogTypeInfo 

		Next

	Else
		oLogging.CreateEntry "Error - Folder " & sSourceFolder & " Not Found", LogTypeError
		oLogging.CreateEntry "Error - Copying HAL files for UniProc and MultiProc Comatibility Failed ", LogTypeError
		
		CopyHalFiles = Failure
    	Exit Sub
	End If


End Sub


Function ReadIni(file, section, item)

    ReadIni = ""
    file = Trim(file)
    item = Trim(item)
    Set ini = oFSO.OpenTextFile( file, 1, True)

    Do While ini.AtEndOfStream = False
		line = ini.ReadLine
		line = Trim(line)
		If LCase(line) = "[" & LCase(section) & "]" Then
			line = ini.ReadLine
			line = Trim(line)
			Do While Left( line, 1) <> "["
				'If InStr( 1, line, item & "=", 1) = 1 Then
				equalpos = InStr(1, line, "=", 1 )
				If equalpos > 0 Then
					leftstring = Left(line, equalpos - 1 )
					leftstring = Trim(leftstring)
					If LCase(leftstring) = LCase(item) Then
						ReadIni = Mid( line, equalpos + 1 )
						ReadIni = Trim(ReadIni)
						Exit Do
					End If
				End If

				If ini.AtEndOfStream Then Exit Do
				line = ini.ReadLine
				line = Trim(line)
			Loop
			Exit Do
		End If
	Loop
	ini.Close

End Function

Sub WriteIni( file, section, item, myvalue )

	in_section = False
	section_exists = False
	item_exists = ( ReadIni( file, section, item ) <> "" )
	wrote = False
	file = Trim(file)
	itemtrimmed = Trim(item)
	myvalue = Trim(myvalue)

	temp_ini = oFSO.GetParentFolderName(file) & "\" & oFSO.GetTempName

	Set read_ini = oFSO.OpenTextFile( file, 1, True, TristateFalse )
	Set write_ini = oFSO.CreateTextFile( temp_ini, False)

	While read_ini.AtEndOfStream = False
		line = read_ini.ReadLine
		linetrimmed = Trim(line)
		If wrote = False Then
			If LCase(line) = "[" & LCase(section) & "]" Then
				section_exists = True
				in_section = True
			ElseIf InStr( line, "[" ) = 1 Then
				in_section = False
			End If
		End If

		If in_section Then
			If item_exists = False Then
				write_ini.WriteLine line
				write_ini.WriteLine item & "=" & myvalue
				wrote = True
				in_section = False
			Else
				equalpos = InStr(1, line, "=", 1 )
				If equalpos > 0 Then
					leftstring = Left(line, equalpos - 1 )
					leftstring = Trim(leftstring)
					If LCase(leftstring) = LCase(item) Then
						write_ini.WriteLine itemtrimmed & "=" & myvalue
						wrote = True
						in_section = False
					End If
				End If
				If Not wrote Then
					write_ini.WriteLine line
				End If
			End If
		Else
			write_ini.WriteLine line
		End If
	Wend

	If section_exists = False Then ' section doesn't exist
		write_ini.WriteLine
		write_ini.WriteLine "[" & section & "]"
		write_ini.WriteLine itemtrimmed & "=" & myvalue
	End If

	read_ini.Close
	write_ini.Close
        If oFSO.FileExists(file) then
            oFSO.DeleteFile file, True
        End if
        oFSO.CopyFile temp_ini, file, true
	oFSO.DeleteFile temp_ini, True
	
End Sub

Sub Include (Scriptname)
	Set oFSO=CreateObject("Scripting.FileSystemObject")
	Set oFile= oFSO.OpenTextFile(Scriptname)
	ExecuteGlobal oFile.ReadAll()
	oFile.Close
End Sub