@echo off

echo ***********************************************
echo * VMware Win8.1 USB Disk Creator
echo ***********************************************

set diskpart_actions= "%temp%\diskpart.txt"

if "123%~1" == "123" goto usage
if "123%~2" == "123" goto usage
if "123%3" == "123" goto usage
if "123%4" == "123" goto usage
if "123%5" == "123" goto usage

set win7_dvd_path=%~1
set msi_path=%~2
set server_ip=%3
set use_ssl_transport=%4
set usb_disk_number=%5
set drivers_location=%~6

set usb_drive_letter=u
set usb_path=%usb_drive_letter%:\

IF NOT exist "%win7_dvd_path%\"		( echo Could Not Find %win7_dvd_path%\		)
IF NOT exist "%msi_path%"			( echo Could Not Find %msi_path%			)
IF NOT exist "%drivers_location%\"	( echo Could Not Find %drivers_location%\ 	)

IF NOT exist "%win7_dvd_path%\"		( goto end )
IF NOT exist "%msi_path%"			( goto end )
IF NOT exist "%drivers_location%\"	( goto end )

echo ***********************************************
echo *** Partitioning USB disk
echo ***********************************************
echo select disk %usb_disk_number% > %diskpart_actions% 2>&1
echo clean >> %diskpart_actions% 2>&1
echo create partition primary >> %diskpart_actions% 2>&1
echo select partition 1 >> %diskpart_actions% 2>&1
echo active >> %diskpart_actions% 2>&1
echo format fs=fat32 quick >> %diskpart_actions% 2>&1
echo assign letter=%usb_drive_letter% >> %diskpart_actions% 2>&1
echo exit >> %diskpart_actions% 2>&1
diskpart /s %diskpart_actions%
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Copying Win8.1 DVD contents into USB disk
echo ***********************************************
xcopy "%win7_dvd_path%\*.*" %usb_path%\ /e /h /f
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Copying answer file into USB disk
echo ***********************************************
copy "%~dp0autounattend8.xml" %usb_path%\autounattend.xml
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Copying Post-Deployment script to $OEM$
echo ***********************************************
mkdir "%usb_path%\sources\$oem$\$$\setup\Wanova"
copy "%~dp0SetupComplete8.cmd" "%usb_path%\sources\$oem$\$$\setup\Wanova\Setup.cmd"
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Copying Mirage client to USB disk
echo ***********************************************
copy "%msi_path%" "%usb_path%\sources\$oem$\$$\setup\Wanova\MirageClient.msi"
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Creating Mirage installation command line
echo ***********************************************
echo msiexec /norestart /quiet /l* %%temp%%\MirageClient.log /i %%post_actions_dir%%\MirageClient.msi serverip=%server_ip% usessltransport=%use_ssl_transport% > "%usb_path%\sources\$oem$\$$\setup\Wanova\InstallClient.cmd"
if %errorlevel% neq 0 goto errend

if "123%~6" == "123" goto complete
echo ***********************************************
echo *** Adding drivers to USB disk
echo ***********************************************
mkdir "%usb_path%\sources\$oem$\$1\MirageDrivers"
xcopy "%drivers_location%\*.*" "%usb_path%\sources\$oem$\$1\MirageDrivers\" /e /h /f
if %errorlevel% neq 0 goto errend


:complete
echo ***********************************************
echo *** Boot USB Creation completed SUCCESSFULLY!
echo ***********************************************
echo *** Additional Notes:
echo *** You may edit %usb_path%\autounattend.xml for further customizations of the Win8 answer file.
echo *** You may edit %usb_path%\sources\$oem$\$$\setup\Wanova\Setup.cmd to execute additional custom post-deployment actions. 
echo *** You may later replace %usb_path%\sources\$oem$\$$\setup\Wanova\MirageClient.msi with any other version of the Mirage client installer.
echo *** You may edit %usb_path%\sources\$oem$\$$\setup\Wanova\InstallClient.cmd to change the Mirage client installation command line.
echo *** To launch automatic installation, configure the BIOS to boot from HD and perform a one-time boot from USB.
echo ***********************************************
goto end



:usage
echo Usage: win8usb.cmd [win8.1 dvd path] [msi path] [server address] [use ssl transport (true/false)] [usb disk number] [drivers folder path (optional)]
echo Available disks (for finding your USB disk number):
echo list disk > %diskpart_actions% 2>&1
diskpart /s %diskpart_actions%
goto end

:errend
echo ***********************************************
echo *** Boot USB Creation did NOT complete!
echo *** (See available errors thrown above)
echo ***********************************************

:end
del /q /f %diskpart_actions%  > NUL 2>&1