On Error Resume Next

set shellObj = WScript.CreateObject("WScript.Shell")
Set fsoObj = CreateObject("Scripting.FileSystemObject")
dim verboseLogging : verboseLogging = false

Main

Sub Main
	ShowBanner("Wanova XP USB Disk")
	volumeCount = ShowVolumes()
	If volumeCount = 0 Then
		SelectDisk
	Else
		SelectVolumeOrDisk volumeCount
	End If
	ShowBanner("Done! Please remove the USB disk and restart your machine.")
End Sub

Sub ShowBanner(message)
	WScript.Echo
	WScript.Echo "*******************************************************************************"
	WScript.Echo message
	WScript.Echo "*******************************************************************************"
	WScript.Echo
End Sub

Function ShowVolumes
	volumes = ""
	Set processObj = ExecuteDiskPart("list volume")

	count = 0
	Do Until processObj.StdOut.AtEndOfStream
		line = processObj.StdOut.ReadLine
		If InStr(LCase(line), "partition") > 0 Then
			count = count + 1
			volumes = volumes & line
		End If
	Loop

	If count = 0 Then
		WScript.Echo "No volumes available!"
	Else
		WScript.Echo "The following volumes are available in the local disk(s):"
		ShowBanner(volumes)
	End If
	
	ShowVolumes = count
End Function

Function ShowDisks
	Set processObj = ExecuteDiskPart("list disk")
	count = 0
	
	WScript.Echo "The following disks are available:"
	WScript.Echo "*******************************************************************************"

	Do Until processObj.StdOut.AtEndOfStream
		line = processObj.StdOut.ReadLine
		count = count + 1
		WScript.Echo line
	Loop

	WScript.Echo "*******************************************************************************"

	ShowDisks = count
End Function

Sub SelectVolumeOrDisk(volumeCount)
	WScript.Echo "Type a volume number for Windows XP installation or * to select a disk: "
	PrintPrompt
	selection = WScript.StdIn.ReadLine
	If LCase(selection) = "*" Then
		SelectDisk
	Else
		UseVolume selection
	End If
End Sub

Sub UseVolume(volumeNumber)
	selection = AskUser("Do you want to Wipe or to Preserve the data on the volume? (W/P)", "W", "P")
	If LCase(selection) = "w" Then
		FormatAndDeploy(volumeNumber)
	Else
		PreserveAndDeploy(volumeNumber)
	End If
End Sub

Sub Deploy()
	WScript.Echo "Applying boot sector..."
	Execute("bootsect /nt52 W: /mbr")
	Dim usbDiskPath : usbDiskPath = GetUsbDiskPath()
	Dim imagePath : imagePath = usbDiskPath & "RESTOREXP.WIM"

	WScript.Echo "Applying Windows XP image (this may take a while)..."
	Execute("imagex /apply " & imagePath & " 1 W:")
	Execute("cscript W_ZHalDetect.vbs")
	If fsoObj.FolderExists("W:\WanovaInstall\PostActions") Then
		Execute("cmd /c rd /s /q W:\WanovaInstall\PostActions")
	End If
	fsoObj.CreateFolder("W:\WanovaInstall\PostActions")
	Execute("xcopy /E " & usbDiskPath & "\PostActions W:\WanovaInstall\PostActions")
End Sub

Sub WipeDiskAndDeploy(diskNumber)
	WScript.Echo "Cleaning disk " & diskNumber & " and creating a new NTFS volume..."
	ExecuteDiskPart("select disk " & diskNumber & vbCrlf &_
			"clean" & vbCrlf &_
			"create partition primary" & vbCrlf &_
			"select partition 1" & vbCrlf &_
			"format fs=ntfs quick override" & vbCrlf &_
			"assign letter=W" & vbCrlf &_
			"active")
	Deploy()
End Sub

Sub FormatAndDeploy(volumeNumber)
	WScript.Echo "Formatting volume " & volumeNumber & "..."
	bootIniDevice = TryGetBootIniDevice()
	ExecuteDiskPart("select volume " & volumeNumber & vbCrlf &_
			"format fs=ntfs quick override" & vbCrlf &_
			"active" & vbCrlf &_
			"assign letter=W")
	Deploy()
	GenerateBootIni(bootIniDevice)
End Sub

Sub MoveSystemDirectories()
	DeleteDirecotryIfExists("W:\Wanova Volume Information")
	
	fsoObj.CreateFolder("W:\Wanova Volume Information")
	fsoObj.CreateFolder("W:\Wanova Volume Information\StagingArea")
	fsoObj.CreateFolder("W:\Wanova Volume Information\StagingArea\c")

	fsoObj.MoveFolder "W:\Windows" , "W:\Wanova Volume Information\StagingArea\c\"
	fsoObj.MoveFolder "W:\Program Files" , "W:\Wanova Volume Information\StagingArea\c\"
End Sub

Sub DeleteDirecotryIfExists(path)
	If fsoObj.FolderExists(path) Then
		WScript.Echo "Deleting directory " & path & "..."
		Execute("cmd /c rd /s /q """ & path & """")
	Else
		WScript.Echo "Directory " & path & " doesn't exist, skipping deletion."
	End If
End Sub

Sub DeleteDocumentsAndSettingsJunction()
	WScript.Echo "Deleting Documents and Settings junction (if any)..."
	ExecuteDontCheckExitCode("cmd /c rmdir ""W:\Documents and Settings""")
End Sub

Sub PreserveAndDeploy(volumeNumber)
	WScript.Echo "Setting active partition..."
	ExecuteDiskPart("select volume " & volumeNumber & vbCrlf &_
			"active" & vbCrlf &_
			"assign letter=W")
	bootIniDevice = TryGetBootIniDevice()
	MoveSystemDirectories()
	DeleteDocumentsAndSettingsJunction()
	Deploy()
	GenerateBootIni(bootIniDevice)
End Sub

Sub PrintPrompt
	WScript.StdOut.Write "> "
End Sub

Sub SelectDisk
	diskCount = ShowDisks
	selection = -1
	Do Until selection < diskCount And selection >= 0
		WScript.Echo "Type a disk number: "
		PrintPrompt
		selection = CInt(WScript.StdIn.ReadLine)
	Loop

	UseDisk selection
End Sub

Sub UseDisk(diskNumber)
	selection = AskUser("All data on disk " & diskNumber & " will be wiped. Are you sure? (Y/N)", "Y", "N")
	If LCase(selection) = "y" Then
		WipeDiskAndDeploy(diskNumber)
	Else
		WScript.Echo "Quitting."
		WScript.Quit
	End If
End Sub

Function GetUsbDiskPath()
	For Each drive in fsoObj.Drives
		If drive.IsReady Then
			Dim pathToTest : pathToTest = drive & "\RESTOREXP.WIM"
			If fsoObj.FileExists(pathToTest) Then
				GetUsbDiskPath = drive & "\"
				Exit Function
			End If
		End If
	Next
	WScript.Echo "Cannot find RESTOREXP.WIM."
	WScript.Quit 2
End Function

Function AskUser(question, option1, option2)
	WScript.Echo question
	answer = ""
	gotAnswer = False
	Do Until gotAnswer
		PrintPrompt
		answer = WScript.StdIn.ReadLine
		gotAnswer = AcceptableAnswer(answer, option1, option2)
		If Not gotAnswer Then WScript.Echo "Invalid input, please try again."         
	Loop
	AskUser = answer
End Function

Function AcceptableAnswer(answer, option1, option2)
	AcceptableAnswer = (LCase(answer) = LCase(option1) Or LCase(answer) = LCase(option2))
End Function

Function GetBootIniDeviceFromOldBootIni(driveLetter)
	GetBootIniDeviceFromOldBootIni = ""
	Execute("attrib -r -h -s " & driveLetter & ":\boot.ini")
	Set processObj = Execute("cmd /c type " & driveLetter & ":\boot.ini")
	count = 0
	Do Until processObj.StdOut.AtEndOfStream
		line = processObj.StdOut.ReadLine
		index = InStr(LCase(line), "multi(")
		If index > 1 Then
			bootIniWithWindowsPostfix = Mid(line, index)
			index = InStr(bootIniWithWindowsPostfix, "\")
			GetBootIniDeviceFromOldBootIni = Mid(bootIniWithWindowsPostfix, 1, index-1)
			Exit Function
		End If
	Loop
End Function

Function GetBootIniDeviceFromWin7Registry(driveLetter)
	GetBootIniDeviceFromWin7Registry = ""
	
	Execute("reg load HKLM\TempHive " & driveLetter & ":\windows\system32\config\system")
	
	Set processObj = Execute("reg query HKLM\TempHive\ControlSet001\control /v SystemBootDevice")
	Do Until processObj.StdOut.AtEndOfStream
		line = processObj.StdOut.ReadLine
		index = InStr(LCase(line), "multi(")
		If index > 0 Then
			GetBootIniDeviceFromWin7Registry = Mid(Line, index)
		End If
	Loop

	Execute("reg unload HKLM\TempHive")
End Function

Function TryGetBootIniDevice()
	TryGetBootIniDevice = ""

	Set processObj = ExecuteDiskPart("list volume")
	Do Until processObj.StdOut.AtEndOfStream
		line = processObj.StdOut.ReadLine
		If InStr(LCase(line), "partition") > 0 Then
			driveLetter = Mid(line, 16, 1)
			bootIniDevice = TryGetBootIniDeviceForDrive(driveLetter)
			If bootIniDevice <> "" Then
				TryGetBootIniDevice = bootIniDevice
				Exit Function
			End If
		End If
	Loop
	
End Function

Function TryGetBootIniDeviceForDrive(driveLetter)
	TryGetBootIniDeviceForDrive = ""

	If fsoObj.FileExists(driveLetter & ":\boot.ini") Then
		TryGetBootIniDeviceForDrive = GetBootIniDeviceFromOldBootIni(driveLetter)
		Exit Function
	End If

	If fsoObj.FileExists(driveLetter & ":\windows\system32\config\system") Then
		TryGetBootIniDeviceForDrive = GetBootIniDeviceFromWin7Registry(driveLetter)
		Exit Function
	End If
End Function

Sub GenerateBootIni(bootIniDevice)
	If bootIniDevice = "" Then
		WScript.Echo "Warning: using default boot.ini."
	Else
		WScript.Echo "Generating boot.ini..."
		Execute("attrib -r -h -s W:\boot.ini")
		
		Set BootIniTextFile = fsoObj.CreateTextFile("W:\boot.ini", True)
		BootIniTextFile.WriteLine("[boot loader]")
		BootIniTextFile.WriteLine("timeout=0")
		BootIniTextFile.WriteLine("default=" & bootIniDevice & "\WINDOWS")
		BootIniTextFile.WriteLine("[operating systems]")
		BootIniTextFile.WriteLine(bootIniDevice & "\WINDOWS=""Microsoft Windows XP Professional"" /noexecute=optin /fastdetect")
		BootIniTextFile.Close

		Execute("attrib +r +h +s W:\boot.ini")
	End If
End Sub

Function ExecuteDiskPart(command)
	Set DiskPartTextFile = fsoObj.CreateTextFile("x:\windows\temp\diskpart_temp.txt", True)
	DiskPartTextFile.WriteLine(Command)
	DiskPartTextFile.Close
	Set ExecuteDiskPart = Execute("diskpart /s x:\windows\temp\diskpart_temp.txt")	
End Function

Function Execute(Command)
	If verboseLogging Then WScript.Echo "Running command: " & Command
	Set processObj = shellObj.Exec(command)
	Do While processObj.Status = 0
		WScript.Sleep 500
	Loop
	If processObj.ExitCode <> 0 Then
		WScript.Echo "Command failed with status " & processObj.ExitCode & " : " & Command
		WScript.Echo "StdOut: " & processObj.StdOut.ReadAll
		WScript.Echo "To retry, please reboot the machine from USB disk again."
		WScript.Quit 1
	End If
	If verboseLogging Then WScript.Echo "Command completed successfully."
	Set Execute = processObj
End Function

Function ExecuteDontCheckExitCode(Command)
	If verboseLogging Then WScript.Echo "Running command: " & Command
	Set processObj = shellObj.Exec(command)
	Do While processObj.Status = 0
		WScript.Sleep 500
	Loop
	If verboseLogging Then WScript.Echo "Command completed."
	Set ExecuteDontCheckExitCode = processObj
End Function

