@echo off

echo ***********************************************
echo * VMware XP USB Disk Creator
echo ***********************************************

if "123%1" == "123" goto usage
if "123%2" == "123" goto usage
if "123%3" == "123" goto usage
if "123%4" == "123" goto usage
if "123%5" == "123" goto usage

set winxp_cd_path=%1
set msi_path=%2
set server_ip=%3
set use_ssl_transport=%4
set usb_disk_number=%5

set usb_drive_letter=u
set usb_path=%usb_drive_letter%:\
set mount_point=%CD%\mount

echo ***********************************************
echo *** Partitioning USB disk
echo ***********************************************
echo select disk %usb_disk_number% > diskpart.txt
echo clean >> diskpart.txt
echo create partition primary >> diskpart.txt
echo select partition 1 >> diskpart.txt
echo active >> diskpart.txt
echo format fs=fat32 quick >> diskpart.txt
echo assign letter=%usb_drive_letter% >> diskpart.txt
echo exit >> diskpart.txt
diskpart /s diskpart.txt
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Copying XP Restore CD into USB disk
echo ***********************************************
xcopy %winxp_cd_path%\*.* %usb_path%\ /e /h /f
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Mounting boot.wim
echo ***********************************************
mkdir "%mount_point%"
dism /mount-wim /wimfile:%usb_path%\sources\boot.wim /index:1 /mountdir:"%mount_point%"
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Copying xpboot.vbs into wim
echo ***********************************************
copy /Y xpboot.vbs "%mount_point%\WanovaRestore\xpboot.vbs"
copy /Y W_ZHalDetect.vbs "%mount_point%\WanovaRestore\W_ZHalDetect.vbs"
copy /Y W_ZTIUtility.vbs "%mount_point%\WanovaRestore\W_ZTIUtility.vbs"
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Unmounting boot.wim
echo ***********************************************
dism /unmount-wim /mountdir:"%mount_point%" /commit
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Copying Mirage client to USB disk
echo ***********************************************
mkdir %usb_path%\PostActions
if %errorlevel% neq 0 goto errend
copy %msi_path% %usb_path%\PostActions\MirageClient.msi
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Creating Mirage installation command line
echo ***********************************************
echo msiexec /norestart /quiet /l* %%temp%%\MirageClient.log /i %%post_actions_dir%%\MirageClient.msi serverip=%server_ip% usessltransport=%use_ssl_transport% > %usb_path%\InstallClient.cmd
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Copying SetupComplete.cmd to USB disk
echo ***********************************************
copy SetupCompleteOnDisk.cmd %usb_path%\PostActions\SetupComplete.cmd
if %errorlevel% neq 0 goto errend

echo ***********************************************
echo *** Done!
echo ***********************************************
echo You may edit %usb_path%\PostActions\SetupComplete.cmd to execute additional custom post-deployment actions. 
echo You may later replace %usb_path%\PostActions\MirageClient.msi with any other version of the Mirage client installer.
echo You may edit %usb_path%\InstallClient.cmd to change the Mirage client installation command line.
echo To launch the Wanova Recovery Environment, boot from the USB disk and follow the on-screen instructions.
del /q /f diskpart.txt
rmdir /q "%mount_point%"
exit 0

:usage
echo Usage: xpusb.cmd [xp restore cd path] [msi path] [server address] [use ssl transport (true/false)] [usb disk number]
echo Available disks (for finding your USB disk number):
echo list disk > diskpart.txt
diskpart /s diskpart.txt
exit 1

:errend
echo ***********************************************
echo *** Error!
echo ***********************************************
del /q /f diskpart.txt
rmdir /q "%mount_point%"
exit 1