/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn.json;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.cis.authn.SamlAuthenticationData;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.internal.cis.authn.Signer;
import com.vmware.vapi.internal.cis.authn.json.JsonSignatureAlgorithm;
import com.vmware.vapi.internal.cis.authn.json.JsonSignerImpl;
import com.vmware.vapi.internal.dsig.json.Canonicalizer;
import com.vmware.vapi.internal.dsig.json.JsonCanonicalizer;
import com.vmware.vapi.internal.protocol.common.json.JsonSecurityContextSerializer;
import com.vmware.vapi.internal.util.DateTimeConverter;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.protocol.RequestProcessor;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonSigningProcessor
implements RequestProcessor {
    private static final String UTF8_CHARSET = "UTF-8";
    private static final Logger logger = LoggerFactory.getLogger(JsonSigningProcessor.class);
    private static final Message DECODE_ERROR = MessageFactory.getMessage((String)"vapi.sso.signproc.decoderequest", (String[])new String[0]);
    private final Signer jsonSigner;
    private final JsonSecurityContextSerializer scSerializer = new JsonSecurityContextSerializer();
    private final DateTimeConverter dateConverter = new DateTimeConverter();

    public JsonSigningProcessor() {
        this.jsonSigner = new JsonSignerImpl((Canonicalizer)new JsonCanonicalizer());
    }

    public byte[] process(byte[] request, Map<String, Object> metadata, RequestProcessor.Request vapiRequest) {
        Validate.notNull((Object)request);
        Validate.notNull(metadata);
        byte[] result = request;
        Object secCtx = metadata.get("security_context");
        if (this.shouldSignRequest(secCtx)) {
            try {
                String requestStr = new String(request, UTF8_CHARSET);
                result = this.signRequest(requestStr, (ExecutionContext.SecurityContext)secCtx);
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException(DECODE_ERROR);
            }
        }
        return result;
    }

    boolean shouldSignRequest(Object secCtx) {
        ExecutionContext.SecurityContext context;
        boolean shouldSign = false;
        if (secCtx != null && secCtx instanceof ExecutionContext.SecurityContext && "com.vmware.vapi.std.security.saml_hok_token".equals((context = (ExecutionContext.SecurityContext)secCtx).getProperty("authn_scheme_id"))) {
            SamlAuthenticationData sc = SecurityContextFactory.parseSamlSecurityContext(context);
            shouldSign = sc.getPrivateKey() != null;
        }
        return shouldSign;
    }

    private byte[] signRequest(String jsonRequest, ExecutionContext.SecurityContext secCtx) throws UnsupportedEncodingException {
        assert (jsonRequest != null && secCtx != null);
        logger.debug("Signing the request");
        HashMap<String, Object> secCtxMap = new HashMap<String, Object>();
        secCtxMap.put("schemeId", "com.vmware.vapi.std.security.saml_hok_token");
        secCtxMap.put("timestamp", this.createTimestamp(10));
        secCtxMap.put("signatureAlgorithm", JsonSignatureAlgorithm.getDefault().name());
        String signRequest = this.scSerializer.serializeSecurityContext(secCtxMap, jsonRequest);
        SamlAuthenticationData sc = SecurityContextFactory.parseSamlSecurityContext(secCtx);
        String signature = this.jsonSigner.sign(signRequest, sc.getPrivateKey(), JsonSignatureAlgorithm.getDefault());
        HashMap<String, String> scSigValue = new HashMap<String, String>();
        scSigValue.put("value", signature);
        String xmlText = sc.getSamlTokenXml();
        scSigValue.put("samlToken", xmlText);
        secCtxMap.put("signature", scSigValue);
        jsonRequest = this.scSerializer.serializeSecurityContext(secCtxMap, jsonRequest);
        return jsonRequest.getBytes(UTF8_CHARSET);
    }

    private Map<String, String> createTimestamp(int offset) {
        Calendar cal = Calendar.getInstance();
        HashMap<String, String> ts = new HashMap<String, String>();
        ts.put("created", this.dateConverter.toStringValue(cal));
        cal.add(12, offset);
        ts.put("expires", this.dateConverter.toStringValue(cal));
        return ts;
    }
}

