/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.client.util;

import com.vmware.vapi.client.util.SecurityContextAcquisitionError;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.DecoratorApiProvider;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.std.errors.Unauthenticated;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAuthnFilter
extends DecoratorApiProvider {
    private static final int MAX_GENERATION = 1000000;
    private static String UNAUTHENTICATED = Unauthenticated._getCanonicalTypeName();
    private static Logger LOGGER = LoggerFactory.getLogger(DynamicAuthnFilter.class);
    private Supplier<CompletionStage<ExecutionContext.SecurityContext>> secCtxFactory;
    private volatile SecurityHolder cache;
    private volatile int generationCounter = 1;
    private final Object lock = new Object();
    private final long timeoutMs;

    public DynamicAuthnFilter(ApiProvider decoratedProvider, Supplier<CompletionStage<ExecutionContext.SecurityContext>> supplier, long timeoutMs) {
        super(decoratedProvider);
        Objects.requireNonNull(supplier, "Supplier cannot be null");
        if (timeoutMs <= 0L) {
            throw new IllegalArgumentException("timeoutMs must be positive");
        }
        this.secCtxFactory = supplier;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public void invoke(String service, String operation, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        SecurityHolder holder = this.getOrRefreshSecCtx(0);
        int generaton = holder.getGeneration();
        holder.getSecCtxFuture().thenAccept(security -> {
            UnauthenticatedHandler handler = new UnauthenticatedHandler(service, operation, input, ctx, asyncHandle, generaton);
            ExecutionContext newCtx = ctx.withSecurityContext((ExecutionContext.SecurityContext)security);
            this.invokeNext(service, operation, input, newCtx, handler);
        }).exceptionally(ex -> {
            holder.signalFailure();
            LOGGER.debug("Failed to obtain security context", ex);
            asyncHandle.setError(new SecurityContextAcquisitionError("Cannot obtain security context", (Throwable)ex));
            return null;
        });
    }

    protected void invokeNext(String service, String operation, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> handle) {
        try {
            this.decoratedProvider.invoke(service, operation, input, ctx, handle);
        }
        catch (RuntimeException ex) {
            handle.setError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityHolder getOrRefreshSecCtx(int generation) {
        SecurityHolder holder = this.cache;
        if (holder != null && holder.usable(generation)) {
            LOGGER.trace("Using cached context");
            return holder;
        }
        Object object = this.lock;
        synchronized (object) {
            CompletionStage<ExecutionContext.SecurityContext> future;
            holder = this.cache;
            if (holder != null && holder.usable(generation)) {
                LOGGER.trace("Using newly provisioned cached context");
                return holder;
            }
            this.cache = null;
            LOGGER.debug("Acquiring new security context future");
            try {
                future = this.secCtxFactory.get();
            }
            catch (RuntimeException ex) {
                LOGGER.debug("Error acquiring future for security context", (Throwable)ex);
                CompletableFuture<ExecutionContext.SecurityContext> r = new CompletableFuture<ExecutionContext.SecurityContext>();
                r.completeExceptionally(ex);
                return new SecurityHolder(0, r);
            }
            this.cache = holder = new SecurityHolder(this.nextGeneration(), future);
            return holder;
        }
    }

    private int nextGeneration() {
        this.generationCounter = this.generationCounter % 1000000 + 1;
        return this.generationCounter;
    }

    private class SecurityHolder {
        private int generation;
        private CompletionStage<ExecutionContext.SecurityContext> secCtxFuture;
        private Object lock = new Object();
        private volatile long failedAt = 0L;

        public SecurityHolder(int generation, CompletionStage<ExecutionContext.SecurityContext> secCtxFuture) {
            this.generation = generation;
            this.secCtxFuture = secCtxFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalFailure() {
            if (this.failedAt == 0L) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.failedAt == 0L) {
                        this.failedAt = System.currentTimeMillis();
                    }
                }
            }
        }

        public boolean usable(int generation) {
            long failedAt = this.failedAt;
            boolean attempted = generation == this.generation;
            long now = System.currentTimeMillis();
            boolean needsRefresh = failedAt > 0L && failedAt + DynamicAuthnFilter.this.timeoutMs < now;
            return !attempted && !needsRefresh;
        }

        public CompletionStage<ExecutionContext.SecurityContext> getSecCtxFuture() {
            return this.secCtxFuture;
        }

        public int getGeneration() {
            return this.generation;
        }
    }

    private class UnauthenticatedHandler
    extends AsyncHandle<MethodResult> {
        private final String service;
        private final String operation;
        private final DataValue input;
        private final ExecutionContext ctx;
        private final AsyncHandle<MethodResult> next;
        private final int generation;

        public UnauthenticatedHandler(String service, String operation, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle, int generation) {
            this.service = service;
            this.operation = operation;
            this.input = input;
            this.ctx = ctx;
            this.next = asyncHandle;
            this.generation = generation;
        }

        @Override
        public void setResult(MethodResult result) {
            ErrorValue err = result.getError();
            if (err != null && UNAUTHENTICATED.equals(err.getName())) {
                LOGGER.debug("Unauthenticated. Recreating security context");
                if (result.getNext() != null) {
                    result.getNext().accept(null);
                }
                SecurityHolder holder = DynamicAuthnFilter.this.getOrRefreshSecCtx(this.generation);
                holder.getSecCtxFuture().thenAccept(security -> {
                    ExecutionContext c = this.ctx.withSecurityContext((ExecutionContext.SecurityContext)security);
                    DynamicAuthnFilter.this.invokeNext(this.service, this.operation, this.input, c, this.next);
                }).exceptionally(ex -> {
                    holder.signalFailure();
                    LOGGER.debug("Failed to refresh security context", ex);
                    this.next.setError(new SecurityContextAcquisitionError("Cannot refresh expired authentication context", (Throwable)ex));
                    return null;
                });
                return;
            }
            this.next.setResult(result);
        }

        @Override
        public void setError(RuntimeException error) {
            this.next.setError(error);
        }

        @Override
        public void updateProgress(DataValue progress) {
            this.next.updateProgress(progress);
        }
    }
}

