/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHandleSyncAdapter<T>
extends AsyncHandle<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHandleSyncAdapter.class);
    private final Lock lock = new ReentrantLock();
    private final Condition set = this.lock.newCondition();
    private boolean completed = false;
    private T result;
    private RuntimeException error;

    private void await() {
        this.lock.lock();
        try {
            while (!this.completed) {
                this.set.await();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T get() {
        this.await();
        if (this.error != null) {
            throw this.error;
        }
        return this.result;
    }

    @Override
    public void setResult(T result) {
        this.tryReadHttpTerminalFrame(result);
        this.lock.lock();
        try {
            this.assertNotCompleted();
            this.result = result;
            this.completed = true;
            this.set.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setError(RuntimeException value) {
        this.lock.lock();
        try {
            this.assertNotCompleted();
            this.error = value;
            this.completed = true;
            this.set.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateProgress(DataValue progress) {
        this.lock.lock();
        try {
            this.assertNotCompleted();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assertNotCompleted() {
        if (this.completed) {
            throw new IllegalStateException("Operation is already completed");
        }
    }

    private void tryReadHttpTerminalFrame(T methodResult) {
        try {
            if (methodResult instanceof MethodResult) {
                LOGGER.debug("Attempting to close the TCP connection.");
                MethodResult result = (MethodResult)methodResult;
                if (result.getNext() != null) {
                    LOGGER.debug("Reading HTTP terminal frame.");
                    result.getNext().accept(null);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to read HTTP terminal frame. Connection not closed.", (Throwable)e);
        }
    }
}

