/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.core;

import com.vmware.vapi.core.HttpResponseAccessor;
import com.vmware.vapi.internal.util.Validate;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExecutionContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient SecurityContext securityContext;
    private final transient ApplicationData applicationData;
    private final transient RuntimeData runtimeData;
    public static final ExecutionContext EMPTY = new ExecutionContext();

    public ExecutionContext() {
        this(null, null, null);
    }

    public ExecutionContext(SecurityContext securityContext) {
        this(null, securityContext, null);
    }

    public ExecutionContext(ApplicationData wireData, SecurityContext securityContext) {
        this(wireData, securityContext, null);
    }

    public ExecutionContext(ApplicationData wireData, SecurityContext securityContext, RuntimeData runtimeData) {
        this.applicationData = wireData;
        this.securityContext = securityContext;
        this.runtimeData = runtimeData;
    }

    public ExecutionContext withApplicationData(ApplicationData appData) {
        return new ExecutionContext(appData, this.securityContext, this.runtimeData);
    }

    public ExecutionContext withSecurityContext(SecurityContext secCtx) {
        return new ExecutionContext(this.applicationData, secCtx, this.runtimeData);
    }

    public ApplicationData retrieveApplicationData() {
        return this.applicationData;
    }

    public SecurityContext retrieveSecurityContext() {
        return this.securityContext;
    }

    public RuntimeData retrieveRuntimeData() {
        return this.runtimeData;
    }

    public static class Builder {
        private Map<String, String> appData;
        private SecurityContext securityContext;
        private Integer readTimeout;
        private HttpResponseAccessor responseAccessor;
        private Map<String, Object> runtimeKeyValueEntries;

        public Builder() {
        }

        private Builder(ExecutionContext ec) {
            Objects.requireNonNull(ec);
            this.setApplicationData(ec.retrieveApplicationData());
            this.securityContext = ec.retrieveSecurityContext();
            this.setRuntimeData(ec.retrieveRuntimeData());
        }

        public static Builder from(ExecutionContext ec) {
            return ec != null ? new Builder(ec) : new Builder();
        }

        public Builder setApplicationData(ApplicationData applicationData) {
            this.appData = applicationData != null ? new HashMap<String, String>(applicationData.getAllProperties()) : null;
            return this;
        }

        private void setRuntimeData(RuntimeData runtimeData) {
            if (runtimeData == null) {
                return;
            }
            this.readTimeout = runtimeData.getReadTimeout();
            this.responseAccessor = runtimeData.getResponseAccessor();
            if (runtimeData.keyValueEntries != null) {
                this.runtimeKeyValueEntries = new HashMap<String, Object>(runtimeData.keyValueEntries);
            }
        }

        public Builder mergeApplicationData(String key, String value) {
            if (this.appData == null) {
                this.appData = new HashMap<String, String>();
            }
            this.appData.put(key, value);
            return this;
        }

        public Builder mergeApplicationData(Map<String, String> data) {
            if (this.appData == null) {
                this.appData = new HashMap<String, String>();
            }
            this.appData.putAll(data);
            return this;
        }

        public Builder setSecurityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public Builder setReadTimeout(Integer readTimeout) {
            Builder.assertNonNegative(readTimeout);
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setResponseAccessor(HttpResponseAccessor responseAccessor) {
            this.responseAccessor = responseAccessor;
            return this;
        }

        public Builder setRuntimeKeyValue(String key, Object value) {
            if (this.runtimeKeyValueEntries == null) {
                this.runtimeKeyValueEntries = new HashMap<String, Object>();
            }
            this.runtimeKeyValueEntries.put(key, value);
            return this;
        }

        private static void assertNonNegative(Integer value) {
            if (value != null && value < 0) {
                throw new IllegalArgumentException("Non-negative value or null expected");
            }
        }

        public ExecutionContext build() {
            return new ExecutionContext(this.getApplicationData(), this.securityContext, this.getRuntimeData());
        }

        private ApplicationData getApplicationData() {
            return this.appData != null ? new ApplicationData(this.appData) : null;
        }

        private RuntimeData getRuntimeData() {
            RuntimeData rData = new RuntimeData(this.readTimeout, this.responseAccessor, this.runtimeKeyValueEntries);
            return rData;
        }
    }

    public static class RuntimeData {
        private final Integer readTimeout;
        private final HttpResponseAccessor responseAccessor;
        private final Map<String, Object> keyValueEntries;

        private RuntimeData(Integer readTimeout, HttpResponseAccessor responseAccessor, Map<String, Object> keyValueEntries) {
            this.readTimeout = readTimeout;
            this.responseAccessor = responseAccessor;
            this.keyValueEntries = RuntimeData.copyMap(keyValueEntries);
        }

        private static Map<String, Object> copyMap(Map<String, Object> map) {
            if (map == null || map.size() == 0) {
                return null;
            }
            if (map.size() == 1) {
                Map.Entry<String, Object> entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
            HashMap<String, Object> entries = new HashMap<String, Object>(map.size(), 1.0f);
            entries.putAll(map);
            return entries;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public HttpResponseAccessor getResponseAccessor() {
            return this.responseAccessor;
        }

        public Object getValue(String key) {
            Validate.notNull(key);
            if (this.keyValueEntries == null) {
                return null;
            }
            return this.keyValueEntries.get(key);
        }
    }

    public static interface SecurityContext {
        public static final String AUTHENTICATION_SCHEME_ID = "authn_scheme_id";
        public static final String AUTHENTICATION_DATA_ID = "authn_data_id";

        public Object getProperty(String var1);

        public Map<String, Object> getAllProperties();
    }

    public static class ApplicationData {
        public static final String USER_AGENT_KEY = "$userAgent";
        public static final String TIMEZONE_KEY = "timezone";
        public static final String ACCEPT_LANGUAGE_KEY = "accept-language";
        public static final String FORMAT_LOCALE_KEY = "format-locale";
        private final Map<String, String> wireData;

        public ApplicationData() {
            this.wireData = Collections.emptyMap();
        }

        public ApplicationData(Map<String, String> data) {
            this.wireData = new HashMap<String, String>(data.size(), 1.0f);
            this.wireData.putAll(data);
        }

        public ApplicationData(String key, String value) {
            this.wireData = Collections.singletonMap(key, value);
        }

        private ApplicationData(ApplicationData source, Map<String, String> data) {
            this.wireData = new HashMap<String, String>(source.wireData.size() + data.size(), 1.0f);
            this.wireData.putAll(source.wireData);
            this.wireData.putAll(data);
        }

        private ApplicationData(ApplicationData source, String key, String value) {
            this.wireData = new HashMap<String, String>(source.wireData.size() + 1, 1.0f);
            this.wireData.putAll(source.wireData);
            this.wireData.put(key, value);
        }

        public String getProperty(String key) {
            return this.wireData.get(key);
        }

        public Map<String, String> getAllProperties() {
            return Collections.unmodifiableMap(this.wireData);
        }

        public static ApplicationData merge(ApplicationData source, Map<String, String> data) {
            if (source == null) {
                return new ApplicationData(data);
            }
            return new ApplicationData(source, data);
        }

        public static ApplicationData merge(ApplicationData source, String key, String value) {
            if (source == null || source.wireData.size() == 0) {
                return new ApplicationData(key, value);
            }
            return new ApplicationData(source, key, value);
        }
    }
}

