/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.ValueVisitor;
import com.vmware.vapi.internal.util.Validate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StructValue
implements DataValue {
    private static final long serialVersionUID = 1L;
    private final HashMap<String, DataValue> fields;
    private final String name;

    public StructValue(String name) {
        Validate.notNull(name);
        this.name = name;
        this.fields = new HashMap();
    }

    @Override
    public DataType getType() {
        return DataType.STRUCTURE;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }

    public boolean hasField(String field) {
        return this.fields.containsKey(field);
    }

    public DataValue getField(String field) {
        if (this.fields.containsKey(field)) {
            return this.fields.get(field);
        }
        throw new CoreException("vapi.data.structure.getfield.unknown", field);
    }

    public Map<String, DataValue> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public long getInteger(String field) {
        DataValue value = this.getField(field);
        if (value instanceof IntegerValue) {
            IntegerValue tmp = (IntegerValue)value;
            return tmp.getValue();
        }
        throw new CoreException("vapi.data.structure.getfield.mismatch", field, "Integer", value.getType().toString());
    }

    public double getDouble(String field) {
        DataValue value = this.getField(field);
        if (value instanceof DoubleValue) {
            DoubleValue tmp = (DoubleValue)value;
            return tmp.getValue();
        }
        throw new CoreException("vapi.data.structure.getfield.mismatch", field, "Double", value.getType().toString());
    }

    public boolean getBoolean(String field) {
        DataValue value = this.getField(field);
        if (value instanceof BooleanValue) {
            BooleanValue tmp = (BooleanValue)value;
            return tmp.getValue();
        }
        throw new CoreException("vapi.data.structure.getfield.mismatch", field, "Boolean", value.getType().toString());
    }

    public String getString(String fieldName) {
        DataValue value = this.getField(fieldName);
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        throw new CoreException("vapi.data.structure.getfield.mismatch", fieldName, "String", value.getType().toString());
    }

    public char[] getSecret(String field) {
        DataValue value = this.getField(field);
        if (value instanceof SecretValue) {
            return ((SecretValue)value).getValue();
        }
        throw new CoreException("vapi.data.structure.getfield.mismatch", field, "Secret", value.getType().toString());
    }

    public OptionalValue getOptional(String field) {
        DataValue value = this.getField(field);
        if (value instanceof OptionalValue) {
            return (OptionalValue)value;
        }
        throw new CoreException("vapi.data.structure.getfield.mismatch", field, "Optional", value.getType().toString());
    }

    public ListValue getList(String field) {
        DataValue value = this.getField(field);
        if (value instanceof ListValue) {
            return (ListValue)value;
        }
        throw new CoreException("vapi.data.structure.getfield.mismatch", field, "List", value.getType().toString());
    }

    public StructValue getStruct(String field) {
        DataValue value = this.getField(field);
        if (value instanceof StructValue) {
            return (StructValue)value;
        }
        throw new CoreException("vapi.data.structure.getfield.mismatch", field, "Struct", value.getType().toString());
    }

    public void setField(String field, DataValue value) {
        if (field == null || value == null) {
            throw new CoreException("vapi.data.structure.setfield.null", field);
        }
        this.fields.put(field, value);
    }

    public void setField(String field, long value) {
        this.setField(field, new IntegerValue(value));
    }

    public void setField(String field, boolean value) {
        this.setField(field, BooleanValue.getInstance(value));
    }

    public void setField(String field, double value) {
        this.setField(field, new DoubleValue(value));
    }

    public void setField(String field, String value) {
        this.setField(field, new StringValue(value));
    }

    public void setField(String field, char[] value) {
        this.setField(field, new SecretValue(value));
    }

    public void setOptionalField(String field, Long value) {
        this.setField(field, new OptionalValue(value));
    }

    public void setOptionalField(String field, Boolean value) {
        this.setField(field, new OptionalValue(value));
    }

    public void setOptionalField(String field, Double value) {
        this.setField(field, new OptionalValue(value));
    }

    public void setOptionalField(String field, String value) {
        this.setField(field, new OptionalValue(value));
    }

    public void setOptionalField(String field, long value) {
        this.setField(field, new OptionalValue(value));
    }

    public void setOptionalField(String field, boolean value) {
        this.setField(field, new OptionalValue(value));
    }

    public void setOptionalField(String field, double value) {
        this.setField(field, new OptionalValue(value));
    }

    public boolean equals(Object other) {
        if (!StructValue.class.isInstance(other)) {
            return false;
        }
        StructValue strOther = (StructValue)other;
        if (!strOther.name.equals(this.name)) {
            return false;
        }
        return this.fields.equals(strOther.fields);
    }

    public int hashCode() {
        int hash = 17 + this.name.hashCode();
        hash = hash * 31 + this.fields.hashCode();
        return hash;
    }

    public String toString() {
        return this.name + " => " + this.fields.toString();
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StructValue copy() {
        StructValue result = new StructValue(this.name);
        for (String field : this.fields.keySet()) {
            result.setField(field, this.getField(field).copy());
        }
        return result;
    }
}

