/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.dsig.json;

import com.vmware.vapi.dsig.json.StsTrustChain;
import com.vmware.vapi.internal.dsig.json.KeyStoreHelper;
import com.vmware.vapi.internal.util.Validate;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public final class DefaultStsTrustChain
implements StsTrustChain {
    private final X509Certificate[] trustedChain;

    private DefaultStsTrustChain(X509Certificate[] trustedChain) {
        Validate.notEmpty(trustedChain);
        Validate.noNullElements(trustedChain);
        this.trustedChain = trustedChain;
    }

    public DefaultStsTrustChain() {
        this.trustedChain = null;
    }

    @Override
    public X509Certificate[] getStsTrustChain() {
        return Arrays.copyOf(this.trustedChain, this.trustedChain.length);
    }

    public static DefaultStsTrustChain loadFromKeystore(String fileName, String password, String certAlias) {
        Validate.notNull(fileName);
        Validate.notNull(certAlias);
        KeyStoreHelper keyStore = new KeyStoreHelper(DefaultStsTrustChain.class.getResource(fileName).getFile(), password == null ? new char[]{} : password.toCharArray());
        return new DefaultStsTrustChain(new X509Certificate[]{keyStore.getCertificate(certAlias)});
    }

    public static DefaultStsTrustChain createInstance(X509Certificate[] trustedChain) {
        Validate.notNull(trustedChain);
        return new DefaultStsTrustChain(Arrays.copyOf(trustedChain, trustedChain.length));
    }
}

