/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.client.exception.BindingsException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.std.Progress;

public final class ProgressConverter {
    public static final String PROGRESS_STRUCT_NAME = "com.vmware.vapi.std.progress";
    public static final String PROGRESS_FIELD_MIN = "min";
    public static final String PROGRESS_FIELD_MAX = "max";
    public static final String PROGRESS_FIELD_CURRENT = "current";

    public static StructValue toValue(Progress progress) {
        Validate.notNull(progress);
        StructValue s = new StructValue(PROGRESS_STRUCT_NAME);
        s.setField(PROGRESS_FIELD_MIN, progress.getMin());
        s.setField(PROGRESS_FIELD_MAX, progress.getMax());
        s.setField(PROGRESS_FIELD_CURRENT, progress.getCurrent());
        return s;
    }

    public static Progress fromValue(DataValue value) {
        Validate.notNull(value);
        if (!(value instanceof StructValue)) {
            throw new BindingsException(String.format("Invalid progress notification format: expected structure '%s', found '%s' value", PROGRESS_STRUCT_NAME, value.getType().name()));
        }
        StructValue s = (StructValue)value;
        if (!PROGRESS_STRUCT_NAME.equals(s.getName())) {
            throw new BindingsException(String.format("Invalid progress notification format: expected structure '%s', found structure '%s'", PROGRESS_STRUCT_NAME, s.getName()));
        }
        long min = ProgressConverter.getProgressField(s, PROGRESS_FIELD_MIN);
        long max = ProgressConverter.getProgressField(s, PROGRESS_FIELD_MAX);
        long current = ProgressConverter.getProgressField(s, PROGRESS_FIELD_CURRENT);
        try {
            return new Progress(min, max, current);
        }
        catch (IllegalArgumentException ex) {
            throw new BindingsException("Invalid progress notification: " + ex.getMessage(), ex);
        }
    }

    private static long getProgressField(StructValue progressStruct, String fieldName) {
        if (!progressStruct.hasField(fieldName)) {
            throw new BindingsException(String.format("Invalid progress notification format: missing field '%s'", fieldName));
        }
        DataValue fieldValue = progressStruct.getField(fieldName);
        if (!(fieldValue instanceof IntegerValue)) {
            throw new BindingsException(String.format("Invalid progress notification format: expected integer field '%s', found '%s' value", fieldName, fieldValue.getType().name()));
        }
        return ((IntegerValue)fieldValue).getValue();
    }
}

