/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.client.rest.authn;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.client.rest.authn.HttpRequestAuthorizer;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;
import com.vmware.vapi.protocol.client.http.RequestPreProcessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeaderAuthenticationAppenderBase
implements RequestPreProcessor,
HttpRequestAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(HeaderAuthenticationAppenderBase.class);

    @Override
    public HttpRequest handle(String serviceId, String operationId, HttpRequest request, DataValue params, ExecutionContext context) {
        ExecutionContext.SecurityContext securityContext = context.retrieveSecurityContext();
        this.authorize(request, securityContext);
        return request;
    }

    @Override
    public void authorize(HttpRequest httpRequest, ExecutionContext.SecurityContext securityContext) {
        if (securityContext == null) {
            logger.debug("Authentication header will not be added.");
            return;
        }
        Object authnSchemeId = securityContext.getProperty("authn_scheme_id");
        logger.debug("Authentication scheme is {}.", authnSchemeId);
        if ("com.vmware.vapi.std.security.oauth".equals(authnSchemeId)) {
            Object token = securityContext.getProperty("accessToken");
            if (token instanceof char[]) {
                this.putAuthorizationHeader(httpRequest, new String((char[])token));
            } else if (token == null) {
                logger.info("No OAuth token found in SecurityContext");
            } else {
                logger.warn("OAuth token in SecurityContext is corrupted");
            }
        } else {
            logger.warn("No authentication added to request - authentication scheme {} is not supported.", authnSchemeId);
        }
    }

    protected void putAuthorizationHeader(HttpRequest request, String token) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(token);
        String name = Objects.requireNonNull(this.getHeaderName());
        String value = Objects.requireNonNull(this.getHeaderValue(token));
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>(request.getHeaders());
        headers.put(name, Arrays.asList(value));
        request.setHeaders(headers);
    }

    protected abstract String getHeaderName();

    protected abstract String getHeaderValue(String var1);
}

