/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.server;

import com.vmware.vapi.internal.tracing.TracingScope;
import com.vmware.vapi.internal.tracing.TracingSpan;
import com.vmware.vapi.tracing.Tracer;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class TraceDecoratedServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String ATTR_TRACING_SPAN = TraceDecoratedServlet.class.getName() + ".TRACING_SPAN";
    private final Tracer tracer;

    public TraceDecoratedServlet() {
        this(Tracer.NO_OP);
    }

    public TraceDecoratedServlet(Tracer tracer) {
        this.tracer = Objects.requireNonNull(tracer);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        TracingSpan span = this.tracer.attachServerSpan(req);
        req.setAttribute(ATTR_TRACING_SPAN, (Object)span);
        try (TracingScope scope = span.makeCurrent();){
            this.doService(req, resp);
        }
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.service(req, resp);
    }

    public static TracingSpan getTracingSpan(HttpServletRequest req) {
        return (TracingSpan)req.getAttribute(ATTR_TRACING_SPAN);
    }
}

