/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.server.rpc.http.util;

import com.vmware.vapi.internal.util.Validate;
import java.io.File;

public final class FileUtil {
    static final String CLASSPATH_URL_PREFIX = "classpath:";
    static final String FILE_SYSTEM_URL_PREFIX = "file:";

    private FileUtil() {
    }

    public static String getAbsoluteFilename(String path) {
        Validate.notNull(path);
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            ClassLoader loader = FileUtil.class.getClassLoader();
            return loader.getResource(FileUtil.stripPrefix(path)).getPath();
        }
        if (path.startsWith(FILE_SYSTEM_URL_PREFIX)) {
            path = FileUtil.stripPrefix(path);
        }
        return new File(path).getAbsolutePath();
    }

    private static String stripPrefix(String path) {
        int indexOfColon = path.indexOf(58);
        if (indexOfColon >= 0) {
            return path.substring(indexOfColon + 1);
        }
        return path;
    }
}

