/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.tracing.otel;

import com.vmware.vapi.Message;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.internal.tracing.TracingScope;
import com.vmware.vapi.internal.tracing.TracingSpan;
import com.vmware.vapi.internal.tracing.otel.OtelTracingScope;
import com.vmware.vapi.internal.tracing.otel.TracingAttributeKey;
import com.vmware.vapi.internal.util.StringUtils;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.std.StandardDataFactory;
import com.vmware.vapi.tracing.TracingLevel;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelTracingSpan
implements TracingSpan {
    private static Logger logger = LoggerFactory.getLogger(OtelTracingSpan.class);
    private static final int MAX_ATTRIBUTE_LENGTH = 255;
    private final Span span;
    private final TracingLevel tracingLevel;
    private OpenTelemetry otel;

    public OtelTracingSpan(OpenTelemetry otel, Span span, TracingLevel tracingLevel) {
        Validate.notNull(span);
        Validate.notNull((Object)tracingLevel);
        this.span = span;
        this.tracingLevel = tracingLevel;
        this.otel = otel;
    }

    @Override
    public TracingScope makeCurrent() {
        return new OtelTracingScope(this.span.makeCurrent());
    }

    @Override
    public <T> TracingSpan setAttribute(TracingAttributeKey<T> key, T value) {
        if (key != null && value != null) {
            AttributeKey<T> attrKey = key.getAttributeKey();
            String sKey = attrKey.getKey();
            int keyLength = sKey.length();
            if (keyLength > 255) {
                logger.warn("Tracing attribute key is longer than {}. Won't set the attribute into the span. key='{}', value='{}'", new Object[]{255, sKey, value});
            } else {
                String sValue = value.toString();
                int maxLengthForValue = 255 - keyLength;
                if (sValue.length() > maxLengthForValue) {
                    String truncatedValue = sValue.substring(0, maxLengthForValue);
                    logger.warn("The combined length of attribute key and value exceeds the maximum length of {} mandated by Wavefront. Truncated the value to fit within the maximum length. key='{}', value='{}', truncatedValue='{}'", new Object[]{255, sKey, value, truncatedValue});
                    this.span.setAttribute(sKey, truncatedValue);
                } else {
                    this.span.setAttribute(attrKey, value);
                }
            }
        }
        return this;
    }

    @Override
    public TracingSpan setStatusOk() {
        logger.trace("span status set to ok");
        this.span.setStatus(StatusCode.OK);
        return this;
    }

    @Override
    public TracingSpan setStatusError(String errorType, String errorMessage) {
        logger.trace("span status set to error");
        if (this.span.isRecording()) {
            this.span.setStatus(StatusCode.ERROR);
            if (StringUtils.isNotBlank(errorType)) {
                this.setAttribute(TracingAttributeKey.ERROR_TYPE, errorType);
            }
            if (StringUtils.isNotBlank(errorMessage)) {
                this.setAttribute(TracingAttributeKey.ERROR_MESSAGE, errorMessage);
            }
        }
        return this;
    }

    @Override
    public TracingSpan setStatusError(Throwable exception) {
        String exceptionType = exception != null ? exception.getClass().getCanonicalName() : null;
        String exceptionMessage = exception != null ? exception.getMessage() : null;
        this.setStatusError(exceptionType, exceptionMessage);
        this.recordException(exception);
        return this;
    }

    @Override
    public TracingSpan setStatusError(ErrorValue errorValue) {
        if (this.span.isRecording()) {
            List<Message> msgs = StandardDataFactory.getMessagesFromErrorValue(errorValue);
            if (!msgs.isEmpty()) {
                Message msg = msgs.get(0);
                this.setStatusError(errorValue.getName(), msg.getDefaultMessage());
                if (this.tracingLevel == TracingLevel.TRACE) {
                    for (int i = 1; i < msgs.size(); ++i) {
                        Message m = msgs.get(i);
                        this.span.addEvent(TracingAttributeKey.ERROR.getAttributeKey().getKey(), Attributes.of(TracingAttributeKey.ERROR_TYPE.getAttributeKey(), (Object)m.getId(), TracingAttributeKey.ERROR_MESSAGE.getAttributeKey(), (Object)m.getDefaultMessage()));
                    }
                }
            } else {
                this.setStatusError(errorValue.getName(), null);
            }
        }
        return this;
    }

    private TracingSpan recordException(Throwable ex) {
        if (ex != null && this.tracingLevel == TracingLevel.TRACE) {
            this.span.recordException(ex);
        }
        return this;
    }

    @Override
    public TracingSpan addEvent(String name) {
        if (this.isTracingLevelAtLeast(TracingLevel.DEBUG)) {
            this.span.addEvent(name, Attributes.empty());
        }
        return this;
    }

    @Override
    public <T> TracingSpan addEvent(String name, TracingAttributeKey<T> key, T value) {
        if (this.isTracingLevelAtLeast(TracingLevel.DEBUG)) {
            Attributes attrs = key != null ? Attributes.of(key.getAttributeKey(), value) : Attributes.empty();
            this.span.addEvent(name, attrs);
        }
        return this;
    }

    @Override
    public void end() {
        logger.trace("span ended");
        if (this.span.isRecording()) {
            this.span.end();
        }
    }

    @Override
    public <C> TracingSpan injectInto(C carrier, TracingSpan.KeyValueSetter<C> setter) {
        try (Scope scope = this.span.makeCurrent();){
            this.otel.getPropagators().getTextMapPropagator().inject(Context.current(), carrier, (c, key, value) -> setter.set(c, key, value));
        }
        return this;
    }

    private boolean isTracingLevelAtLeast(TracingLevel level) {
        return this.tracingLevel.ordinal() >= level.ordinal();
    }

    @Override
    public TracingSpan updateName(String newName) {
        newName = this.truncateLeft(newName);
        this.span.updateName(newName);
        return this;
    }

    private String truncateLeft(String name) {
        if (name != null && name.length() > 255) {
            return name.substring(name.length() - 255, name.length());
        }
        return name;
    }

    Span getDecoratedSpan() {
        return this.span;
    }
}

