/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util;

import com.vmware.vapi.internal.util.StringUtils;
import com.vmware.vapi.internal.util.Validate;

public class PropertyUtil {
    private PropertyUtil() {
    }

    public static String getProperty(String propertyName, String defaultValue) {
        Validate.notEmpty(propertyName);
        String value = System.getProperty(propertyName);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        value = System.getenv(propertyName);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        String sValue = PropertyUtil.getProperty(propertyName, null);
        if (sValue != null) {
            return Boolean.parseBoolean(sValue);
        }
        return defaultValue;
    }
}

