/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.util;

import com.vmware.vapi.internal.protocol.client.rpc.http.ApacheHttpUtil;
import com.vmware.vapi.internal.tracing.TracingSpan;
import com.vmware.vapi.internal.tracing.otel.TracingAttributeKey;
import com.vmware.vapi.protocol.HttpConfiguration;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingUtil {
    private static Logger _logger = LoggerFactory.getLogger(TracingUtil.class);

    private TracingUtil() {
    }

    public static void registerRequestDataIntoSpan(TracingSpan span, HttpUriRequest request, HttpConfiguration.Protocol protocol, TracingAttributeKey.IoType ioType) {
        span.setAttribute(TracingAttributeKey.VAPI_PROTOCOL, TracingUtil.protocolName(protocol)).setAttribute(TracingAttributeKey.HTTP_URL, request.getURI().toASCIIString()).setAttribute(TracingAttributeKey.HTTP_METHOD, request.getMethod()).setAttribute(TracingAttributeKey.IO, ioType.name()).addEvent("vAPI client >> peer", TracingAttributeKey.THREAD_NAME, Thread.currentThread().getName());
    }

    public static void registerResponseIntoSpan(TracingSpan span, HttpResponse response, HttpContext ctx) {
        span.addEvent("vAPI client << peer", TracingAttributeKey.THREAD_NAME, Thread.currentThread().getName()).setAttribute(TracingAttributeKey.HTTP_STATUS_CODE, Long.valueOf(response.getStatusLine().getStatusCode()));
        String contentType = ApacheHttpUtil.getContentType(response);
        if (contentType != null) {
            span.setAttribute(TracingAttributeKey.HTTP_CONTENT_TYPE, contentType);
        }
        int localPort = -2;
        try {
            if (ctx instanceof HttpCoreContext) {
                HttpInetConnection connection = (HttpInetConnection)((HttpCoreContext)ctx).getConnection(HttpInetConnection.class);
                if (connection != null) {
                    localPort = connection.getLocalPort();
                }
            } else if (ctx instanceof ManagedHttpClientConnection) {
                localPort = ((ManagedHttpClientConnection)ctx).getSocket().getLocalPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (localPort != -2) {
            span.setAttribute(TracingAttributeKey.NET_HOST_PORT, Long.valueOf(localPort));
        } else {
            _logger.trace("Unable to extract local port from HTTP client");
        }
    }

    public static void addHeader(HttpUriRequest request, String name, String value) {
        if (request != null && name != null) {
            request.addHeader(name, value);
        }
    }

    private static String protocolName(HttpConfiguration.Protocol protocol) {
        switch (protocol.name()) {
            case "VAPI_JSON_RPC_1_0": 
            case "VAPI_JSON_RPC_1_1": {
                return "jsonrpc";
            }
        }
        return "";
    }
}

