/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.protocol.server.msg.json;

import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.internal.protocol.common.json.JsonApiRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonApiResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonBaseResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonContextBuilderRequestParams;
import com.vmware.vapi.internal.protocol.common.json.JsonDeserializer;
import com.vmware.vapi.internal.protocol.common.json.JsonError;
import com.vmware.vapi.internal.protocol.common.json.JsonErrorResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidContext;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidDataValueException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidMethodException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidMethodParamsException;
import com.vmware.vapi.internal.protocol.common.json.JsonInvalidRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeParams;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgDeserializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgSerializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonProgressResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonSerializer;
import com.vmware.vapi.internal.tracing.TracingSpan;
import com.vmware.vapi.internal.tracing.otel.TracingAttributeKey;
import com.vmware.vapi.internal.util.Validate;
import com.vmware.vapi.internal.util.io.IoUtil;
import com.vmware.vapi.protocol.Constants;
import com.vmware.vapi.protocol.RequestProcessor;
import com.vmware.vapi.protocol.server.rpc.RequestReceiver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonServerConnection
implements RequestReceiver {
    private static final String APP_DATA_HEADER_PREFIX = "vapi-ctx-";
    static final String[] APP_DATA_SPECIAL_KEYS = new String[]{"opId", "actId", "$showUnreleasedAPIs", "$userAgent", "$doNotRoute", "vmwareSessionId", "ActivationId"};
    static final String[] APP_DATA_SPECIAL_KEYS_LOWER = new String[APP_DATA_SPECIAL_KEYS.length];
    private static Logger logger;
    private final ApiProvider provider;
    private final JsonSerializer jsonSerializer2;
    private final JsonDeserializer jsonDeserializer2;
    private final List<RequestProcessor> processorChain;
    private static final int INVALID_PARAMS_CODE = -32602;
    private static final int INVALID_REQUEST_CODE = -32600;
    private static final int INVALID_CONTEXT_CODE = -31001;
    private static final int METHOD_NOT_FOUND_CODE = -32601;
    private static final int INTERNAL_JSONRPC_ERROR_CODE = -32603;
    private static final String INVALID_PARAMS_MSG = "Invalid params";
    private static final String INVALID_REQUEST_MSG = "Invalid Request";
    private static final String INVALID_CONTEXT_MSG = "Invalid context";
    private static final String METHOD_NOT_FOUND_MSG = "Method not found";
    private static final String INTERNAL_JSONRPC_ERROR_MSG = "Internal error";
    private static final String UTF8_CHARSET = "UTF-8";

    public JsonServerConnection(ApiProvider provider, List<RequestProcessor> processorChain) {
        Validate.notNull(provider);
        Validate.notNull(processorChain);
        this.provider = provider;
        this.jsonDeserializer2 = new JsonMsgDeserializer2();
        this.jsonSerializer2 = new JsonMsgSerializer2();
        this.processorChain = Collections.unmodifiableList(processorChain);
    }

    @Override
    public void requestReceived(InputStream request, RequestReceiver.TransportContext transport) throws IOException {
        Validate.notNull(request);
        Validate.notNull(transport);
        this.processRequest(request, transport);
    }

    private void processRequest(InputStream request, RequestReceiver.TransportContext transport) throws IOException, UnsupportedEncodingException {
        byte[] buffer = IoUtil.readAll(request);
        if (buffer.length == 0) {
            logger.error("Empty request");
            JsonErrorResponse response = this.createErrorResponse(null, -32600, INVALID_REQUEST_MSG, "Empty request");
            this.sendResponse(response, transport, true);
            return;
        }
        logger.debug("Received request of size: {}", (Object)buffer.length);
        String jsonRpcRequest = new String(buffer, UTF8_CHARSET);
        if (logger.isDebugEnabled() && Constants.shouldLogRawRequestResponse()) {
            logger.debug("JSON request: {}", (Object)jsonRpcRequest);
        }
        JsonApiRequest jsonRpcRequestObj = null;
        JsonErrorResponse errorResponse = null;
        String id = null;
        HashMap<String, Object> procMetaData = new HashMap<String, Object>();
        try {
            logger.debug("Deserializing JSON request");
            jsonRpcRequestObj = this.jsonDeserializer2.requestDeserialize(jsonRpcRequest);
            JsonContextBuilderRequestParams params = (JsonContextBuilderRequestParams)jsonRpcRequestObj.getParams();
            RequestReceiver.RequestContext context = transport.getRequestContext();
            JsonServerConnection.verifyContext(context, params);
            JsonServerConnection.processRequestContext(context, params);
            JsonServerConnection.processContextApplicationData(context.getAllProperties(), params.getCtxBuilder().applicationData);
            JsonServerConnection.fixApplicationDataKeyCasing(params.getCtxBuilder().applicationData);
            JsonServerConnection.processContextSession(context.getSession(), params.getCtxBuilder().security);
            for (RequestProcessor proc : this.processorChain) {
                logger.debug("Execution request pre-processor {}", (Object)proc.toString());
                buffer = proc.process(buffer, procMetaData, params);
            }
        }
        catch (JsonInvalidMethodParamsException e) {
            logger.debug("Invalid parameters: {}", (Object)e.getMessage(), (Object)e);
            errorResponse = this.createErrorResponse(e.getId(), -32602, INVALID_PARAMS_MSG, e.getMessage());
        }
        catch (JsonInvalidContext e) {
            logger.debug("Invalid JSON context: {}", (Object)e.getMessage(), (Object)e);
            errorResponse = this.createErrorResponse(null, -31001, INVALID_CONTEXT_MSG, e.getMessage());
        }
        catch (JsonInvalidRequest e) {
            logger.debug("Invalid JSON request: {}", (Object)e.getMsg(), (Object)e);
            errorResponse = this.createErrorResponse(null, -32600, INVALID_REQUEST_MSG, e.getMsg());
        }
        catch (JsonInvalidDataValueException e) {
            logger.debug("Invalid DataValue JSON detected in request: {}", (Object)e.getMessage(), (Object)e);
            errorResponse = this.createErrorResponse(null, -32600, INVALID_REQUEST_MSG, e.getMessage());
        }
        catch (JsonInvalidMethodException e) {
            logger.debug("Method not found: {}", (Object)e.getMsg(), (Object)e);
            errorResponse = this.createErrorResponse(e.getId(), -32601, METHOD_NOT_FOUND_MSG, e.getMsg());
        }
        catch (Exception e) {
            logger.debug("JSON-RPC error", (Throwable)e);
            errorResponse = this.createErrorResponse(null, -32603, INTERNAL_JSONRPC_ERROR_MSG, e.getMessage());
        }
        catch (Throwable t) {
            logger.error("Severe internal error", t);
            errorResponse = this.createErrorResponse(null, -32603, INTERNAL_JSONRPC_ERROR_MSG, t.getMessage());
        }
        if (errorResponse != null) {
            logger.error("Stop processing invalid JSON request: {}", (Object)jsonRpcRequest);
            this.sendResponse(errorResponse, transport, true);
        } else {
            id = jsonRpcRequestObj.getId();
            logger.debug("Processing JSON request with id {} for method {}", (Object)jsonRpcRequestObj.getId(), (Object)jsonRpcRequestObj.getMethod());
            this.processApiRequest(jsonRpcRequestObj, id, procMetaData, transport);
        }
    }

    static void verifyContext(RequestReceiver.RequestContext requestContext, RequestProcessor.Request request) throws JsonInvalidContext {
        String serviceId = requestContext.getServiceId();
        String operationId = requestContext.getOperationId();
        if (serviceId == null) {
            if (operationId == null) {
                return;
            }
            throw new JsonInvalidContext("Missing vapi-service HTTP header");
        }
        if (operationId == null) {
            throw new JsonInvalidContext("Missing vapi-operation HTTP header");
        }
        if (!serviceId.equals(request.getServiceId())) {
            throw new JsonInvalidContext("Mismatching service identifier in HTTP header and payload");
        }
        if (!operationId.equals(request.getOperationId())) {
            throw new JsonInvalidContext("Mismatching operation identifier in HTTP header and payload");
        }
    }

    static void processRequestContext(RequestReceiver.RequestContext context, JsonContextBuilderRequestParams params) {
        JsonServerConnection.updateTracingSpan(context, params);
    }

    static void updateTracingSpan(RequestReceiver.RequestContext context, JsonContextBuilderRequestParams params) {
        String spanName = params.getServiceId() + "." + params.getOperationId();
        context.getTracingSpan().updateName(spanName);
        context.getTracingSpan().setAttribute(TracingAttributeKey.VAPI_PROTOCOL, "jsonrpc");
    }

    static void processContextApplicationData(Map<String, String> properties, Map<String, String> applicationData) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String headerName = entry.getKey();
            if (!headerName.regionMatches(true, 0, APP_DATA_HEADER_PREFIX, 0, APP_DATA_HEADER_PREFIX.length())) continue;
            String appDataKey = headerName.substring(APP_DATA_HEADER_PREFIX.length()).toLowerCase(Locale.ENGLISH);
            applicationData.put(appDataKey, entry.getValue());
        }
    }

    static void processContextSession(String session, Map<String, Object> security) {
        if (session == null) {
            return;
        }
        security.clear();
        security.put("authn_scheme_id", "com.vmware.vapi.std.security.session_id");
        security.put("sessionId", session);
    }

    static void fixApplicationDataKeyCasing(Map<String, String> applicationData) {
        for (int i = 0; i < APP_DATA_SPECIAL_KEYS.length; ++i) {
            String lowerCaseKey = APP_DATA_SPECIAL_KEYS_LOWER[i];
            if (!applicationData.containsKey(lowerCaseKey)) continue;
            applicationData.put(APP_DATA_SPECIAL_KEYS[i], applicationData.remove(lowerCaseKey));
        }
    }

    private void sendResponse(JsonBaseResponse response, RequestReceiver.TransportContext transport, boolean isFinal) {
        if (response.isError()) {
            TracingSpan span = transport.getRequestContext().getTracingSpan();
            span.setStatusError("json.rpc.error", null);
            span.end();
        }
        byte[] jsonResponse = null;
        try {
            jsonResponse = this.jsonSerializer2.serialize(response);
        }
        catch (RuntimeException t) {
            logger.warn("Failed to serialize JSON response", (Throwable)t);
            return;
        }
        JsonServerConnection.dumpResponse(jsonResponse);
        this.sendResponse(jsonResponse, transport, isFinal);
    }

    private static void dumpResponse(byte[] jsonResponse) {
        if (logger.isDebugEnabled() && Constants.shouldLogRawRequestResponse()) {
            try {
                String strJsonResponse = new String(jsonResponse, UTF8_CHARSET);
                logger.debug("JSON response: {}", (Object)strJsonResponse);
            }
            catch (UnsupportedEncodingException ex) {
                logger.error("JSON response is not valid UTF-8", (Throwable)ex);
            }
        }
    }

    private void processApiRequest(JsonApiRequest jsonApiRequest, final String id, Map<String, Object> procMetaData, RequestReceiver.TransportContext transport) {
        JsonInvokeParams invokeParams = jsonApiRequest.getParams();
        JsonContextBuilderRequestParams requestParamsBuilder = (JsonContextBuilderRequestParams)invokeParams;
        JsonContextBuilderRequestParams.ExecutionContextBuilder ctxBuilder = requestParamsBuilder.getCtxBuilder();
        JsonServerConnection.updateSecurityContext(procMetaData, ctxBuilder.security);
        JsonServerConnection.addUserAgent(transport.getRequestContext(), ctxBuilder.applicationData);
        JsonServerConnection.addLocalizationSettings(transport.getRequestContext(), ctxBuilder.applicationData);
        ExecutionContext ctx = ctxBuilder.build();
        AsyncHandleImpl<MethodResult> cb = new AsyncHandleImpl<MethodResult>(transport, id, true){

            @Override
            protected JsonBaseResponse toJson(MethodResult result) {
                TracingSpan span = this.transport.getRequestContext().getTracingSpan();
                if (!result.success()) {
                    this.transport.setHeader("vapi-error", result.getError().getName());
                    span.setStatusError(result.getError());
                } else {
                    span.setStatusOk();
                }
                span.end();
                return new JsonApiResponse(id, result);
            }
        };
        this.provider.invoke(requestParamsBuilder.getServiceId(), requestParamsBuilder.getOperationId(), requestParamsBuilder.getInput(), ctx, (AsyncHandle<MethodResult>)cb);
    }

    private static void addUserAgent(RequestReceiver.RequestContext reqCtx, Map<String, String> applicationData) {
        if (reqCtx.getUserAgent() != null) {
            applicationData.put("$userAgent", reqCtx.getUserAgent());
        }
    }

    private static void addLocalizationSettings(RequestReceiver.RequestContext reqCtx, Map<String, String> applicationData) {
        if (reqCtx.getAcceptLanguage() != null) {
            applicationData.put("accept-language", reqCtx.getAcceptLanguage());
        }
    }

    private static void updateSecurityContext(Map<String, Object> procMetaData, Map<String, Object> security) {
        assert (procMetaData != null);
        Object procSecCtx = procMetaData.get("security_processor_metadata");
        if (procSecCtx != null && procSecCtx instanceof Map) {
            security.put("security_processor_metadata", procSecCtx);
        } else if (security.get("security_processor_metadata") != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Removed {security_processor_metadata," + security.get("security_processor_metadata") + "} key/value pair from the security context");
            }
            security.remove("security_processor_metadata");
        }
    }

    private void sendResponse(byte[] resp, RequestReceiver.TransportContext transport, boolean isFinal) {
        int respSize = resp.length;
        try {
            logger.debug("Sending JSON response of size {}", (Object)respSize);
            transport.send(new ByteArrayInputStream(resp), resp.length, isFinal);
        }
        catch (IOException e) {
            logger.error("Unable to send JSON response", (Throwable)e);
        }
    }

    private JsonErrorResponse createErrorResponse(String id, int code, String message, String data) {
        JsonError jsonError = new JsonError(code, message, data);
        return new JsonErrorResponse(id, jsonError);
    }

    static {
        for (int i = 0; i < APP_DATA_SPECIAL_KEYS.length; ++i) {
            JsonServerConnection.APP_DATA_SPECIAL_KEYS_LOWER[i] = APP_DATA_SPECIAL_KEYS[i].toLowerCase(Locale.ENGLISH);
        }
        logger = LoggerFactory.getLogger(JsonServerConnection.class);
    }

    private abstract class AsyncHandleImpl<T>
    extends AsyncHandle<T> {
        protected final RequestReceiver.TransportContext transport;
        private final String id;
        private final boolean sendProgressUpdates;

        AsyncHandleImpl(RequestReceiver.TransportContext transport, String id, boolean sendProgressUpdates) {
            Validate.notNull(transport);
            Validate.notNull(id);
            this.transport = transport;
            this.id = id;
            this.sendProgressUpdates = sendProgressUpdates;
        }

        @Override
        public void updateProgress(DataValue progress) {
            if (this.sendProgressUpdates) {
                JsonServerConnection.this.sendResponse(new JsonProgressResponse(this.id, progress), this.transport, false);
            } else {
                logger.debug("Skipping progress update for request with id {}", (Object)this.id);
            }
        }

        @Override
        public void setResult(T result) {
            JsonBaseResponse jsonObj;
            try {
                jsonObj = this.toJson(result);
            }
            catch (RuntimeException ex) {
                logger.error("Result for request with id {} could not be converted to JSON", (Object)this.id, (Object)ex);
                jsonObj = JsonServerConnection.this.createErrorResponse(null, -32603, JsonServerConnection.INTERNAL_JSONRPC_ERROR_MSG, ex.getMessage());
            }
            JsonServerConnection.this.sendResponse(jsonObj, this.transport, true);
        }

        @Override
        public void setError(RuntimeException error) {
            logger.error("Provider returned error for request with id {}", (Object)this.id, (Object)error);
            JsonErrorResponse jsonObj = JsonServerConnection.this.createErrorResponse(null, -32603, JsonServerConnection.INTERNAL_JSONRPC_ERROR_MSG, error.getMessage());
            TracingSpan span = this.transport.getRequestContext().getTracingSpan();
            span.setStatusError(error);
            span.end();
            JsonServerConnection.this.sendResponse(jsonObj, this.transport, true);
        }

        protected abstract JsonBaseResponse toJson(T var1);
    }
}

