/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.aaa.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.aaa;

public interface LdapIdentitySources extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.aaa.LdapIdentitySourcesTypes {

    /**
     * Delete an LDAP identity source. Users defined in that source will no longer be
     * able to access NSX.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ldapIdentitySourceId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String ldapIdentitySourceId);

    /**
     * Delete an LDAP identity source. Users defined in that source will no longer be
     * able to access NSX.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ldapIdentitySourceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete an LDAP identity source. Users defined in that source will no longer be
     * able to access NSX.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete an LDAP identity source. Users defined in that source will no longer be
     * able to access NSX.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Attempt to connect to an LDAP server and retrieve the server certificate it
     * presents.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param identitySourceLdapServerEndpoint (required)
     * @return com.vmware.nsx_global_policy.model.PeerCertificateChain
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.PeerCertificateChain fetchcertificate(com.vmware.nsx_global_policy.model.IdentitySourceLdapServerEndpoint identitySourceLdapServerEndpoint);

    /**
     * Attempt to connect to an LDAP server and retrieve the server certificate it
     * presents.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param identitySourceLdapServerEndpoint (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.PeerCertificateChain
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.PeerCertificateChain fetchcertificate(com.vmware.nsx_global_policy.model.IdentitySourceLdapServerEndpoint identitySourceLdapServerEndpoint, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Attempt to connect to an LDAP server and retrieve the server certificate it
     * presents.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PeerCertificateChain
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identitySourceLdapServerEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void fetchcertificate(com.vmware.nsx_global_policy.model.IdentitySourceLdapServerEndpoint identitySourceLdapServerEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PeerCertificateChain> asyncCallback);

    /**
     * Attempt to connect to an LDAP server and retrieve the server certificate it
     * presents.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.PeerCertificateChain
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identitySourceLdapServerEndpoint (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void fetchcertificate(com.vmware.nsx_global_policy.model.IdentitySourceLdapServerEndpoint identitySourceLdapServerEndpoint, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.PeerCertificateChain> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return details about one LDAP identity source
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ldapIdentitySourceId (required)
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySource
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure get(java.lang.String ldapIdentitySourceId);

    /**
     * Return details about one LDAP identity source
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ldapIdentitySourceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySource
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure get(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return details about one LDAP identity source
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySource
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Return details about one LDAP identity source
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySource
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return a list of all configured LDAP identity sources.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySourceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.LdapIdentitySourceListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Return a list of all configured LDAP identity sources.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySourceListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.LdapIdentitySourceListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return a list of all configured LDAP identity sources.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySourceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.LdapIdentitySourceListResult> asyncCallback);

    /**
     * Return a list of all configured LDAP identity sources.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySourceListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.LdapIdentitySourceListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Attempt to connect to an existing LDAP identity source and report any errors
     * encountered.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ldapIdentitySourceId (required)
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults probe(java.lang.String ldapIdentitySourceId);

    /**
     * Attempt to connect to an existing LDAP identity source and report any errors
     * encountered.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ldapIdentitySourceId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults probe(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Attempt to connect to an existing LDAP identity source and report any errors
     * encountered.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void probe(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults> asyncCallback);

    /**
     * Attempt to connect to an existing LDAP identity source and report any errors
     * encountered.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void probe(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Verify that the configuration of an LDAP identity source is correct before
     * actually creating the source.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ldapIdentitySource (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults probeidentitysource(com.vmware.vapi.bindings.Structure ldapIdentitySource);

    /**
     * Verify that the configuration of an LDAP identity source is correct before
     * actually creating the source.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ldapIdentitySource (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults probeidentitysource(com.vmware.vapi.bindings.Structure ldapIdentitySource, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Verify that the configuration of an LDAP identity source is correct before
     * actually creating the source.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySource (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void probeidentitysource(com.vmware.vapi.bindings.Structure ldapIdentitySource, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults> asyncCallback);

    /**
     * Verify that the configuration of an LDAP identity source is correct before
     * actually creating the source.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySource (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void probeidentitysource(com.vmware.vapi.bindings.Structure ldapIdentitySource, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.LdapIdentitySourceProbeResults> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Attempt to connect to an LDAP server and ensure that the server can be contacted
     * using the given URL and authentication credentials.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param identitySourceLdapServer (required)
     * @return com.vmware.nsx_global_policy.model.IdentitySourceLdapServerProbeResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.IdentitySourceLdapServerProbeResult probeldapserver(com.vmware.nsx_global_policy.model.IdentitySourceLdapServer identitySourceLdapServer);

    /**
     * Attempt to connect to an LDAP server and ensure that the server can be contacted
     * using the given URL and authentication credentials.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param identitySourceLdapServer (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.IdentitySourceLdapServerProbeResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.IdentitySourceLdapServerProbeResult probeldapserver(com.vmware.nsx_global_policy.model.IdentitySourceLdapServer identitySourceLdapServer, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Attempt to connect to an LDAP server and ensure that the server can be contacted
     * using the given URL and authentication credentials.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.IdentitySourceLdapServerProbeResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identitySourceLdapServer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void probeldapserver(com.vmware.nsx_global_policy.model.IdentitySourceLdapServer identitySourceLdapServer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.IdentitySourceLdapServerProbeResult> asyncCallback);

    /**
     * Attempt to connect to an LDAP server and ensure that the server can be contacted
     * using the given URL and authentication credentials.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.IdentitySourceLdapServerProbeResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param identitySourceLdapServer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void probeldapserver(com.vmware.nsx_global_policy.model.IdentitySourceLdapServer identitySourceLdapServer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.IdentitySourceLdapServerProbeResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create a new LDAP identity source or update the configuration of an existing
     * LDAP identity source. You may wish to verify the new configuration using the
     * POST /aaa/ldap-identity-sources?action=probe API before creating or changing the
     * configuration. Note that if you are using LDAP on an active and standby NSX-T
     * Global Manager in a federated environment, you must use the same name for your
     * LDAP identity sources on the active and standby Global Managers.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ldapIdentitySourceId (required)
     * @param ldapIdentitySource (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySource
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.Structure ldapIdentitySource);

    /**
     * Create a new LDAP identity source or update the configuration of an existing
     * LDAP identity source. You may wish to verify the new configuration using the
     * POST /aaa/ldap-identity-sources?action=probe API before creating or changing the
     * configuration. Note that if you are using LDAP on an active and standby NSX-T
     * Global Manager in a federated environment, you must use the same name for your
     * LDAP identity sources on the active and standby Global Managers.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ldapIdentitySourceId (required)
     * @param ldapIdentitySource (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.LdapIdentitySource
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.vapi.bindings.Structure update(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.Structure ldapIdentitySource, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create a new LDAP identity source or update the configuration of an existing
     * LDAP identity source. You may wish to verify the new configuration using the
     * POST /aaa/ldap-identity-sources?action=probe API before creating or changing the
     * configuration. Note that if you are using LDAP on an active and standby NSX-T
     * Global Manager in a federated environment, you must use the same name for your
     * LDAP identity sources on the active and standby Global Managers.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySource
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param ldapIdentitySource (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.Structure ldapIdentitySource, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Create a new LDAP identity source or update the configuration of an existing
     * LDAP identity source. You may wish to verify the new configuration using the
     * POST /aaa/ldap-identity-sources?action=probe API before creating or changing the
     * configuration. Note that if you are using LDAP on an active and standby NSX-T
     * Global Manager in a federated environment, you must use the same name for your
     * LDAP identity sources on the active and standby Global Managers.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.LdapIdentitySource
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ldapIdentitySourceId (required)
     * @param ldapIdentitySource (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx_global_policy.model.LdapIdentitySource}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String ldapIdentitySourceId, com.vmware.vapi.bindings.Structure ldapIdentitySource, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
