/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.global_infra.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.global_infra;

public interface Certificates extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.global_infra.CertificatesTypes {

    /**
     * Removes the specified certificate. The private key associated with the
     * certificate is also deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param certificateId ID of certificate to delete (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String certificateId);

    /**
     * Removes the specified certificate. The private key associated with the
     * certificate is also deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param certificateId ID of certificate to delete (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String certificateId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Removes the specified certificate. The private key associated with the
     * certificate is also deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param certificateId ID of certificate to delete (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String certificateId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Removes the specified certificate. The private key associated with the
     * certificate is also deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param certificateId ID of certificate to delete (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String certificateId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information for the specified certificate ID, including the
     * certificate's id; pem_encoded data; and history of the certificate (who created
     * or modified it and when). For additional information, include the ?details=true
     * modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param certificateId ID of certificate to read (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @return com.vmware.nsx_global_policy.model.TlsCertificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.TlsCertificate get(java.lang.String certificateId, java.lang.Boolean details);

    /**
     * Returns information for the specified certificate ID, including the
     * certificate's id; pem_encoded data; and history of the certificate (who created
     * or modified it and when). For additional information, include the ?details=true
     * modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param certificateId ID of certificate to read (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.TlsCertificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.TlsCertificate get(java.lang.String certificateId, java.lang.Boolean details, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information for the specified certificate ID, including the
     * certificate's id; pem_encoded data; and history of the certificate (who created
     * or modified it and when). For additional information, include the ?details=true
     * modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.TlsCertificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param certificateId ID of certificate to read (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String certificateId, java.lang.Boolean details, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.TlsCertificate> asyncCallback);

    /**
     * Returns information for the specified certificate ID, including the
     * certificate's id; pem_encoded data; and history of the certificate (who created
     * or modified it and when). For additional information, include the ?details=true
     * modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.TlsCertificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param certificateId ID of certificate to read (required)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String certificateId, java.lang.Boolean details, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.TlsCertificate> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns all certificate information viewable by the user, including each
     * certificate's id; pem_encoded data; and history of the certificate (who created
     * or modified it and when). For additional information, include the ?details=true
     * modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @return com.vmware.nsx_global_policy.model.TlsCertificateList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.TlsCertificateList list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type);

    /**
     * Returns all certificate information viewable by the user, including each
     * certificate's id; pem_encoded data; and history of the certificate (who created
     * or modified it and when). For additional information, include the ?details=true
     * modifier at the end of the request URI.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.TlsCertificateList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.TlsCertificateList list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns all certificate information viewable by the user, including each
     * certificate's id; pem_encoded data; and history of the certificate (who created
     * or modified it and when). For additional information, include the ?details=true
     * modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.TlsCertificateList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.TlsCertificateList> asyncCallback);

    /**
     * Returns all certificate information viewable by the user, including each
     * certificate's id; pem_encoded data; and history of the certificate (who created
     * or modified it and when). For additional information, include the ?details=true
     * modifier at the end of the request URI.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.TlsCertificateList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param details whether to expand the pem data and show all its details (optional, default to
     * false)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Node ID of certificate to return (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param type Type of certificate to return (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.Boolean details, java.lang.String includedFields, java.lang.String nodeId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String type, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.TlsCertificateList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Adds a new private-public certificate and, optionally, a private key that can be
     * applied to one of the user-facing components (appliance management or edge). The
     * certificate and the key should be stored in PEM format. If no private key is
     * provided, the certificate is used as a client certificate in the trust store. A
     * private key can be uploaded for a CA certificate only if the \"purpose\"
     * parameter is set to \"signing-ca\". A certificate chain will not be expanded
     * into separate certificate instances for reference, but would be pushed to the
     * enforcement point as a single certificate. This patch method does not modify an
     * existing certificate.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param certificateId (required)
     * @param tlsTrustData (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String certificateId, com.vmware.nsx_global_policy.model.TlsTrustData tlsTrustData);

    /**
     * Adds a new private-public certificate and, optionally, a private key that can be
     * applied to one of the user-facing components (appliance management or edge). The
     * certificate and the key should be stored in PEM format. If no private key is
     * provided, the certificate is used as a client certificate in the trust store. A
     * private key can be uploaded for a CA certificate only if the \"purpose\"
     * parameter is set to \"signing-ca\". A certificate chain will not be expanded
     * into separate certificate instances for reference, but would be pushed to the
     * enforcement point as a single certificate. This patch method does not modify an
     * existing certificate.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param certificateId (required)
     * @param tlsTrustData (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void patch(java.lang.String certificateId, com.vmware.nsx_global_policy.model.TlsTrustData tlsTrustData, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a new private-public certificate and, optionally, a private key that can be
     * applied to one of the user-facing components (appliance management or edge). The
     * certificate and the key should be stored in PEM format. If no private key is
     * provided, the certificate is used as a client certificate in the trust store. A
     * private key can be uploaded for a CA certificate only if the \"purpose\"
     * parameter is set to \"signing-ca\". A certificate chain will not be expanded
     * into separate certificate instances for reference, but would be pushed to the
     * enforcement point as a single certificate. This patch method does not modify an
     * existing certificate.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param certificateId (required)
     * @param tlsTrustData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void patch(java.lang.String certificateId, com.vmware.nsx_global_policy.model.TlsTrustData tlsTrustData, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Adds a new private-public certificate and, optionally, a private key that can be
     * applied to one of the user-facing components (appliance management or edge). The
     * certificate and the key should be stored in PEM format. If no private key is
     * provided, the certificate is used as a client certificate in the trust store. A
     * private key can be uploaded for a CA certificate only if the \"purpose\"
     * parameter is set to \"signing-ca\". A certificate chain will not be expanded
     * into separate certificate instances for reference, but would be pushed to the
     * enforcement point as a single certificate. This patch method does not modify an
     * existing certificate.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param certificateId (required)
     * @param tlsTrustData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void patch(java.lang.String certificateId, com.vmware.nsx_global_policy.model.TlsTrustData tlsTrustData, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Adds a new private-public certificate and, optionally, a private key that can be
     * applied to one of the user-facing components (appliance management or edge). The
     * certificate and the key should be stored in PEM format. If no private key is
     * provided, the certificate is used as a client certificate in the trust store. A
     * private key can be uploaded for a CA certificate only if the \"purpose\"
     * parameter is set to \"signing-ca\". A certificate chain will not be expanded
     * into separate certificate instances for reference, but would be pushed to the
     * enforcement point as a single certificate. This PUT method does not modify an
     * existing certificate.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param certificateId (required)
     * @param tlsTrustData (required)
     * @return com.vmware.nsx_global_policy.model.TlsCertificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.TlsCertificate update(java.lang.String certificateId, com.vmware.nsx_global_policy.model.TlsTrustData tlsTrustData);

    /**
     * Adds a new private-public certificate and, optionally, a private key that can be
     * applied to one of the user-facing components (appliance management or edge). The
     * certificate and the key should be stored in PEM format. If no private key is
     * provided, the certificate is used as a client certificate in the trust store. A
     * private key can be uploaded for a CA certificate only if the \"purpose\"
     * parameter is set to \"signing-ca\". A certificate chain will not be expanded
     * into separate certificate instances for reference, but would be pushed to the
     * enforcement point as a single certificate. This PUT method does not modify an
     * existing certificate.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param certificateId (required)
     * @param tlsTrustData (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.TlsCertificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.TlsCertificate update(java.lang.String certificateId, com.vmware.nsx_global_policy.model.TlsTrustData tlsTrustData, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a new private-public certificate and, optionally, a private key that can be
     * applied to one of the user-facing components (appliance management or edge). The
     * certificate and the key should be stored in PEM format. If no private key is
     * provided, the certificate is used as a client certificate in the trust store. A
     * private key can be uploaded for a CA certificate only if the \"purpose\"
     * parameter is set to \"signing-ca\". A certificate chain will not be expanded
     * into separate certificate instances for reference, but would be pushed to the
     * enforcement point as a single certificate. This PUT method does not modify an
     * existing certificate.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.TlsCertificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param certificateId (required)
     * @param tlsTrustData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String certificateId, com.vmware.nsx_global_policy.model.TlsTrustData tlsTrustData, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.TlsCertificate> asyncCallback);

    /**
     * Adds a new private-public certificate and, optionally, a private key that can be
     * applied to one of the user-facing components (appliance management or edge). The
     * certificate and the key should be stored in PEM format. If no private key is
     * provided, the certificate is used as a client certificate in the trust store. A
     * private key can be uploaded for a CA certificate only if the \"purpose\"
     * parameter is set to \"signing-ca\". A certificate chain will not be expanded
     * into separate certificate instances for reference, but would be pushed to the
     * enforcement point as a single certificate. This PUT method does not modify an
     * existing certificate.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.TlsCertificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param certificateId (required)
     * @param tlsTrustData (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String certificateId, com.vmware.nsx_global_policy.model.TlsTrustData tlsTrustData, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.TlsCertificate> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
