/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx_global_policy.global_infra.sites.
 * Used by client-side stubs.
 */

package com.vmware.nsx_global_policy.global_infra.sites;

public interface ListenerCertificate extends com.vmware.vapi.bindings.Service, com.vmware.nsx_global_policy.global_infra.sites.ListenerCertificateTypes {

    /**
     * Connects to the given IP and port, and, if an SSL listener is present, returns
     * the certificate of the listener. Intent of this API is \"Do you trust this
     * certificate?\".
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param address Host name or IP address of TLS listener (required)
     * @param port TCP port number of the TLS listener (required)
     * @return com.vmware.nsx_global_policy.model.TlsListenerCertificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.TlsListenerCertificate get(java.lang.String address, long port);

    /**
     * Connects to the given IP and port, and, if an SSL listener is present, returns
     * the certificate of the listener. Intent of this API is \"Do you trust this
     * certificate?\".
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param address Host name or IP address of TLS listener (required)
     * @param port TCP port number of the TLS listener (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx_global_policy.model.TlsListenerCertificate
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx_global_policy.model.TlsListenerCertificate get(java.lang.String address, long port, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Connects to the given IP and port, and, if an SSL listener is present, returns
     * the certificate of the listener. Intent of this API is \"Do you trust this
     * certificate?\".
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.TlsListenerCertificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param address Host name or IP address of TLS listener (required)
     * @param port TCP port number of the TLS listener (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String address, long port, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.TlsListenerCertificate> asyncCallback);

    /**
     * Connects to the given IP and port, and, if an SSL listener is present, returns
     * the certificate of the listener. Intent of this API is \"Do you trust this
     * certificate?\".
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx_global_policy.model.TlsListenerCertificate
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param address Host name or IP address of TLS listener (required)
     * @param port TCP port number of the TLS listener (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String address, long port, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx_global_policy.model.TlsListenerCertificate> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
