/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Credential info to connect to a AVI type of enforcement point.
 */
public final class AviConnectionInfo implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Identifier denoting this class, when it is used in polymorphic context. 
     * <p>This
     * value should be assigned to the property which is used to discriminate the
     * actual type used in the polymorphic context.</p>
     */
    public static final java.lang.String _TYPE_IDENTIFIER = "AviConnectionInfo";

    public static final java.lang.String STATUS_ACTIVATE = "ACTIVATE";

    public static final java.lang.String STATUS_DEACTIVATE_PROVIDER = "DEACTIVATE_PROVIDER";

    public static final java.lang.String STATUS_DEACTIVATE_API = "DEACTIVATE_API";

    private java.lang.String certificate;

    private java.lang.String cloud;

    private java.lang.String expiresAt;

    private java.lang.Boolean isDefaultCert;

    private java.lang.String managedBy;

    private java.lang.String password;

    private java.lang.String status;

    private java.lang.String tenant;

    private java.lang.String thumbprint;

    private java.lang.String username;

    private java.lang.String version;

    private java.lang.String enforcementPointAddress;

    private final java.lang.String resourceType = "AviConnectionInfo";

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public AviConnectionInfo() {
    }

    protected AviConnectionInfo(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Certificate used when on-borading workflow created by LCM/VCF.
     *
     * @return The current value of the property.
     */
    public java.lang.String getCertificate() {
        return this.certificate;
    }

    /**
     * Certificate used when on-borading workflow created by LCM/VCF.
     *
     * @param certificate New value for the property.
     */
    public void setCertificate(java.lang.String certificate) {
        this.certificate = certificate;
    }

    /**
     * Clouds are containers for the environment that Avi Vantage is installed or
     * operating within. During initial setup of Vantage, a default cloud, named
     * Default-Cloud, is created. This is where the first Controller is deployed, into
     * Default-Cloud. Additional clouds may be added, containing SEs and virtual
     * services. This is a deprecated property. Cloud has been renamed to cloud_name
     * and it will added from specific ALB entity.
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getCloud() {
        return this.cloud;
    }

    /**
     * Clouds are containers for the environment that Avi Vantage is installed or
     * operating within. During initial setup of Vantage, a default cloud, named
     * Default-Cloud, is created. This is where the first Controller is deployed, into
     * Default-Cloud. Additional clouds may be added, containing SEs and virtual
     * services. This is a deprecated property. Cloud has been renamed to cloud_name
     * and it will added from specific ALB entity.
     *
     * @param cloud New value for the property.
     */
    @Deprecated
    public void setCloud(java.lang.String cloud) {
        this.cloud = cloud;
    }

    /**
     * Expiry time of the token will be set by LCM at the time of Enforcement Point
     * Creation.
     *
     * @return The current value of the property.
     */
    public java.lang.String getExpiresAt() {
        return this.expiresAt;
    }

    /**
     * Expiry time of the token will be set by LCM at the time of Enforcement Point
     * Creation.
     *
     * @param expiresAt New value for the property.
     */
    public void setExpiresAt(java.lang.String expiresAt) {
        this.expiresAt = expiresAt;
    }

    /**
     * Advanced Load Balancer controller using default portal certificate.
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getIsDefaultCert() {
        return this.isDefaultCert;
    }

    /**
     * Advanced Load Balancer controller using default portal certificate.
     *
     * @param isDefaultCert New value for the property.
     */
    public void setIsDefaultCert(java.lang.Boolean isDefaultCert) {
        this.isDefaultCert = isDefaultCert;
    }

    /**
     * Managed by used when on-borading workflow created by LCM/VCF.
     *
     * @return The current value of the property.
     */
    public java.lang.String getManagedBy() {
        return this.managedBy;
    }

    /**
     * Managed by used when on-borading workflow created by LCM/VCF.
     *
     * @param managedBy New value for the property.
     */
    public void setManagedBy(java.lang.String managedBy) {
        this.managedBy = managedBy;
    }

    /**
     * Password or Token for Avi Controller.
     *
     * @return The current value of the property.
     */
    public java.lang.String getPassword() {
        return this.password;
    }

    /**
     * Password or Token for Avi Controller.
     *
     * @param password New value for the property.
     */
    public void setPassword(java.lang.String password) {
        this.password = password;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_ACTIVATE}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_DEACTIVATE_PROVIDER}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_DEACTIVATE_API}</li>
     * </ul> This is connection property which checks whether ALB is connected to the
     * controller. Enum options - ACTIVATE, DEACTIVATE_PROVIDER, DEACTIVATE_API.
     * Default value is DEACTIVATE_API.
     *
     * @return The current value of the property.
     */
    public java.lang.String getStatus() {
        return this.status;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_ACTIVATE}</li> <li>
     * {@link
     * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_DEACTIVATE_PROVIDER}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_DEACTIVATE_API}</li>
     * </ul> This is connection property which checks whether ALB is connected to the
     * controller. Enum options - ACTIVATE, DEACTIVATE_PROVIDER, DEACTIVATE_API.
     * Default value is DEACTIVATE_API.
     *
     * @param status New value for the property.
     */
    public void setStatus(java.lang.String status) {
        this.status = status;
    }

    /**
     * A tenant is an isolated instance of Avi Controller. Each Avi user account is
     * associated with one or more tenants. The tenant associated with a user account
     * defines the resources that user can access within Avi Vantage. When a user logs
     * in, Avi restricts their access to only those resources that are in the same
     * tenant
     *
     * @return The current value of the property.
     */
    public java.lang.String getTenant() {
        return this.tenant;
    }

    /**
     * A tenant is an isolated instance of Avi Controller. Each Avi user account is
     * associated with one or more tenants. The tenant associated with a user account
     * defines the resources that user can access within Avi Vantage. When a user logs
     * in, Avi restricts their access to only those resources that are in the same
     * tenant
     *
     * @param tenant New value for the property.
     */
    public void setTenant(java.lang.String tenant) {
        this.tenant = tenant;
    }

    /**
     * Thumbprint of EnforcementPoint in the form of a SHA-256 hash represented in
     * lower case HEX.
     *
     * @return The current value of the property.
     */
    public java.lang.String getThumbprint() {
        return this.thumbprint;
    }

    /**
     * Thumbprint of EnforcementPoint in the form of a SHA-256 hash represented in
     * lower case HEX.
     *
     * @param thumbprint New value for the property.
     */
    public void setThumbprint(java.lang.String thumbprint) {
        this.thumbprint = thumbprint;
    }

    /**
     * Username.
     *
     * @return The current value of the property.
     */
    public java.lang.String getUsername() {
        return this.username;
    }

    /**
     * Username.
     *
     * @param username New value for the property.
     */
    public void setUsername(java.lang.String username) {
        this.username = username;
    }

    /**
     * Avi supports API versioning for backward compatibility with automation scripts
     * written for an object model older than the current one. Such scripts need not be
     * updated to keep up with object model changes This is a deprecated property. The
     * version is now auto populated from property file and its value can be read using
     * APIs
     *
     * @return The current value of the property.
     */
    @Deprecated
    public java.lang.String getVersion() {
        return this.version;
    }

    /**
     * Avi supports API versioning for backward compatibility with automation scripts
     * written for an object model older than the current one. Such scripts need not be
     * updated to keep up with object model changes This is a deprecated property. The
     * version is now auto populated from property file and its value can be read using
     * APIs
     *
     * @param version New value for the property.
     */
    @Deprecated
    public void setVersion(java.lang.String version) {
        this.version = version;
    }

    /**
     * Value of this property could be Hostname or IP. For instance: - On an NSX-T MP
     * running on default port, the value could be \"10.192.1.1\" - On an NSX-T MP
     * running on custom port, the value could be \"192.168.1.1:32789\" - On an NSX-T
     * MP in VMC deployments, the value could be \"192.168.1.1:5480/nsxapi\"
     *
     * @return The current value of the property.
     */
    public java.lang.String getEnforcementPointAddress() {
        return this.enforcementPointAddress;
    }

    /**
     * Value of this property could be Hostname or IP. For instance: - On an NSX-T MP
     * running on default port, the value could be \"10.192.1.1\" - On an NSX-T MP
     * running on custom port, the value could be \"192.168.1.1:32789\" - On an NSX-T
     * MP in VMC deployments, the value could be \"192.168.1.1:5480/nsxapi\"
     *
     * @param enforcementPointAddress New value for the property.
     */
    public void setEnforcementPointAddress(java.lang.String enforcementPointAddress) {
        this.enforcementPointAddress = enforcementPointAddress;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.EnforcementPointConnectionInfo#RESOURCE_TYPE_NSXTCONNECTIONINFO}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.EnforcementPointConnectionInfo#RESOURCE_TYPE_NSXVCONNECTIONINFO}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.EnforcementPointConnectionInfo#RESOURCE_TYPE_CVXCONNECTIONINFO}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.EnforcementPointConnectionInfo#RESOURCE_TYPE_AVICONNECTIONINFO}</li>
     * </ul> Resource Type of Enforcement Point Connection Info.
     * The value of this property is automatically populated to {@code "AviConnectionInfo"}.
     *
     * @return The current value of the property.
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.aviConnectionInfo;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certificate",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificate, this._getType().getField("certificate")));
        structValue.setField("cloud",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.cloud, this._getType().getField("cloud")));
        structValue.setField("expires_at",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.expiresAt, this._getType().getField("expires_at")));
        structValue.setField("is_default_cert",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.isDefaultCert, this._getType().getField("is_default_cert")));
        structValue.setField("managed_by",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.managedBy, this._getType().getField("managed_by")));
        structValue.setField("password",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.password, this._getType().getField("password")));
        structValue.setField("status",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.status, this._getType().getField("status")));
        structValue.setField("tenant",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.tenant, this._getType().getField("tenant")));
        structValue.setField("thumbprint",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.thumbprint, this._getType().getField("thumbprint")));
        structValue.setField("username",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.username, this._getType().getField("username")));
        structValue.setField("version",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.version, this._getType().getField("version")));
        structValue.setField("enforcement_point_address",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.enforcementPointAddress, this._getType().getField("enforcement_point_address")));
        structValue.setField("resource_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.resourceType, this._getType().getField("resource_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.aviConnectionInfo;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.aviConnectionInfo.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static AviConnectionInfo _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new AviConnectionInfo(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static AviConnectionInfo _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new AviConnectionInfo(structValue);
    }

    /**
     * Builder class for {@link AviConnectionInfo}.
     */
    public static final class Builder {
        private java.lang.String certificate;
        private java.lang.String cloud;
        private java.lang.String expiresAt;
        private java.lang.Boolean isDefaultCert;
        private java.lang.String managedBy;
        private java.lang.String password;
        private java.lang.String status;
        private java.lang.String tenant;
        private java.lang.String thumbprint;
        private java.lang.String username;
        private java.lang.String version;
        private java.lang.String enforcementPointAddress;

        /**
         * Constructor with parameters for the required properties of
         * {@link AviConnectionInfo}.
         */
        public Builder() {
        }

        /**
         * Certificate used when on-borading workflow created by LCM/VCF.
         *
         * @param certificate New value for the property.
         */
        public Builder setCertificate(java.lang.String certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Clouds are containers for the environment that Avi Vantage is installed or
         * operating within. During initial setup of Vantage, a default cloud, named
         * Default-Cloud, is created. This is where the first Controller is deployed, into
         * Default-Cloud. Additional clouds may be added, containing SEs and virtual
         * services. This is a deprecated property. Cloud has been renamed to cloud_name
         * and it will added from specific ALB entity.
         *
         * @param cloud New value for the property.
         */
        public Builder setCloud(java.lang.String cloud) {
            this.cloud = cloud;
            return this;
        }

        /**
         * Expiry time of the token will be set by LCM at the time of Enforcement Point
         * Creation.
         *
         * @param expiresAt New value for the property.
         */
        public Builder setExpiresAt(java.lang.String expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        /**
         * Advanced Load Balancer controller using default portal certificate.
         *
         * @param isDefaultCert New value for the property.
         */
        public Builder setIsDefaultCert(java.lang.Boolean isDefaultCert) {
            this.isDefaultCert = isDefaultCert;
            return this;
        }

        /**
         * Managed by used when on-borading workflow created by LCM/VCF.
         *
         * @param managedBy New value for the property.
         */
        public Builder setManagedBy(java.lang.String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        /**
         * Password or Token for Avi Controller.
         *
         * @param password New value for the property.
         */
        public Builder setPassword(java.lang.String password) {
            this.password = password;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_ACTIVATE}</li> <li>
         * {@link
         * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_DEACTIVATE_PROVIDER}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.AviConnectionInfo#STATUS_DEACTIVATE_API}</li>
         * </ul> This is connection property which checks whether ALB is connected to the
         * controller. Enum options - ACTIVATE, DEACTIVATE_PROVIDER, DEACTIVATE_API.
         * Default value is DEACTIVATE_API.
         *
         * @param status New value for the property.
         */
        public Builder setStatus(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * A tenant is an isolated instance of Avi Controller. Each Avi user account is
         * associated with one or more tenants. The tenant associated with a user account
         * defines the resources that user can access within Avi Vantage. When a user logs
         * in, Avi restricts their access to only those resources that are in the same
         * tenant
         *
         * @param tenant New value for the property.
         */
        public Builder setTenant(java.lang.String tenant) {
            this.tenant = tenant;
            return this;
        }

        /**
         * Thumbprint of EnforcementPoint in the form of a SHA-256 hash represented in
         * lower case HEX.
         *
         * @param thumbprint New value for the property.
         */
        public Builder setThumbprint(java.lang.String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        /**
         * Username.
         *
         * @param username New value for the property.
         */
        public Builder setUsername(java.lang.String username) {
            this.username = username;
            return this;
        }

        /**
         * Avi supports API versioning for backward compatibility with automation scripts
         * written for an object model older than the current one. Such scripts need not be
         * updated to keep up with object model changes This is a deprecated property. The
         * version is now auto populated from property file and its value can be read using
         * APIs
         *
         * @param version New value for the property.
         */
        public Builder setVersion(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Value of this property could be Hostname or IP. For instance: - On an NSX-T MP
         * running on default port, the value could be \"10.192.1.1\" - On an NSX-T MP
         * running on custom port, the value could be \"192.168.1.1:32789\" - On an NSX-T
         * MP in VMC deployments, the value could be \"192.168.1.1:5480/nsxapi\"
         *
         * @param enforcementPointAddress New value for the property.
         */
        public Builder setEnforcementPointAddress(java.lang.String enforcementPointAddress) {
            this.enforcementPointAddress = enforcementPointAddress;
            return this;
        }

        public AviConnectionInfo build() {
            AviConnectionInfo result = new AviConnectionInfo();
            result.setCertificate(this.certificate);
            result.setCloud(this.cloud);
            result.setExpiresAt(this.expiresAt);
            result.setIsDefaultCert(this.isDefaultCert);
            result.setManagedBy(this.managedBy);
            result.setPassword(this.password);
            result.setStatus(this.status);
            result.setTenant(this.tenant);
            result.setThumbprint(this.thumbprint);
            result.setUsername(this.username);
            result.setVersion(this.version);
            result.setEnforcementPointAddress(this.enforcementPointAddress);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certificate", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate",
                                                                                "certificate",
                                                                                "getCertificate",
                                                                                "setCertificate");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("cloud", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("cloud",
                                                                                "cloud",
                                                                                "getCloud",
                                                                                "setCloud");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("expires_at", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("expires_at",
                                                                                "expiresAt",
                                                                                "getExpiresAt",
                                                                                "setExpiresAt");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("is_default_cert", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("is_default_cert",
                                                                                "isDefaultCert",
                                                                                "getIsDefaultCert",
                                                                                "setIsDefaultCert");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("managed_by", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("managed_by",
                                                                                "managedBy",
                                                                                "getManagedBy",
                                                                                "setManagedBy");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("password", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("password",
                                                                                "password",
                                                                                "getPassword",
                                                                                "setPassword");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("status", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("status",
                                                                                "status",
                                                                                "getStatus",
                                                                                "setStatus");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tenant", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tenant",
                                                                                "tenant",
                                                                                "getTenant",
                                                                                "setTenant");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("thumbprint", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("thumbprint",
                                                                                "thumbprint",
                                                                                "getThumbprint",
                                                                                "setThumbprint");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("username", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("username",
                                                                                "username",
                                                                                "getUsername",
                                                                                "setUsername");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("version", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("version",
                                                                                "version",
                                                                                "getVersion",
                                                                                "setVersion");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("enforcement_point_address", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("enforcement_point_address",
                                                                                "enforcementPointAddress",
                                                                                "getEnforcementPointAddress",
                                                                                "setEnforcementPointAddress");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("resource_type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("resource_type",
                                                                                "resourceType",
                                                                                "getResourceType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.avi_connection_info",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.AviConnectionInfo.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            "resource_type",
                                                            "AviConnectionInfo");
    }
}

