/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Additional configuration required for federation at Site.
 */
public final class GmFederationSiteConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String transitSubnet;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public GmFederationSiteConfig() {
    }

    protected GmFederationSiteConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * IP Addresses to be allocated for transit segment when the gateway is stretched.
     * Note that Global Manager will carve out the IP Pool for each site to be used for
     * edge nodes when gateway is stretched based on the user provided subnet and
     * maximum number of edge nodes allowed per site. format: ip-cidr-block
     *
     * @return The current value of the property.
     */
    public java.lang.String getTransitSubnet() {
        return this.transitSubnet;
    }

    /**
     * IP Addresses to be allocated for transit segment when the gateway is stretched.
     * Note that Global Manager will carve out the IP Pool for each site to be used for
     * edge nodes when gateway is stretched based on the user provided subnet and
     * maximum number of edge nodes allowed per site. format: ip-cidr-block
     *
     * @param transitSubnet New value for the property.
     */
    public void setTransitSubnet(java.lang.String transitSubnet) {
        this.transitSubnet = transitSubnet;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.gmFederationSiteConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("transit_subnet",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.transitSubnet, this._getType().getField("transit_subnet")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.gmFederationSiteConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.gmFederationSiteConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static GmFederationSiteConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new GmFederationSiteConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static GmFederationSiteConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new GmFederationSiteConfig(structValue);
    }

    /**
     * Builder class for {@link GmFederationSiteConfig}.
     */
    public static final class Builder {
        private java.lang.String transitSubnet;

        /**
         * Constructor with parameters for the required properties of
         * {@link GmFederationSiteConfig}.
         */
        public Builder() {
        }

        /**
         * IP Addresses to be allocated for transit segment when the gateway is stretched.
         * Note that Global Manager will carve out the IP Pool for each site to be used for
         * edge nodes when gateway is stretched based on the user provided subnet and
         * maximum number of edge nodes allowed per site. format: ip-cidr-block
         *
         * @param transitSubnet New value for the property.
         */
        public Builder setTransitSubnet(java.lang.String transitSubnet) {
            this.transitSubnet = transitSubnet;
            return this;
        }

        public GmFederationSiteConfig build() {
            GmFederationSiteConfig result = new GmFederationSiteConfig();
            result.setTransitSubnet(this.transitSubnet);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("transit_subnet", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("transit_subnet",
                                                                                "transitSubnet",
                                                                                "getTransitSubnet",
                                                                                "setTransitSubnet");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.gm_federation_site_config",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.GmFederationSiteConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

