/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Pool member group.
 */
public final class LBPoolMemberGroup implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String IP_REVISION_FILTER_IPV4 = "IPV4";

    public static final java.lang.String IP_REVISION_FILTER_IPV6 = "IPV6";

    public static final java.lang.String IP_REVISION_FILTER_IPV4_IPV6 = "IPV4_IPV6";

    private java.util.List<com.vmware.nsx_global_policy.model.PoolMemberSetting> customizedMembers;

    private java.lang.String groupPath;

    private java.lang.String ipRevisionFilter;

    private java.lang.Long maxIpListSize;

    private java.lang.Long port;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public LBPoolMemberGroup() {
    }

    protected LBPoolMemberGroup(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The list is used to show the customized pool member settings. User can only user
     * pool member action API to update the admin state for a specific IP address.
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.nsx_global_policy.model.PoolMemberSetting> getCustomizedMembers() {
        return this.customizedMembers;
    }

    /**
     * The list is used to show the customized pool member settings. User can only user
     * pool member action API to update the admin state for a specific IP address.
     *
     * @param customizedMembers New value for the property.
     */
    public void setCustomizedMembers(java.util.List<com.vmware.nsx_global_policy.model.PoolMemberSetting> customizedMembers) {
        this.customizedMembers = customizedMembers;
    }

    /**
     * Load balancer pool support Group as dynamic pool members. The IP list of the
     * Group would be used as pool member IP setting.
     *
     * @return The current value of the property.
     */
    public java.lang.String getGroupPath() {
        return this.groupPath;
    }

    /**
     * Load balancer pool support Group as dynamic pool members. The IP list of the
     * Group would be used as pool member IP setting.
     *
     * @param groupPath New value for the property.
     */
    public void setGroupPath(java.lang.String groupPath) {
        this.groupPath = groupPath;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV4}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV6}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV4_IPV6}</li>
     * </ul> Ip revision filter is used to filter IPv4 or IPv6 addresses from the
     * grouping object. If the filter is not specified, both IPv4 and IPv6 addresses
     * would be used as server IPs. The link local and loopback addresses would be
     * always filtered out.
     *
     * @return The current value of the property.
     */
    public java.lang.String getIpRevisionFilter() {
        return this.ipRevisionFilter;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV4}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV6}</li>
     * <li> {@link
     * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV4_IPV6}</li>
     * </ul> Ip revision filter is used to filter IPv4 or IPv6 addresses from the
     * grouping object. If the filter is not specified, both IPv4 and IPv6 addresses
     * would be used as server IPs. The link local and loopback addresses would be
     * always filtered out.
     *
     * @param ipRevisionFilter New value for the property.
     */
    public void setIpRevisionFilter(java.lang.String ipRevisionFilter) {
        this.ipRevisionFilter = ipRevisionFilter;
    }

    /**
     * The size is used to define the maximum number of grouping object IP address
     * list. These IP addresses would be used as pool members. If the grouping object
     * includes more than certain number of IP addresses, the redundant parts would be
     * ignored and those IP addresses would not be treated as pool members. If the size
     * is not specified, one member is budgeted for this dynamic pool so that the pool
     * has at least one member even if some other dynamic pools grow beyond the
     * capacity of load balancer service. Other members are picked according to
     * available dynamic capacity. The unused members would be set to DISABLED so that
     * the load balancer system itself is not overloaded during runtime. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getMaxIpListSize() {
        return this.maxIpListSize;
    }

    /**
     * The size is used to define the maximum number of grouping object IP address
     * list. These IP addresses would be used as pool members. If the grouping object
     * includes more than certain number of IP addresses, the redundant parts would be
     * ignored and those IP addresses would not be treated as pool members. If the size
     * is not specified, one member is budgeted for this dynamic pool so that the pool
     * has at least one member even if some other dynamic pools grow beyond the
     * capacity of load balancer service. Other members are picked according to
     * available dynamic capacity. The unused members would be set to DISABLED so that
     * the load balancer system itself is not overloaded during runtime. format: int64
     *
     * @param maxIpListSize New value for the property.
     */
    public void setMaxIpListSize(java.lang.Long maxIpListSize) {
        this.maxIpListSize = maxIpListSize;
    }

    /**
     * If port is specified, all connections will be sent to this port. If unset, the
     * same port the client connected to will be used, it could be overridden by
     * default_pool_member_ports setting in virtual server. The port should not
     * specified for multiple ports case. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getPort() {
        return this.port;
    }

    /**
     * If port is specified, all connections will be sent to this port. If unset, the
     * same port the client connected to will be used, it could be overridden by
     * default_pool_member_ports setting in virtual server. The port should not
     * specified for multiple ports case. format: int32
     *
     * @param port New value for the property.
     */
    public void setPort(java.lang.Long port) {
        this.port = port;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBPoolMemberGroup;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("customized_members",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.customizedMembers, this._getType().getField("customized_members")));
        structValue.setField("group_path",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.groupPath, this._getType().getField("group_path")));
        structValue.setField("ip_revision_filter",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.ipRevisionFilter, this._getType().getField("ip_revision_filter")));
        structValue.setField("max_ip_list_size",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.maxIpListSize, this._getType().getField("max_ip_list_size")));
        structValue.setField("port",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.port, this._getType().getField("port")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBPoolMemberGroup;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.LBPoolMemberGroup.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static LBPoolMemberGroup _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new LBPoolMemberGroup(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static LBPoolMemberGroup _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new LBPoolMemberGroup(structValue);
    }

    /**
     * Builder class for {@link LBPoolMemberGroup}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.nsx_global_policy.model.PoolMemberSetting> customizedMembers;
        private java.lang.String groupPath;
        private java.lang.String ipRevisionFilter;
        private java.lang.Long maxIpListSize;
        private java.lang.Long port;

        /**
         * Constructor with parameters for the required properties of
         * {@link LBPoolMemberGroup}.
         */
        public Builder() {
        }

        /**
         * The list is used to show the customized pool member settings. User can only user
         * pool member action API to update the admin state for a specific IP address.
         *
         * @param customizedMembers New value for the property.
         */
        public Builder setCustomizedMembers(java.util.List<com.vmware.nsx_global_policy.model.PoolMemberSetting> customizedMembers) {
            this.customizedMembers = customizedMembers;
            return this;
        }

        /**
         * Load balancer pool support Group as dynamic pool members. The IP list of the
         * Group would be used as pool member IP setting.
         *
         * @param groupPath New value for the property.
         */
        public Builder setGroupPath(java.lang.String groupPath) {
            this.groupPath = groupPath;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV4}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV6}</li>
         * <li> {@link
         * com.vmware.nsx_global_policy.model.LBPoolMemberGroup#IP_REVISION_FILTER_IPV4_IPV6}</li>
         * </ul> Ip revision filter is used to filter IPv4 or IPv6 addresses from the
         * grouping object. If the filter is not specified, both IPv4 and IPv6 addresses
         * would be used as server IPs. The link local and loopback addresses would be
         * always filtered out.
         *
         * @param ipRevisionFilter New value for the property.
         */
        public Builder setIpRevisionFilter(java.lang.String ipRevisionFilter) {
            this.ipRevisionFilter = ipRevisionFilter;
            return this;
        }

        /**
         * The size is used to define the maximum number of grouping object IP address
         * list. These IP addresses would be used as pool members. If the grouping object
         * includes more than certain number of IP addresses, the redundant parts would be
         * ignored and those IP addresses would not be treated as pool members. If the size
         * is not specified, one member is budgeted for this dynamic pool so that the pool
         * has at least one member even if some other dynamic pools grow beyond the
         * capacity of load balancer service. Other members are picked according to
         * available dynamic capacity. The unused members would be set to DISABLED so that
         * the load balancer system itself is not overloaded during runtime. format: int64
         *
         * @param maxIpListSize New value for the property.
         */
        public Builder setMaxIpListSize(java.lang.Long maxIpListSize) {
            this.maxIpListSize = maxIpListSize;
            return this;
        }

        /**
         * If port is specified, all connections will be sent to this port. If unset, the
         * same port the client connected to will be used, it could be overridden by
         * default_pool_member_ports setting in virtual server. The port should not
         * specified for multiple ports case. format: int32
         *
         * @param port New value for the property.
         */
        public Builder setPort(java.lang.Long port) {
            this.port = port;
            return this;
        }

        public LBPoolMemberGroup build() {
            LBPoolMemberGroup result = new LBPoolMemberGroup();
            result.setCustomizedMembers(this.customizedMembers);
            result.setGroupPath(this.groupPath);
            result.setIpRevisionFilter(this.ipRevisionFilter);
            result.setMaxIpListSize(this.maxIpListSize);
            result.setPort(this.port);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("customized_members", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx_global_policy.model.StructDefinitions.poolMemberSetting; } })));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("customized_members",
                                                                                "customizedMembers",
                                                                                "getCustomizedMembers",
                                                                                "setCustomizedMembers");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("group_path", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("group_path",
                                                                                "groupPath",
                                                                                "getGroupPath",
                                                                                "setGroupPath");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ip_revision_filter", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ip_revision_filter",
                                                                                "ipRevisionFilter",
                                                                                "getIpRevisionFilter",
                                                                                "setIpRevisionFilter");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("max_ip_list_size", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("max_ip_list_size",
                                                                                "maxIpListSize",
                                                                                "getMaxIpListSize",
                                                                                "setMaxIpListSize");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("port", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("port",
                                                                                "port",
                                                                                "getPort",
                                                                                "setPort");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.LB_pool_member_group",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.LBPoolMemberGroup.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

