/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx_global_policy.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx_global_policy.model;

/**
 * Activates traffic limit for incoming/outgoing broadcast and multicast packets.
 * Use 0 to deactivate rate limiting for a specific traffic type
 */
public final class TrafficRateLimits implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long rxBroadcast;

    private java.lang.Long rxMulticast;

    private java.lang.Long txBroadcast;

    private java.lang.Long txMulticast;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public TrafficRateLimits() {
    }

    protected TrafficRateLimits(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Incoming broadcast traffic limit in packets per second format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRxBroadcast() {
        return this.rxBroadcast;
    }

    /**
     * Incoming broadcast traffic limit in packets per second format: int32
     *
     * @param rxBroadcast New value for the property.
     */
    public void setRxBroadcast(java.lang.Long rxBroadcast) {
        this.rxBroadcast = rxBroadcast;
    }

    /**
     * Incoming multicast traffic limit in packets per second format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getRxMulticast() {
        return this.rxMulticast;
    }

    /**
     * Incoming multicast traffic limit in packets per second format: int32
     *
     * @param rxMulticast New value for the property.
     */
    public void setRxMulticast(java.lang.Long rxMulticast) {
        this.rxMulticast = rxMulticast;
    }

    /**
     * Outgoing broadcast traffic limit in packets per second format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxBroadcast() {
        return this.txBroadcast;
    }

    /**
     * Outgoing broadcast traffic limit in packets per second format: int32
     *
     * @param txBroadcast New value for the property.
     */
    public void setTxBroadcast(java.lang.Long txBroadcast) {
        this.txBroadcast = txBroadcast;
    }

    /**
     * Outgoing multicast traffic limit in packets per second format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getTxMulticast() {
        return this.txMulticast;
    }

    /**
     * Outgoing multicast traffic limit in packets per second format: int32
     *
     * @param txMulticast New value for the property.
     */
    public void setTxMulticast(java.lang.Long txMulticast) {
        this.txMulticast = txMulticast;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.trafficRateLimits;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("rx_broadcast",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rxBroadcast, this._getType().getField("rx_broadcast")));
        structValue.setField("rx_multicast",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.rxMulticast, this._getType().getField("rx_multicast")));
        structValue.setField("tx_broadcast",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txBroadcast, this._getType().getField("tx_broadcast")));
        structValue.setField("tx_multicast",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.txMulticast, this._getType().getField("tx_multicast")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx_global_policy.model.StructDefinitions.trafficRateLimits;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx_global_policy.model.StructDefinitions.trafficRateLimits.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static TrafficRateLimits _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new TrafficRateLimits(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static TrafficRateLimits _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new TrafficRateLimits(structValue);
    }

    /**
     * Builder class for {@link TrafficRateLimits}.
     */
    public static final class Builder {
        private java.lang.Long rxBroadcast;
        private java.lang.Long rxMulticast;
        private java.lang.Long txBroadcast;
        private java.lang.Long txMulticast;

        /**
         * Constructor with parameters for the required properties of
         * {@link TrafficRateLimits}.
         */
        public Builder() {
        }

        /**
         * Incoming broadcast traffic limit in packets per second format: int32
         *
         * @param rxBroadcast New value for the property.
         */
        public Builder setRxBroadcast(java.lang.Long rxBroadcast) {
            this.rxBroadcast = rxBroadcast;
            return this;
        }

        /**
         * Incoming multicast traffic limit in packets per second format: int32
         *
         * @param rxMulticast New value for the property.
         */
        public Builder setRxMulticast(java.lang.Long rxMulticast) {
            this.rxMulticast = rxMulticast;
            return this;
        }

        /**
         * Outgoing broadcast traffic limit in packets per second format: int32
         *
         * @param txBroadcast New value for the property.
         */
        public Builder setTxBroadcast(java.lang.Long txBroadcast) {
            this.txBroadcast = txBroadcast;
            return this;
        }

        /**
         * Outgoing multicast traffic limit in packets per second format: int32
         *
         * @param txMulticast New value for the property.
         */
        public Builder setTxMulticast(java.lang.Long txMulticast) {
            this.txMulticast = txMulticast;
            return this;
        }

        public TrafficRateLimits build() {
            TrafficRateLimits result = new TrafficRateLimits();
            result.setRxBroadcast(this.rxBroadcast);
            result.setRxMulticast(this.rxMulticast);
            result.setTxBroadcast(this.txBroadcast);
            result.setTxMulticast(this.txMulticast);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("rx_broadcast", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rx_broadcast",
                                                                                "rxBroadcast",
                                                                                "getRxBroadcast",
                                                                                "setRxBroadcast");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("rx_multicast", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("rx_multicast",
                                                                                "rxMulticast",
                                                                                "getRxMulticast",
                                                                                "setRxMulticast");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_broadcast", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_broadcast",
                                                                                "txBroadcast",
                                                                                "getTxBroadcast",
                                                                                "setTxBroadcast");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("tx_multicast", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("tx_multicast",
                                                                                "txMulticast",
                                                                                "getTxMulticast",
                                                                                "setTxMulticast");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx_global_policy.model.traffic_rate_limits",
                                                            fields,
                                                            com.vmware.nsx_global_policy.model.TrafficRateLimits.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

