/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface EdgeClusters extends com.vmware.vapi.bindings.Service, com.vmware.nsx.EdgeClustersTypes {

    /**
     * Creates a new edge cluster. It only supports homogeneous members. The
     * TransportNodes backed by EdgeNode are only allowed in cluster members.
     * DeploymentType (VIRTUAL_MACHINE|PHYSICAL_MACHINE) of these EdgeNodes is
     * recommended to be the same. EdgeCluster supports members of different deployment
     * types.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param edgeCluster (required)
     * @return com.vmware.nsx.model.EdgeCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeCluster create(com.vmware.nsx.model.EdgeCluster edgeCluster);

    /**
     * Creates a new edge cluster. It only supports homogeneous members. The
     * TransportNodes backed by EdgeNode are only allowed in cluster members.
     * DeploymentType (VIRTUAL_MACHINE|PHYSICAL_MACHINE) of these EdgeNodes is
     * recommended to be the same. EdgeCluster supports members of different deployment
     * types.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param edgeCluster (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.EdgeCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeCluster create(com.vmware.nsx.model.EdgeCluster edgeCluster, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a new edge cluster. It only supports homogeneous members. The
     * TransportNodes backed by EdgeNode are only allowed in cluster members.
     * DeploymentType (VIRTUAL_MACHINE|PHYSICAL_MACHINE) of these EdgeNodes is
     * recommended to be the same. EdgeCluster supports members of different deployment
     * types.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeCluster (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.EdgeCluster edgeCluster, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeCluster> asyncCallback);

    /**
     * Creates a new edge cluster. It only supports homogeneous members. The
     * TransportNodes backed by EdgeNode are only allowed in cluster members.
     * DeploymentType (VIRTUAL_MACHINE|PHYSICAL_MACHINE) of these EdgeNodes is
     * recommended to be the same. EdgeCluster supports members of different deployment
     * types.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeCluster (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.EdgeCluster edgeCluster, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeCluster> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes the specified edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param edgeClusterId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String edgeClusterId);

    /**
     * Deletes the specified edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param edgeClusterId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the specified edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param edgeClusterId (required)
     * @return com.vmware.nsx.model.EdgeCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeCluster get(java.lang.String edgeClusterId);

    /**
     * Returns information about the specified edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param edgeClusterId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.EdgeCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeCluster get(java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the specified edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeCluster> asyncCallback);

    /**
     * Returns information about the specified edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String edgeClusterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeCluster> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the configured edge clusters, which enable you to
     * group together transport nodes of the type EdgeNode and apply fabric profiles to
     * all members of the edge cluster. Each edge node can participate in only one edge
     * cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.EdgeClusterListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeClusterListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about the configured edge clusters, which enable you to
     * group together transport nodes of the type EdgeNode and apply fabric profiles to
     * all members of the edge cluster. Each edge node can participate in only one edge
     * cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.EdgeClusterListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeClusterListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the configured edge clusters, which enable you to
     * group together transport nodes of the type EdgeNode and apply fabric profiles to
     * all members of the edge cluster. Each edge node can participate in only one edge
     * cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeClusterListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeClusterListResult> asyncCallback);

    /**
     * Returns information about the configured edge clusters, which enable you to
     * group together transport nodes of the type EdgeNode and apply fabric profiles to
     * all members of the edge cluster. Each edge node can participate in only one edge
     * cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeClusterListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeClusterListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Relocate auto allocated service contexts from edge node at given index. For API
     * to perform relocate and remove action the edge node at given index must only
     * have auto allocated service contexts. If any manually allocated service context
     * is present on the edge cluster member, then the task will not be performed.
     * Also, it is recommended to move edge node for which relocate and remove action
     * is being performed into maintenance mode, before executing the API. If edge is
     * not not moved into maintenance mode, then API will move edge node into
     * maintenance mode before performing the actual relocate and remove task.To
     * maintain high availability, Edge cluster should have at least two healthy edge
     * nodes for relocate and removal. Once relocate action is performed successfully,
     * the edge node will be removed from the edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param edgeClusterId (required)
     * @param edgeClusterMemberIndex (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void relocateandremove(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeClusterMemberIndex edgeClusterMemberIndex);

    /**
     * Relocate auto allocated service contexts from edge node at given index. For API
     * to perform relocate and remove action the edge node at given index must only
     * have auto allocated service contexts. If any manually allocated service context
     * is present on the edge cluster member, then the task will not be performed.
     * Also, it is recommended to move edge node for which relocate and remove action
     * is being performed into maintenance mode, before executing the API. If edge is
     * not not moved into maintenance mode, then API will move edge node into
     * maintenance mode before performing the actual relocate and remove task.To
     * maintain high availability, Edge cluster should have at least two healthy edge
     * nodes for relocate and removal. Once relocate action is performed successfully,
     * the edge node will be removed from the edge cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param edgeClusterId (required)
     * @param edgeClusterMemberIndex (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void relocateandremove(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeClusterMemberIndex edgeClusterMemberIndex, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Relocate auto allocated service contexts from edge node at given index. For API
     * to perform relocate and remove action the edge node at given index must only
     * have auto allocated service contexts. If any manually allocated service context
     * is present on the edge cluster member, then the task will not be performed.
     * Also, it is recommended to move edge node for which relocate and remove action
     * is being performed into maintenance mode, before executing the API. If edge is
     * not not moved into maintenance mode, then API will move edge node into
     * maintenance mode before performing the actual relocate and remove task.To
     * maintain high availability, Edge cluster should have at least two healthy edge
     * nodes for relocate and removal. Once relocate action is performed successfully,
     * the edge node will be removed from the edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param edgeClusterMemberIndex (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void relocateandremove(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeClusterMemberIndex edgeClusterMemberIndex, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Relocate auto allocated service contexts from edge node at given index. For API
     * to perform relocate and remove action the edge node at given index must only
     * have auto allocated service contexts. If any manually allocated service context
     * is present on the edge cluster member, then the task will not be performed.
     * Also, it is recommended to move edge node for which relocate and remove action
     * is being performed into maintenance mode, before executing the API. If edge is
     * not not moved into maintenance mode, then API will move edge node into
     * maintenance mode before performing the actual relocate and remove task.To
     * maintain high availability, Edge cluster should have at least two healthy edge
     * nodes for relocate and removal. Once relocate action is performed successfully,
     * the edge node will be removed from the edge cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param edgeClusterMemberIndex (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void relocateandremove(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeClusterMemberIndex edgeClusterMemberIndex, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Replace the transport node in the specified member of the edge-cluster. This is
     * a disruptive action. This will move all the LogicalRouterPorts(uplink and
     * routerLink) host on the old transport_node to the new transport_node. The
     * transportNode cannot be present in another member of any edgeClusters.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param edgeClusterId (required)
     * @param edgeClusterMemberTransportNode (required)
     * @return com.vmware.nsx.model.EdgeCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeCluster replacetransportnode(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeClusterMemberTransportNode edgeClusterMemberTransportNode);

    /**
     * Replace the transport node in the specified member of the edge-cluster. This is
     * a disruptive action. This will move all the LogicalRouterPorts(uplink and
     * routerLink) host on the old transport_node to the new transport_node. The
     * transportNode cannot be present in another member of any edgeClusters.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param edgeClusterId (required)
     * @param edgeClusterMemberTransportNode (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.EdgeCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeCluster replacetransportnode(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeClusterMemberTransportNode edgeClusterMemberTransportNode, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Replace the transport node in the specified member of the edge-cluster. This is
     * a disruptive action. This will move all the LogicalRouterPorts(uplink and
     * routerLink) host on the old transport_node to the new transport_node. The
     * transportNode cannot be present in another member of any edgeClusters.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param edgeClusterMemberTransportNode (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void replacetransportnode(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeClusterMemberTransportNode edgeClusterMemberTransportNode, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeCluster> asyncCallback);

    /**
     * Replace the transport node in the specified member of the edge-cluster. This is
     * a disruptive action. This will move all the LogicalRouterPorts(uplink and
     * routerLink) host on the old transport_node to the new transport_node. The
     * transportNode cannot be present in another member of any edgeClusters.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param edgeClusterMemberTransportNode (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void replacetransportnode(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeClusterMemberTransportNode edgeClusterMemberTransportNode, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeCluster> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the specified edge cluster. Modifiable parameters include the
     * description, display_name, transport-node-id. If the optional
     * fabric_profile_binding is included, resource_type and profile_id are required.
     * User should do a GET on the edge-cluster and obtain the payload and retain the
     * member_index of the existing members as returning in the GET output. For new
     * member additions, the member_index cannot be defined by the user, user can read
     * the system allocated index to the new member in the output of this API call or
     * by doing a GET call. User cannot use this PUT api to replace the transport_node
     * of an existing member because this is a disruption action, we have exposed a
     * explicit API for doing so, refer to \"ReplaceEdgeClusterMemberTransportNode\"
     * EdgeCluster only supports homogeneous members. The TransportNodes backed by
     * EdgeNode are only allowed in cluster members. DeploymentType
     * (VIRTUAL_MACHINE|PHYSICAL_MACHINE) of these EdgeNodes is recommended to be the
     * same. EdgeCluster supports members of different deployment types.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param edgeClusterId (required)
     * @param edgeCluster (required)
     * @return com.vmware.nsx.model.EdgeCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeCluster update(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeCluster edgeCluster);

    /**
     * Modifies the specified edge cluster. Modifiable parameters include the
     * description, display_name, transport-node-id. If the optional
     * fabric_profile_binding is included, resource_type and profile_id are required.
     * User should do a GET on the edge-cluster and obtain the payload and retain the
     * member_index of the existing members as returning in the GET output. For new
     * member additions, the member_index cannot be defined by the user, user can read
     * the system allocated index to the new member in the output of this API call or
     * by doing a GET call. User cannot use this PUT api to replace the transport_node
     * of an existing member because this is a disruption action, we have exposed a
     * explicit API for doing so, refer to \"ReplaceEdgeClusterMemberTransportNode\"
     * EdgeCluster only supports homogeneous members. The TransportNodes backed by
     * EdgeNode are only allowed in cluster members. DeploymentType
     * (VIRTUAL_MACHINE|PHYSICAL_MACHINE) of these EdgeNodes is recommended to be the
     * same. EdgeCluster supports members of different deployment types.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param edgeClusterId (required)
     * @param edgeCluster (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.EdgeCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.EdgeCluster update(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeCluster edgeCluster, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the specified edge cluster. Modifiable parameters include the
     * description, display_name, transport-node-id. If the optional
     * fabric_profile_binding is included, resource_type and profile_id are required.
     * User should do a GET on the edge-cluster and obtain the payload and retain the
     * member_index of the existing members as returning in the GET output. For new
     * member additions, the member_index cannot be defined by the user, user can read
     * the system allocated index to the new member in the output of this API call or
     * by doing a GET call. User cannot use this PUT api to replace the transport_node
     * of an existing member because this is a disruption action, we have exposed a
     * explicit API for doing so, refer to \"ReplaceEdgeClusterMemberTransportNode\"
     * EdgeCluster only supports homogeneous members. The TransportNodes backed by
     * EdgeNode are only allowed in cluster members. DeploymentType
     * (VIRTUAL_MACHINE|PHYSICAL_MACHINE) of these EdgeNodes is recommended to be the
     * same. EdgeCluster supports members of different deployment types.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param edgeCluster (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeCluster edgeCluster, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeCluster> asyncCallback);

    /**
     * Modifies the specified edge cluster. Modifiable parameters include the
     * description, display_name, transport-node-id. If the optional
     * fabric_profile_binding is included, resource_type and profile_id are required.
     * User should do a GET on the edge-cluster and obtain the payload and retain the
     * member_index of the existing members as returning in the GET output. For new
     * member additions, the member_index cannot be defined by the user, user can read
     * the system allocated index to the new member in the output of this API call or
     * by doing a GET call. User cannot use this PUT api to replace the transport_node
     * of an existing member because this is a disruption action, we have exposed a
     * explicit API for doing so, refer to \"ReplaceEdgeClusterMemberTransportNode\"
     * EdgeCluster only supports homogeneous members. The TransportNodes backed by
     * EdgeNode are only allowed in cluster members. DeploymentType
     * (VIRTUAL_MACHINE|PHYSICAL_MACHINE) of these EdgeNodes is recommended to be the
     * same. EdgeCluster supports members of different deployment types.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.EdgeCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param edgeClusterId (required)
     * @param edgeCluster (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String edgeClusterId, com.vmware.nsx.model.EdgeCluster edgeCluster, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.EdgeCluster> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
