/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface LogicalRouterPorts extends com.vmware.vapi.bindings.Service, com.vmware.nsx.LogicalRouterPortsTypes {

    /**
     * Creates a logical router port. The required parameters include resource_type
     * (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort, LogicalRouterLinkPort,
     * LogicalRouterLoopbackPort, LogicalRouterCentralizedServicePort); and
     * logical_router_id (the router to which each logical router port is assigned).
     * The service_bindings parameter is optional. <br/> <br/> Please use below Policy
     * APIs. <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PATCH /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> PATCH /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterPort (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @return com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure create(com.vmware.vapi.bindings.Structure logicalRouterPort);

    /**
     * Creates a logical router port. The required parameters include resource_type
     * (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort, LogicalRouterLinkPort,
     * LogicalRouterLoopbackPort, LogicalRouterCentralizedServicePort); and
     * logical_router_id (the router to which each logical router port is assigned).
     * The service_bindings parameter is optional. <br/> <br/> Please use below Policy
     * APIs. <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PATCH /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> PATCH /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterPort (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure create(com.vmware.vapi.bindings.Structure logicalRouterPort, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a logical router port. The required parameters include resource_type
     * (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort, LogicalRouterLinkPort,
     * LogicalRouterLoopbackPort, LogicalRouterCentralizedServicePort); and
     * logical_router_id (the router to which each logical router port is assigned).
     * The service_bindings parameter is optional. <br/> <br/> Please use below Policy
     * APIs. <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PATCH /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> PATCH /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPort (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.vapi.bindings.Structure logicalRouterPort, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Creates a logical router port. The required parameters include resource_type
     * (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort, LogicalRouterLinkPort,
     * LogicalRouterLoopbackPort, LogicalRouterCentralizedServicePort); and
     * logical_router_id (the router to which each logical router port is assigned).
     * The service_bindings parameter is optional. <br/> <br/> Please use below Policy
     * APIs. <br/> PATCH
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PATCH
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PATCH /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> PATCH /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPort (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.vapi.bindings.Structure logicalRouterPort, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes the specified logical router port. You must delete logical router ports
     * before you can delete the associated logical router. To Delete Tier0 router link
     * port you must have to delete attached tier1 router link port, otherwise pass
     * \"force=true\" as query param to force delete the Tier0 router link port. <br/>
     * <br/> Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> DELETE /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> DELETE /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterPortId (required)
     * @param cascadeDeleteLinkedPorts Flag to specify whether to delete related logical switch ports (optional,
     * default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterPortId, java.lang.Boolean cascadeDeleteLinkedPorts, java.lang.Boolean force);

    /**
     * Deletes the specified logical router port. You must delete logical router ports
     * before you can delete the associated logical router. To Delete Tier0 router link
     * port you must have to delete attached tier1 router link port, otherwise pass
     * \"force=true\" as query param to force delete the Tier0 router link port. <br/>
     * <br/> Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> DELETE /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> DELETE /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterPortId (required)
     * @param cascadeDeleteLinkedPorts Flag to specify whether to delete related logical switch ports (optional,
     * default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterPortId, java.lang.Boolean cascadeDeleteLinkedPorts, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified logical router port. You must delete logical router ports
     * before you can delete the associated logical router. To Delete Tier0 router link
     * port you must have to delete attached tier1 router link port, otherwise pass
     * \"force=true\" as query param to force delete the Tier0 router link port. <br/>
     * <br/> Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> DELETE /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> DELETE /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param cascadeDeleteLinkedPorts Flag to specify whether to delete related logical switch ports (optional,
     * default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterPortId, java.lang.Boolean cascadeDeleteLinkedPorts, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified logical router port. You must delete logical router ports
     * before you can delete the associated logical router. To Delete Tier0 router link
     * port you must have to delete attached tier1 router link port, otherwise pass
     * \"force=true\" as query param to force delete the Tier0 router link port. <br/>
     * <br/> Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> DELETE
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> DELETE /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> DELETE /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param cascadeDeleteLinkedPorts Flag to specify whether to delete related logical switch ports (optional,
     * default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterPortId, java.lang.Boolean cascadeDeleteLinkedPorts, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the specified logical router port. <br/> <br/> Please
     * use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> GET /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterPortId (required)
     * @return com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String logicalRouterPortId);

    /**
     * Returns information about the specified logical router port. <br/> <br/> Please
     * use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> GET /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterPortId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure get(java.lang.String logicalRouterPortId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the specified logical router port. <br/> <br/> Please
     * use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> GET /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterPortId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Returns information about the specified logical router port. <br/> <br/> Please
     * use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> GET /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterPortId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all logical router ports. Information includes the
     * resource_type (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort,
     * LogicalRouterLinkPort, LogicalRouterLoopbackPort,
     * LogicalRouterCentralizedServicePort); logical_router_id (the router to which
     * each logical router port is assigned); and any service_bindings (such as DHCP
     * relay service). The GET request can include a query parameter (logical_router_id
     * or logical_switch_id). <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments for DOWNLINK <br/>
     * GET /policy/api/v1/infra/segments for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalRouterId Logical Router identifier (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param resourceType Resource types of logical router port (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.LogicalRouterPortListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterPortListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.String logicalRouterId, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String resourceType, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about all logical router ports. Information includes the
     * resource_type (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort,
     * LogicalRouterLinkPort, LogicalRouterLoopbackPort,
     * LogicalRouterCentralizedServicePort); logical_router_id (the router to which
     * each logical router port is assigned); and any service_bindings (such as DHCP
     * relay service). The GET request can include a query parameter (logical_router_id
     * or logical_switch_id). <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments for DOWNLINK <br/>
     * GET /policy/api/v1/infra/segments for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalRouterId Logical Router identifier (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param resourceType Resource types of logical router port (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouterPortListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterPortListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.String logicalRouterId, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String resourceType, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all logical router ports. Information includes the
     * resource_type (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort,
     * LogicalRouterLinkPort, LogicalRouterLoopbackPort,
     * LogicalRouterCentralizedServicePort); logical_router_id (the router to which
     * each logical router port is assigned); and any service_bindings (such as DHCP
     * relay service). The GET request can include a query parameter (logical_router_id
     * or logical_switch_id). <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments for DOWNLINK <br/>
     * GET /policy/api/v1/infra/segments for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPortListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalRouterId Logical Router identifier (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param resourceType Resource types of logical router port (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.String logicalRouterId, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String resourceType, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterPortListResult> asyncCallback);

    /**
     * Returns information about all logical router ports. Information includes the
     * resource_type (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort,
     * LogicalRouterLinkPort, LogicalRouterLoopbackPort,
     * LogicalRouterCentralizedServicePort); logical_router_id (the router to which
     * each logical router port is assigned); and any service_bindings (such as DHCP
     * relay service). The GET request can include a query parameter (logical_router_id
     * or logical_switch_id). <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces
     * <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments for DOWNLINK <br/>
     * GET /policy/api/v1/infra/segments for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPortListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param logicalRouterId Logical Router identifier (optional)
     * @param logicalSwitchId Logical Switch identifier (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param resourceType Resource types of logical router port (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.String logicalRouterId, java.lang.String logicalSwitchId, java.lang.Long pageSize, java.lang.String resourceType, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterPortListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the specified logical router port. Required parameters include the
     * resource_type and logical_router_id. Modifiable parameters include the
     * resource_type (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort,
     * LogicalRouterLinkPort, LogicalRouterLoopbackPort,
     * LogicalRouterCentralizedServicePort), logical_router_id (to reassign the port to
     * a different router), and service_bindings. <br/> <br/> Please use below Policy
     * APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PUT /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> PUT /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterPortId (required)
     * @param logicalRouterPort (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @return com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure update(java.lang.String logicalRouterPortId, com.vmware.vapi.bindings.Structure logicalRouterPort);

    /**
     * Modifies the specified logical router port. Required parameters include the
     * resource_type and logical_router_id. Modifiable parameters include the
     * resource_type (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort,
     * LogicalRouterLinkPort, LogicalRouterLoopbackPort,
     * LogicalRouterCentralizedServicePort), logical_router_id (to reassign the port to
     * a different router), and service_bindings. <br/> <br/> Please use below Policy
     * APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PUT /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> PUT /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterPortId (required)
     * @param logicalRouterPort (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.vapi.bindings.Structure update(java.lang.String logicalRouterPortId, com.vmware.vapi.bindings.Structure logicalRouterPort, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the specified logical router port. Required parameters include the
     * resource_type and logical_router_id. Modifiable parameters include the
     * resource_type (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort,
     * LogicalRouterLinkPort, LogicalRouterLoopbackPort,
     * LogicalRouterCentralizedServicePort), logical_router_id (to reassign the port to
     * a different router), and service_bindings. <br/> <br/> Please use below Policy
     * APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PUT /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> PUT /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param logicalRouterPort (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterPortId, com.vmware.vapi.bindings.Structure logicalRouterPort, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback);

    /**
     * Modifies the specified logical router port. Required parameters include the
     * resource_type and logical_router_id. Modifiable parameters include the
     * resource_type (LogicalRouterUpLinkPort, LogicalRouterDownLinkPort,
     * LogicalRouterLinkPort, LogicalRouterLoopbackPort,
     * LogicalRouterCentralizedServicePort), logical_router_id (to reassign the port to
     * a different router), and service_bindings. <br/> <br/> Please use below Policy
     * APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PUT
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> PUT /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id> for
     * DOWNLINK <br/> PUT /policy/api/v1/infra/segments/<segment-id> for DOWNLINK
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPort
     * The return value will contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param logicalRouterPort (required)
     * The parameter must contain all the properties defined in {@link
     * com.vmware.nsx.model.LogicalRouterPort}.
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterPortId, com.vmware.vapi.bindings.Structure logicalRouterPort, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.vapi.bindings.Structure> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
