/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface LogicalRouters extends com.vmware.vapi.bindings.Service, com.vmware.nsx.LogicalRoutersTypes {

    /**
     * Creates a logical router. The required parameters are router_type (TIER0 or
     * TIER1) and edge_cluster_id (TIER0 only). Optional parameters include internal
     * and external transit network addresses. <br/> <br/> Please use below policy apis
     * instead of this API. <br/> PATCH /infra/tier-0s/<id> <br/> PATCH
     * /infra/tier-0s/<id>/locale-services/<id> <br/> PATCH /infra/tier-1s/<id> <br/>
     * PATCH /infra/tier-1s/<id>/locale-services/<id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouter (required)
     * @return com.vmware.nsx.model.LogicalRouter
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouter create(com.vmware.nsx.model.LogicalRouter logicalRouter);

    /**
     * Creates a logical router. The required parameters are router_type (TIER0 or
     * TIER1) and edge_cluster_id (TIER0 only). Optional parameters include internal
     * and external transit network addresses. <br/> <br/> Please use below policy apis
     * instead of this API. <br/> PATCH /infra/tier-0s/<id> <br/> PATCH
     * /infra/tier-0s/<id>/locale-services/<id> <br/> PATCH /infra/tier-1s/<id> <br/>
     * PATCH /infra/tier-1s/<id>/locale-services/<id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouter (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouter
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouter create(com.vmware.nsx.model.LogicalRouter logicalRouter, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a logical router. The required parameters are router_type (TIER0 or
     * TIER1) and edge_cluster_id (TIER0 only). Optional parameters include internal
     * and external transit network addresses. <br/> <br/> Please use below policy apis
     * instead of this API. <br/> PATCH /infra/tier-0s/<id> <br/> PATCH
     * /infra/tier-0s/<id>/locale-services/<id> <br/> PATCH /infra/tier-1s/<id> <br/>
     * PATCH /infra/tier-1s/<id>/locale-services/<id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouter
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouter (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.LogicalRouter logicalRouter, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouter> asyncCallback);

    /**
     * Creates a logical router. The required parameters are router_type (TIER0 or
     * TIER1) and edge_cluster_id (TIER0 only). Optional parameters include internal
     * and external transit network addresses. <br/> <br/> Please use below policy apis
     * instead of this API. <br/> PATCH /infra/tier-0s/<id> <br/> PATCH
     * /infra/tier-0s/<id>/locale-services/<id> <br/> PATCH /infra/tier-1s/<id> <br/>
     * PATCH /infra/tier-1s/<id>/locale-services/<id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouter
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouter (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(com.vmware.nsx.model.LogicalRouter logicalRouter, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouter> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes the specified logical router. You must delete associated logical router
     * ports before you can delete a logical router. Otherwise use force delete which
     * will delete all related ports and other entities associated with that LR. To
     * force delete logical router pass force=true in query param. <br/> <br/> Please
     * use below policy apis instead of this API. <br/> DELETE /infra/tier-0s/<id>
     * <br/> DELETE /infra/tier-1s/<id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param cascadeDeleteLinkedPorts Flag to specify whether to delete related logical switch ports (optional,
     * default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.Boolean cascadeDeleteLinkedPorts, java.lang.Boolean force);

    /**
     * Deletes the specified logical router. You must delete associated logical router
     * ports before you can delete a logical router. Otherwise use force delete which
     * will delete all related ports and other entities associated with that LR. To
     * force delete logical router pass force=true in query param. <br/> <br/> Please
     * use below policy apis instead of this API. <br/> DELETE /infra/tier-0s/<id>
     * <br/> DELETE /infra/tier-1s/<id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param cascadeDeleteLinkedPorts Flag to specify whether to delete related logical switch ports (optional,
     * default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.Boolean cascadeDeleteLinkedPorts, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified logical router. You must delete associated logical router
     * ports before you can delete a logical router. Otherwise use force delete which
     * will delete all related ports and other entities associated with that LR. To
     * force delete logical router pass force=true in query param. <br/> <br/> Please
     * use below policy apis instead of this API. <br/> DELETE /infra/tier-0s/<id>
     * <br/> DELETE /infra/tier-1s/<id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cascadeDeleteLinkedPorts Flag to specify whether to delete related logical switch ports (optional,
     * default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.Boolean cascadeDeleteLinkedPorts, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified logical router. You must delete associated logical router
     * ports before you can delete a logical router. Otherwise use force delete which
     * will delete all related ports and other entities associated with that LR. To
     * force delete logical router pass force=true in query param. <br/> <br/> Please
     * use below policy apis instead of this API. <br/> DELETE /infra/tier-0s/<id>
     * <br/> DELETE /infra/tier-1s/<id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cascadeDeleteLinkedPorts Flag to specify whether to delete related logical switch ports (optional,
     * default to false)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.Boolean cascadeDeleteLinkedPorts, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about the specified logical router. <br/> <br/> Please use
     * below policy apis instead of this API. <br/> GET /infra/tier-0s/<id> <br/> GET
     * /infra/tier-0s/<id>/locale-services/<id> <br/> GET /infra/tier-1s/<id> <br/> GET
     * /infra/tier-1s/<id>/locale-services/<id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @return com.vmware.nsx.model.LogicalRouter
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouter get(java.lang.String logicalRouterId);

    /**
     * Returns information about the specified logical router. <br/> <br/> Please use
     * below policy apis instead of this API. <br/> GET /infra/tier-0s/<id> <br/> GET
     * /infra/tier-0s/<id>/locale-services/<id> <br/> GET /infra/tier-1s/<id> <br/> GET
     * /infra/tier-1s/<id>/locale-services/<id> <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouter
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouter get(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about the specified logical router. <br/> <br/> Please use
     * below policy apis instead of this API. <br/> GET /infra/tier-0s/<id> <br/> GET
     * /infra/tier-0s/<id>/locale-services/<id> <br/> GET /infra/tier-1s/<id> <br/> GET
     * /infra/tier-1s/<id>/locale-services/<id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouter
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouter> asyncCallback);

    /**
     * Returns information about the specified logical router. <br/> <br/> Please use
     * below policy apis instead of this API. <br/> GET /infra/tier-0s/<id> <br/> GET
     * /infra/tier-0s/<id>/locale-services/<id> <br/> GET /infra/tier-1s/<id> <br/> GET
     * /infra/tier-1s/<id>/locale-services/<id> <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouter
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouter> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all logical routers, including the UUID, internal and
     * external transit network addresses, and the router type (TIER0 or TIER1). You
     * can get information for only TIER0 routers or only the TIER1 routers by
     * including the router_type query parameter. <br/> <br/> Please use below policy
     * apis instead of this API. <br/> GET /infra/tier-0s/ <br/> GET /infra/tier-1s/
     * <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routerType Type of Logical Router (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param vrfsOnLogicalRouterId List all VRFs on the specified logical router. (optional)
     * @return com.vmware.nsx.model.LogicalRouterListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String routerType, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String vrfsOnLogicalRouterId);

    /**
     * Returns information about all logical routers, including the UUID, internal and
     * external transit network addresses, and the router type (TIER0 or TIER1). You
     * can get information for only TIER0 routers or only the TIER1 routers by
     * including the router_type query parameter. <br/> <br/> Please use below policy
     * apis instead of this API. <br/> GET /infra/tier-0s/ <br/> GET /infra/tier-1s/
     * <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routerType Type of Logical Router (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param vrfsOnLogicalRouterId List all VRFs on the specified logical router. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouterListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterListResult list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String routerType, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String vrfsOnLogicalRouterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all logical routers, including the UUID, internal and
     * external transit network addresses, and the router type (TIER0 or TIER1). You
     * can get information for only TIER0 routers or only the TIER1 routers by
     * including the router_type query parameter. <br/> <br/> Please use below policy
     * apis instead of this API. <br/> GET /infra/tier-0s/ <br/> GET /infra/tier-1s/
     * <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routerType Type of Logical Router (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param vrfsOnLogicalRouterId List all VRFs on the specified logical router. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String routerType, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String vrfsOnLogicalRouterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterListResult> asyncCallback);

    /**
     * Returns information about all logical routers, including the UUID, internal and
     * external transit network addresses, and the router type (TIER0 or TIER1). You
     * can get information for only TIER0 routers or only the TIER1 routers by
     * including the router_type query parameter. <br/> <br/> Please use below policy
     * apis instead of this API. <br/> GET /infra/tier-0s/ <br/> GET /infra/tier-1s/
     * <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param routerType Type of Logical Router (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param vrfsOnLogicalRouterId List all VRFs on the specified logical router. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.String routerType, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String vrfsOnLogicalRouterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * API to re allocate edge node placement for TIER1 logical router. You can
     * re-allocate service routers of TIER1 in same edge cluster or different edge
     * cluster. You can also place edge nodes manually and provide maximum two indices
     * for HA mode ACTIVE_STANDBY. To re-allocate on new edge cluster you must have
     * existing edge cluster for TIER1 logical router. This will be disruptive
     * operation and all existing statistics of logical router will be remove. <br/>
     * <br/> In policy there will be no equivalent API but it will be achieved
     * automatically when you will change edge cluster or will remove edge nodes from
     * tier1 locale service
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param serviceRouterAllocationConfig (required)
     * @return com.vmware.nsx.model.LogicalRouter
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouter reallocate(java.lang.String logicalRouterId, com.vmware.nsx.model.ServiceRouterAllocationConfig serviceRouterAllocationConfig);

    /**
     * API to re allocate edge node placement for TIER1 logical router. You can
     * re-allocate service routers of TIER1 in same edge cluster or different edge
     * cluster. You can also place edge nodes manually and provide maximum two indices
     * for HA mode ACTIVE_STANDBY. To re-allocate on new edge cluster you must have
     * existing edge cluster for TIER1 logical router. This will be disruptive
     * operation and all existing statistics of logical router will be remove. <br/>
     * <br/> In policy there will be no equivalent API but it will be achieved
     * automatically when you will change edge cluster or will remove edge nodes from
     * tier1 locale service
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param serviceRouterAllocationConfig (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouter
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouter reallocate(java.lang.String logicalRouterId, com.vmware.nsx.model.ServiceRouterAllocationConfig serviceRouterAllocationConfig, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * API to re allocate edge node placement for TIER1 logical router. You can
     * re-allocate service routers of TIER1 in same edge cluster or different edge
     * cluster. You can also place edge nodes manually and provide maximum two indices
     * for HA mode ACTIVE_STANDBY. To re-allocate on new edge cluster you must have
     * existing edge cluster for TIER1 logical router. This will be disruptive
     * operation and all existing statistics of logical router will be remove. <br/>
     * <br/> In policy there will be no equivalent API but it will be achieved
     * automatically when you will change edge cluster or will remove edge nodes from
     * tier1 locale service
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouter
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param serviceRouterAllocationConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void reallocate(java.lang.String logicalRouterId, com.vmware.nsx.model.ServiceRouterAllocationConfig serviceRouterAllocationConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouter> asyncCallback);

    /**
     * API to re allocate edge node placement for TIER1 logical router. You can
     * re-allocate service routers of TIER1 in same edge cluster or different edge
     * cluster. You can also place edge nodes manually and provide maximum two indices
     * for HA mode ACTIVE_STANDBY. To re-allocate on new edge cluster you must have
     * existing edge cluster for TIER1 logical router. This will be disruptive
     * operation and all existing statistics of logical router will be remove. <br/>
     * <br/> In policy there will be no equivalent API but it will be achieved
     * automatically when you will change edge cluster or will remove edge nodes from
     * tier1 locale service
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouter
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param serviceRouterAllocationConfig (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void reallocate(java.lang.String logicalRouterId, com.vmware.nsx.model.ServiceRouterAllocationConfig serviceRouterAllocationConfig, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouter> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Reprocess logical router configuration and configuration of related entities
     * like logical router ports, static routing, etc. Any missing Updates are
     * published to controller. <br/> <br/> Please use below policy apis instead of
     * this API. <br/> POST /infra/tier-0s/<tier-0-id>?action=reprocess <br/> POST
     * /infra/tier-1s/<tier-1-id>?action=reprocess <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void reprocess(java.lang.String logicalRouterId);

    /**
     * Reprocess logical router configuration and configuration of related entities
     * like logical router ports, static routing, etc. Any missing Updates are
     * published to controller. <br/> <br/> Please use below policy apis instead of
     * this API. <br/> POST /infra/tier-0s/<tier-0-id>?action=reprocess <br/> POST
     * /infra/tier-1s/<tier-1-id>?action=reprocess <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void reprocess(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Reprocess logical router configuration and configuration of related entities
     * like logical router ports, static routing, etc. Any missing Updates are
     * published to controller. <br/> <br/> Please use below policy apis instead of
     * this API. <br/> POST /infra/tier-0s/<tier-0-id>?action=reprocess <br/> POST
     * /infra/tier-1s/<tier-1-id>?action=reprocess <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void reprocess(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Reprocess logical router configuration and configuration of related entities
     * like logical router ports, static routing, etc. Any missing Updates are
     * published to controller. <br/> <br/> Please use below policy apis instead of
     * this API. <br/> POST /infra/tier-0s/<tier-0-id>?action=reprocess <br/> POST
     * /infra/tier-1s/<tier-1-id>?action=reprocess <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void reprocess(java.lang.String logicalRouterId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the specified logical router. Modifiable attributes include the
     * internal_transit_network, external_transit_networks, and edge_cluster_id (for
     * TIER0 routers). <br/> <br/> Please use below policy apis instead of this API.
     * <br/> PUT /infra/tier-0s/<id> <br/> PUT /infra/tier-0s/<id>/locale-services/<id>
     * <br/> PUT /infra/tier-1s/<id> <br/> PUT /infra/tier-1s/<id>/locale-services/<id>
     * <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param logicalRouter (required)
     * @return com.vmware.nsx.model.LogicalRouter
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouter update(java.lang.String logicalRouterId, com.vmware.nsx.model.LogicalRouter logicalRouter);

    /**
     * Modifies the specified logical router. Modifiable attributes include the
     * internal_transit_network, external_transit_networks, and edge_cluster_id (for
     * TIER0 routers). <br/> <br/> Please use below policy apis instead of this API.
     * <br/> PUT /infra/tier-0s/<id> <br/> PUT /infra/tier-0s/<id>/locale-services/<id>
     * <br/> PUT /infra/tier-1s/<id> <br/> PUT /infra/tier-1s/<id>/locale-services/<id>
     * <br/>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param logicalRouter (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouter
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouter update(java.lang.String logicalRouterId, com.vmware.nsx.model.LogicalRouter logicalRouter, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the specified logical router. Modifiable attributes include the
     * internal_transit_network, external_transit_networks, and edge_cluster_id (for
     * TIER0 routers). <br/> <br/> Please use below policy apis instead of this API.
     * <br/> PUT /infra/tier-0s/<id> <br/> PUT /infra/tier-0s/<id>/locale-services/<id>
     * <br/> PUT /infra/tier-1s/<id> <br/> PUT /infra/tier-1s/<id>/locale-services/<id>
     * <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouter
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param logicalRouter (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, com.vmware.nsx.model.LogicalRouter logicalRouter, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouter> asyncCallback);

    /**
     * Modifies the specified logical router. Modifiable attributes include the
     * internal_transit_network, external_transit_networks, and edge_cluster_id (for
     * TIER0 routers). <br/> <br/> Please use below policy apis instead of this API.
     * <br/> PUT /infra/tier-0s/<id> <br/> PUT /infra/tier-0s/<id>/locale-services/<id>
     * <br/> PUT /infra/tier-1s/<id> <br/> PUT /infra/tier-1s/<id>/locale-services/<id>
     * <br/>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouter
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param logicalRouter (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, com.vmware.nsx.model.LogicalRouter logicalRouter, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouter> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
