/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.
 * Used by client-side stubs.
 */

package com.vmware.nsx;

public interface TransportNodeCollections extends com.vmware.vapi.bindings.Service, com.vmware.nsx.TransportNodeCollectionsTypes {

    /**
     * When transport node collection is created the hosts which are part of compute
     * collection will be prepared automatically i.e. NSX Manager attempts to install
     * the NSX components on hosts. Transport nodes for these hosts are created using
     * the configuration specified in transport node profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeCollection (required)
     * @param applyProfile Indicates if the Transport Node Profile (TNP) configuration should be applied
     * during creation (optional, default to true)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @return com.vmware.nsx.model.TransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.TransportNodeCollection create(com.vmware.nsx.model.TransportNodeCollection transportNodeCollection, java.lang.Boolean applyProfile, java.lang.Boolean overrideNsxOwnership);

    /**
     * When transport node collection is created the hosts which are part of compute
     * collection will be prepared automatically i.e. NSX Manager attempts to install
     * the NSX components on hosts. Transport nodes for these hosts are created using
     * the configuration specified in transport node profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeCollection (required)
     * @param applyProfile Indicates if the Transport Node Profile (TNP) configuration should be applied
     * during creation (optional, default to true)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.TransportNodeCollection create(com.vmware.nsx.model.TransportNodeCollection transportNodeCollection, java.lang.Boolean applyProfile, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * When transport node collection is created the hosts which are part of compute
     * collection will be prepared automatically i.e. NSX Manager attempts to install
     * the NSX components on hosts. Transport nodes for these hosts are created using
     * the configuration specified in transport node profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollection (required)
     * @param applyProfile Indicates if the Transport Node Profile (TNP) configuration should be applied
     * during creation (optional, default to true)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.TransportNodeCollection transportNodeCollection, java.lang.Boolean applyProfile, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeCollection> asyncCallback);

    /**
     * When transport node collection is created the hosts which are part of compute
     * collection will be prepared automatically i.e. NSX Manager attempts to install
     * the NSX components on hosts. Transport nodes for these hosts are created using
     * the configuration specified in transport node profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollection (required)
     * @param applyProfile Indicates if the Transport Node Profile (TNP) configuration should be applied
     * during creation (optional, default to true)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.TransportNodeCollection transportNodeCollection, java.lang.Boolean applyProfile, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeCollection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * By deleting transport node collection, we are detaching the transport node
     * profile(TNP) from the compute collection. It has no effect on existing transport
     * nodes. However, new hosts added to the compute collection will no longer be
     * automatically converted to NSX transport node. Detaching TNP from compute
     * collection does not delete TNP.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeCollectionId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String transportNodeCollectionId);

    /**
     * By deleting transport node collection, we are detaching the transport node
     * profile(TNP) from the compute collection. It has no effect on existing transport
     * nodes. However, new hosts added to the compute collection will no longer be
     * automatically converted to NSX transport node. Detaching TNP from compute
     * collection does not delete TNP.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeCollectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * By deleting transport node collection, we are detaching the transport node
     * profile(TNP) from the compute collection. It has no effect on existing transport
     * nodes. However, new hosts added to the compute collection will no longer be
     * automatically converted to NSX transport node. Detaching TNP from compute
     * collection does not delete TNP.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * By deleting transport node collection, we are detaching the transport node
     * profile(TNP) from the compute collection. It has no effect on existing transport
     * nodes. However, new hosts added to the compute collection will no longer be
     * automatically converted to NSX transport node. Detaching TNP from compute
     * collection does not delete TNP.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns transport node collection by id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeCollectionId (required)
     * @return com.vmware.nsx.model.TransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.TransportNodeCollection get(java.lang.String transportNodeCollectionId);

    /**
     * Returns transport node collection by id
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeCollectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.TransportNodeCollection get(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns transport node collection by id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeCollection> asyncCallback);

    /**
     * Returns transport node collection by id
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeCollection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns all Transport Node collections
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param clusterMoid Managed object ID of cluster in VC (optional)
     * @param computeCollectionId Compute collection id (optional)
     * @param vcInstanceUuid UUID for VC deployment (optional)
     * @return com.vmware.nsx.model.TransportNodeCollectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.TransportNodeCollectionListResult list(java.lang.String clusterMoid, java.lang.String computeCollectionId, java.lang.String vcInstanceUuid);

    /**
     * Returns all Transport Node collections
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param clusterMoid Managed object ID of cluster in VC (optional)
     * @param computeCollectionId Compute collection id (optional)
     * @param vcInstanceUuid UUID for VC deployment (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeCollectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.TransportNodeCollectionListResult list(java.lang.String clusterMoid, java.lang.String computeCollectionId, java.lang.String vcInstanceUuid, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns all Transport Node collections
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeCollectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusterMoid Managed object ID of cluster in VC (optional)
     * @param computeCollectionId Compute collection id (optional)
     * @param vcInstanceUuid UUID for VC deployment (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String clusterMoid, java.lang.String computeCollectionId, java.lang.String vcInstanceUuid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeCollectionListResult> asyncCallback);

    /**
     * Returns all Transport Node collections
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeCollectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusterMoid Managed object ID of cluster in VC (optional)
     * @param computeCollectionId Compute collection id (optional)
     * @param vcInstanceUuid UUID for VC deployment (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String clusterMoid, java.lang.String computeCollectionId, java.lang.String vcInstanceUuid, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeCollectionListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * This API is relevant for compute collection on which vLCM is enabled. This API
     * shpuld be invoked to retry the realization of transport node profile on the
     * compute collection. This is useful when profile realization had failed because
     * of error in vLCM. This API has no effect if vLCM is not enabled on the computer
     * collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeCollectionId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void retryprofilerealization(java.lang.String transportNodeCollectionId);

    /**
     * This API is relevant for compute collection on which vLCM is enabled. This API
     * shpuld be invoked to retry the realization of transport node profile on the
     * compute collection. This is useful when profile realization had failed because
     * of error in vLCM. This API has no effect if vLCM is not enabled on the computer
     * collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeCollectionId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void retryprofilerealization(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * This API is relevant for compute collection on which vLCM is enabled. This API
     * shpuld be invoked to retry the realization of transport node profile on the
     * compute collection. This is useful when profile realization had failed because
     * of error in vLCM. This API has no effect if vLCM is not enabled on the computer
     * collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void retryprofilerealization(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * This API is relevant for compute collection on which vLCM is enabled. This API
     * shpuld be invoked to retry the realization of transport node profile on the
     * compute collection. This is useful when profile realization had failed because
     * of error in vLCM. This API has no effect if vLCM is not enabled on the computer
     * collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollectionId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void retryprofilerealization(java.lang.String transportNodeCollectionId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Attach different transport node profile to compute collection by updating
     * transport node collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param transportNodeCollectionId (required)
     * @param transportNodeCollection (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @return com.vmware.nsx.model.TransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.TransportNodeCollection update(java.lang.String transportNodeCollectionId, com.vmware.nsx.model.TransportNodeCollection transportNodeCollection, java.lang.Boolean overrideNsxOwnership);

    /**
     * Attach different transport node profile to compute collection by updating
     * transport node collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param transportNodeCollectionId (required)
     * @param transportNodeCollection (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.TransportNodeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.TransportNodeCollection update(java.lang.String transportNodeCollectionId, com.vmware.nsx.model.TransportNodeCollection transportNodeCollection, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Attach different transport node profile to compute collection by updating
     * transport node collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollectionId (required)
     * @param transportNodeCollection (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String transportNodeCollectionId, com.vmware.nsx.model.TransportNodeCollection transportNodeCollection, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeCollection> asyncCallback);

    /**
     * Attach different transport node profile to compute collection by updating
     * transport node collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.TransportNodeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param transportNodeCollectionId (required)
     * @param transportNodeCollection (required)
     * @param overrideNsxOwnership Override NSX Ownership (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String transportNodeCollectionId, com.vmware.nsx.model.TransportNodeCollection transportNodeCollection, java.lang.Boolean overrideNsxOwnership, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.TransportNodeCollection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
