/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.cluster.nodes.
 * Used by client-side stubs.
 */

package com.vmware.nsx.cluster.nodes;

public interface Deployments extends com.vmware.vapi.bindings.Service, com.vmware.nsx.cluster.nodes.DeploymentsTypes {

    /**
     * Deploys a cluster node VM as specified by the deployment config. Once the VM is
     * deployed and powered on, it will automatically join the existing cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param addClusterNodeVMInfo (required)
     * @return com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList create(com.vmware.nsx.model.AddClusterNodeVMInfo addClusterNodeVMInfo);

    /**
     * Deploys a cluster node VM as specified by the deployment config. Once the VM is
     * deployed and powered on, it will automatically join the existing cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param addClusterNodeVMInfo (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList create(com.vmware.nsx.model.AddClusterNodeVMInfo addClusterNodeVMInfo, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deploys a cluster node VM as specified by the deployment config. Once the VM is
     * deployed and powered on, it will automatically join the existing cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param addClusterNodeVMInfo (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(com.vmware.nsx.model.AddClusterNodeVMInfo addClusterNodeVMInfo, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList> asyncCallback);

    /**
     * Deploys a cluster node VM as specified by the deployment config. Once the VM is
     * deployed and powered on, it will automatically join the existing cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param addClusterNodeVMInfo (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(com.vmware.nsx.model.AddClusterNodeVMInfo addClusterNodeVMInfo, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Attempts to unregister and undeploy a specified auto-deployed cluster node VM.
     * If it is a member of a cluster, then the VM will be automatically detached from
     * the cluster before being unregistered and undeployed. Alternatively, if the
     * original deployment attempt failed or the VM is not found, cleans up the
     * deployment information associated with the deployment attempt. Note: If a VM has
     * been successfully auto-deployed, then the associated deployment information will
     * not be deleted unless and until the VM is successfully deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeId (required)
     * @param forceDelete Delete by force (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String nodeId, java.lang.Boolean forceDelete);

    /**
     * Attempts to unregister and undeploy a specified auto-deployed cluster node VM.
     * If it is a member of a cluster, then the VM will be automatically detached from
     * the cluster before being unregistered and undeployed. Alternatively, if the
     * original deployment attempt failed or the VM is not found, cleans up the
     * deployment information associated with the deployment attempt. Note: If a VM has
     * been successfully auto-deployed, then the associated deployment information will
     * not be deleted unless and until the VM is successfully deleted.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeId (required)
     * @param forceDelete Delete by force (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String nodeId, java.lang.Boolean forceDelete, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Attempts to unregister and undeploy a specified auto-deployed cluster node VM.
     * If it is a member of a cluster, then the VM will be automatically detached from
     * the cluster before being unregistered and undeployed. Alternatively, if the
     * original deployment attempt failed or the VM is not found, cleans up the
     * deployment information associated with the deployment attempt. Note: If a VM has
     * been successfully auto-deployed, then the associated deployment information will
     * not be deleted unless and until the VM is successfully deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param forceDelete Delete by force (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String nodeId, java.lang.Boolean forceDelete, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Attempts to unregister and undeploy a specified auto-deployed cluster node VM.
     * If it is a member of a cluster, then the VM will be automatically detached from
     * the cluster before being unregistered and undeployed. Alternatively, if the
     * original deployment attempt failed or the VM is not found, cleans up the
     * deployment information associated with the deployment attempt. Note: If a VM has
     * been successfully auto-deployed, then the associated deployment information will
     * not be deleted unless and until the VM is successfully deleted.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param forceDelete Delete by force (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String nodeId, java.lang.Boolean forceDelete, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns deployment request information for a specific attempted deployment of a
     * cluster node VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeId (required)
     * @return com.vmware.nsx.model.ClusterNodeVMDeploymentRequest
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ClusterNodeVMDeploymentRequest get(java.lang.String nodeId);

    /**
     * Returns deployment request information for a specific attempted deployment of a
     * cluster node VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ClusterNodeVMDeploymentRequest
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ClusterNodeVMDeploymentRequest get(java.lang.String nodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns deployment request information for a specific attempted deployment of a
     * cluster node VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ClusterNodeVMDeploymentRequest
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String nodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ClusterNodeVMDeploymentRequest> asyncCallback);

    /**
     * Returns deployment request information for a specific attempted deployment of a
     * cluster node VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ClusterNodeVMDeploymentRequest
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String nodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ClusterNodeVMDeploymentRequest> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns request information for every attempted deployment of a cluster node VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList list();

    /**
     * Returns request information for every attempted deployment of a cluster node VM.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns request information for every attempted deployment of a cluster node VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList> asyncCallback);

    /**
     * Returns request information for every attempted deployment of a cluster node VM.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ClusterNodeVMDeploymentRequestList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
