/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.configs.central_config.
 * Used by client-side stubs.
 */

package com.vmware.nsx.configs.central_config;

public interface NodeConfigProfiles extends com.vmware.vapi.bindings.Service, com.vmware.nsx.configs.central_config.NodeConfigProfilesTypes {

    /**
     * Returns properties in specified Central Node Config profile. Sensitive data
     * (like SNMP v2c community strings) are included only if query parameter
     * \"show_sensitive_data\" is true.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param profileId Central Node Config profile id (required)
     * @param showSensitiveData Show sensitive data in Central Node Config profile (optional, default to false)
     * @return com.vmware.nsx.model.CentralNodeConfigProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CentralNodeConfigProfile get(java.lang.String profileId, java.lang.Boolean showSensitiveData);

    /**
     * Returns properties in specified Central Node Config profile. Sensitive data
     * (like SNMP v2c community strings) are included only if query parameter
     * \"show_sensitive_data\" is true.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param profileId Central Node Config profile id (required)
     * @param showSensitiveData Show sensitive data in Central Node Config profile (optional, default to false)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.CentralNodeConfigProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CentralNodeConfigProfile get(java.lang.String profileId, java.lang.Boolean showSensitiveData, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns properties in specified Central Node Config profile. Sensitive data
     * (like SNMP v2c community strings) are included only if query parameter
     * \"show_sensitive_data\" is true.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CentralNodeConfigProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param profileId Central Node Config profile id (required)
     * @param showSensitiveData Show sensitive data in Central Node Config profile (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String profileId, java.lang.Boolean showSensitiveData, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CentralNodeConfigProfile> asyncCallback);

    /**
     * Returns properties in specified Central Node Config profile. Sensitive data
     * (like SNMP v2c community strings) are included only if query parameter
     * \"show_sensitive_data\" is true.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CentralNodeConfigProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param profileId Central Node Config profile id (required)
     * @param showSensitiveData Show sensitive data in Central Node Config profile (optional, default to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String profileId, java.lang.Boolean showSensitiveData, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CentralNodeConfigProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns list of all Central Node Config profiles.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @return com.vmware.nsx.model.CentralNodeConfigProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CentralNodeConfigProfileListResult list();

    /**
     * Returns list of all Central Node Config profiles.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.CentralNodeConfigProfileListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CentralNodeConfigProfileListResult list(com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns list of all Central Node Config profiles.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CentralNodeConfigProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CentralNodeConfigProfileListResult> asyncCallback);

    /**
     * Returns list of all Central Node Config profiles.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CentralNodeConfigProfileListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CentralNodeConfigProfileListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Updates properties in the specified Central Node Config profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param nodeConfigProfileId (required)
     * @param centralNodeConfigProfile (required)
     * @return com.vmware.nsx.model.CentralNodeConfigProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CentralNodeConfigProfile update(java.lang.String nodeConfigProfileId, com.vmware.nsx.model.CentralNodeConfigProfile centralNodeConfigProfile);

    /**
     * Updates properties in the specified Central Node Config profile.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param nodeConfigProfileId (required)
     * @param centralNodeConfigProfile (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.CentralNodeConfigProfile
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.CentralNodeConfigProfile update(java.lang.String nodeConfigProfileId, com.vmware.nsx.model.CentralNodeConfigProfile centralNodeConfigProfile, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Updates properties in the specified Central Node Config profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CentralNodeConfigProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeConfigProfileId (required)
     * @param centralNodeConfigProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void update(java.lang.String nodeConfigProfileId, com.vmware.nsx.model.CentralNodeConfigProfile centralNodeConfigProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CentralNodeConfigProfile> asyncCallback);

    /**
     * Updates properties in the specified Central Node Config profile.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.CentralNodeConfigProfile
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param nodeConfigProfileId (required)
     * @param centralNodeConfigProfile (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void update(java.lang.String nodeConfigProfileId, com.vmware.nsx.model.CentralNodeConfigProfile centralNodeConfigProfile, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.CentralNodeConfigProfile> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
