/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.dhcp.servers.
 * Used by client-side stubs.
 */

package com.vmware.nsx.dhcp.servers;

public interface Leases extends com.vmware.vapi.bindings.Service, com.vmware.nsx.dhcp.servers.LeasesTypes {

    /**
     * Delete a single DHCP lease entry specified by ip and mac. The DHCP server
     * matches the DHCP lease with the given ip address and the mac address. The
     * matched lease entry will be deleted. If no lease matches, the request is
     * ignored. The DHCP lease to be deleted will be removed by the system from both
     * active and standby node. The system will report error if the DHCP lease could
     * not be removed from both nodes. If the DHCP lease could not be removed on either
     * node, please check the DHCP server status. Once the DHCP server status is UP,
     * please invoke the deletion API again to ensure the lease gets deleted from both
     * nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serverId (required)
     * @param ip IPv4 or IPv6 address (required)
     * @param mac MAC Address (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String serverId, java.lang.String ip, java.lang.String mac);

    /**
     * Delete a single DHCP lease entry specified by ip and mac. The DHCP server
     * matches the DHCP lease with the given ip address and the mac address. The
     * matched lease entry will be deleted. If no lease matches, the request is
     * ignored. The DHCP lease to be deleted will be removed by the system from both
     * active and standby node. The system will report error if the DHCP lease could
     * not be removed from both nodes. If the DHCP lease could not be removed on either
     * node, please check the DHCP server status. Once the DHCP server status is UP,
     * please invoke the deletion API again to ensure the lease gets deleted from both
     * nodes.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serverId (required)
     * @param ip IPv4 or IPv6 address (required)
     * @param mac MAC Address (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void delete(java.lang.String serverId, java.lang.String ip, java.lang.String mac, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete a single DHCP lease entry specified by ip and mac. The DHCP server
     * matches the DHCP lease with the given ip address and the mac address. The
     * matched lease entry will be deleted. If no lease matches, the request is
     * ignored. The DHCP lease to be deleted will be removed by the system from both
     * active and standby node. The system will report error if the DHCP lease could
     * not be removed from both nodes. If the DHCP lease could not be removed on either
     * node, please check the DHCP server status. Once the DHCP server status is UP,
     * please invoke the deletion API again to ensure the lease gets deleted from both
     * nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serverId (required)
     * @param ip IPv4 or IPv6 address (required)
     * @param mac MAC Address (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void delete(java.lang.String serverId, java.lang.String ip, java.lang.String mac, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete a single DHCP lease entry specified by ip and mac. The DHCP server
     * matches the DHCP lease with the given ip address and the mac address. The
     * matched lease entry will be deleted. If no lease matches, the request is
     * ignored. The DHCP lease to be deleted will be removed by the system from both
     * active and standby node. The system will report error if the DHCP lease could
     * not be removed from both nodes. If the DHCP lease could not be removed on either
     * node, please check the DHCP server status. Once the DHCP server status is UP,
     * please invoke the deletion API again to ensure the lease gets deleted from both
     * nodes.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serverId (required)
     * @param ip IPv4 or IPv6 address (required)
     * @param mac MAC Address (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void delete(java.lang.String serverId, java.lang.String ip, java.lang.String mac, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Get specific leases of a given dhcp server. As a dhcp server could manage
     * millions of leases, the API has to limit the number of the returned leases via
     * two mutually-excluded request parameters, i.e. \"pool_id\" and \"address\".
     * Either a \"pool_id\" or an \"address\" can be provided, but not both in a same
     * call. If a \"pool_id\" is specified, the leases of the specific pool are
     * returned. If an \"address\" is specified, only the lease(s) represented y this
     * address is(are) returned. The \"address\" can be a single IP, an ip-range, or a
     * mac address.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param serverId (required)
     * @param address can be an ip address, or an ip range, or a mac address (optional)
     * @param poolId The uuid of dhcp ip pool (optional)
     * @param source Data source type. (optional)
     * @return com.vmware.nsx.model.DhcpLeases
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpLeases list(java.lang.String serverId, java.lang.String address, java.lang.String poolId, java.lang.String source);

    /**
     * Get specific leases of a given dhcp server. As a dhcp server could manage
     * millions of leases, the API has to limit the number of the returned leases via
     * two mutually-excluded request parameters, i.e. \"pool_id\" and \"address\".
     * Either a \"pool_id\" or an \"address\" can be provided, but not both in a same
     * call. If a \"pool_id\" is specified, the leases of the specific pool are
     * returned. If an \"address\" is specified, only the lease(s) represented y this
     * address is(are) returned. The \"address\" can be a single IP, an ip-range, or a
     * mac address.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param serverId (required)
     * @param address can be an ip address, or an ip range, or a mac address (optional)
     * @param poolId The uuid of dhcp ip pool (optional)
     * @param source Data source type. (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.DhcpLeases
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.DhcpLeases list(java.lang.String serverId, java.lang.String address, java.lang.String poolId, java.lang.String source, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Get specific leases of a given dhcp server. As a dhcp server could manage
     * millions of leases, the API has to limit the number of the returned leases via
     * two mutually-excluded request parameters, i.e. \"pool_id\" and \"address\".
     * Either a \"pool_id\" or an \"address\" can be provided, but not both in a same
     * call. If a \"pool_id\" is specified, the leases of the specific pool are
     * returned. If an \"address\" is specified, only the lease(s) represented y this
     * address is(are) returned. The \"address\" can be a single IP, an ip-range, or a
     * mac address.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpLeases
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serverId (required)
     * @param address can be an ip address, or an ip range, or a mac address (optional)
     * @param poolId The uuid of dhcp ip pool (optional)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String serverId, java.lang.String address, java.lang.String poolId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpLeases> asyncCallback);

    /**
     * Get specific leases of a given dhcp server. As a dhcp server could manage
     * millions of leases, the API has to limit the number of the returned leases via
     * two mutually-excluded request parameters, i.e. \"pool_id\" and \"address\".
     * Either a \"pool_id\" or an \"address\" can be provided, but not both in a same
     * call. If a \"pool_id\" is specified, the leases of the specific pool are
     * returned. If an \"address\" is specified, only the lease(s) represented y this
     * address is(are) returned. The \"address\" can be a single IP, an ip-range, or a
     * mac address.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.DhcpLeases
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param serverId (required)
     * @param address can be an ip address, or an ip range, or a mac address (optional)
     * @param poolId The uuid of dhcp ip pool (optional)
     * @param source Data source type. (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String serverId, java.lang.String address, java.lang.String poolId, java.lang.String source, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.DhcpLeases> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
