/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.dns.forwarders.
 * Used by client-side stubs.
 */

package com.vmware.nsx.dns.forwarders;

public interface State extends com.vmware.vapi.bindings.Service, com.vmware.nsx.dns.forwarders.StateTypes {

    /**
     * Return the realized state information of a DNS forwarder. After a DNS forwarder
     * was created or updated, you can invoke this API to check the realization state
     * of the forwarder.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param forwarderId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @return com.vmware.nsx.model.ConfigurationState
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ConfigurationState get(java.lang.String forwarderId, java.lang.Long barrierId, java.lang.String requestId);

    /**
     * Return the realized state information of a DNS forwarder. After a DNS forwarder
     * was created or updated, you can invoke this API to check the realization state
     * of the forwarder.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param forwarderId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ConfigurationState
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.ConfigurationState get(java.lang.String forwarderId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return the realized state information of a DNS forwarder. After a DNS forwarder
     * was created or updated, you can invoke this API to check the realization state
     * of the forwarder.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ConfigurationState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param forwarderId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String forwarderId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ConfigurationState> asyncCallback);

    /**
     * Return the realized state information of a DNS forwarder. After a DNS forwarder
     * was created or updated, you can invoke this API to check the realization state
     * of the forwarder.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ConfigurationState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param forwarderId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String forwarderId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ConfigurationState> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
