/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.fabric.
 * Used by client-side stubs.
 */

package com.vmware.nsx.fabric;

public interface ComputeCollections extends com.vmware.vapi.bindings.Service, com.vmware.nsx.fabric.ComputeCollectionsTypes {

    /**
     * Perform action specific to NSX on the compute-collection. cc-ext-id should be of
     * type VC_Cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ccExtId (required)
     * @param action Supported actions on compute-collection (optional)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String ccExtId, java.lang.String action);

    /**
     * Perform action specific to NSX on the compute-collection. cc-ext-id should be of
     * type VC_Cluster.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ccExtId (required)
     * @param action Supported actions on compute-collection (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public void create(java.lang.String ccExtId, java.lang.String action, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Perform action specific to NSX on the compute-collection. cc-ext-id should be of
     * type VC_Cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ccExtId (required)
     * @param action Supported actions on compute-collection (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void create(java.lang.String ccExtId, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Perform action specific to NSX on the compute-collection. cc-ext-id should be of
     * type VC_Cluster.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ccExtId (required)
     * @param action Supported actions on compute-collection (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void create(java.lang.String ccExtId, java.lang.String action, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about a specific compute collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param ccExtId (required)
     * @return com.vmware.nsx.model.ComputeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ComputeCollection get(java.lang.String ccExtId);

    /**
     * Returns information about a specific compute collection.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param ccExtId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ComputeCollection
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ComputeCollection get(java.lang.String ccExtId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specific compute collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ComputeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ccExtId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String ccExtId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ComputeCollection> asyncCallback);

    /**
     * Returns information about a specific compute collection.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ComputeCollection
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param ccExtId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String ccExtId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ComputeCollection> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all compute collections.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param cmLocalId Local Id of the compute collection in the Compute Manager (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId Id of the discovered node which belongs to this Compute Collection (optional)
     * @param displayName Name of the ComputeCollection in source compute manager (optional)
     * @param externalId External ID of the ComputeCollection in the source Compute manager, e.g. mo-ref
     * in VC (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Id of the fabric node created from a discovered node belonging to this Compute
     * Collection (optional)
     * @param originId Id of the compute manager from where this Compute Collection was discovered
     * (optional)
     * @param originType ComputeCollection type like VC_Cluster. Here the Compute Manager type prefix
     * would help in differentiating similar named Compute Collection types from
     * different Compute Managers (optional)
     * @param ownerId Id of the owner of compute collection in the Compute Manager (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.ComputeCollectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ComputeCollectionListResult list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.String displayName, java.lang.String externalId, java.lang.String includedFields, java.lang.String nodeId, java.lang.String originId, java.lang.String originType, java.lang.String ownerId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about all compute collections.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param cmLocalId Local Id of the compute collection in the Compute Manager (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId Id of the discovered node which belongs to this Compute Collection (optional)
     * @param displayName Name of the ComputeCollection in source compute manager (optional)
     * @param externalId External ID of the ComputeCollection in the source Compute manager, e.g. mo-ref
     * in VC (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Id of the fabric node created from a discovered node belonging to this Compute
     * Collection (optional)
     * @param originId Id of the compute manager from where this Compute Collection was discovered
     * (optional)
     * @param originType ComputeCollection type like VC_Cluster. Here the Compute Manager type prefix
     * would help in differentiating similar named Compute Collection types from
     * different Compute Managers (optional)
     * @param ownerId Id of the owner of compute collection in the Compute Manager (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ComputeCollectionListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ComputeCollectionListResult list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.String displayName, java.lang.String externalId, java.lang.String includedFields, java.lang.String nodeId, java.lang.String originId, java.lang.String originType, java.lang.String ownerId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all compute collections.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ComputeCollectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cmLocalId Local Id of the compute collection in the Compute Manager (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId Id of the discovered node which belongs to this Compute Collection (optional)
     * @param displayName Name of the ComputeCollection in source compute manager (optional)
     * @param externalId External ID of the ComputeCollection in the source Compute manager, e.g. mo-ref
     * in VC (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Id of the fabric node created from a discovered node belonging to this Compute
     * Collection (optional)
     * @param originId Id of the compute manager from where this Compute Collection was discovered
     * (optional)
     * @param originType ComputeCollection type like VC_Cluster. Here the Compute Manager type prefix
     * would help in differentiating similar named Compute Collection types from
     * different Compute Managers (optional)
     * @param ownerId Id of the owner of compute collection in the Compute Manager (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.String displayName, java.lang.String externalId, java.lang.String includedFields, java.lang.String nodeId, java.lang.String originId, java.lang.String originType, java.lang.String ownerId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ComputeCollectionListResult> asyncCallback);

    /**
     * Returns information about all compute collections.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ComputeCollectionListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param cmLocalId Local Id of the compute collection in the Compute Manager (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param discoveredNodeId Id of the discovered node which belongs to this Compute Collection (optional)
     * @param displayName Name of the ComputeCollection in source compute manager (optional)
     * @param externalId External ID of the ComputeCollection in the source Compute manager, e.g. mo-ref
     * in VC (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param nodeId Id of the fabric node created from a discovered node belonging to this Compute
     * Collection (optional)
     * @param originId Id of the compute manager from where this Compute Collection was discovered
     * (optional)
     * @param originType ComputeCollection type like VC_Cluster. Here the Compute Manager type prefix
     * would help in differentiating similar named Compute Collection types from
     * different Compute Managers (optional)
     * @param ownerId Id of the owner of compute collection in the Compute Manager (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String cmLocalId, java.lang.String cursor, java.lang.String discoveredNodeId, java.lang.String displayName, java.lang.String externalId, java.lang.String includedFields, java.lang.String nodeId, java.lang.String originId, java.lang.String originType, java.lang.String ownerId, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ComputeCollectionListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
