/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.fabric.
 * Used by client-side stubs.
 */

package com.vmware.nsx.fabric;

public interface ContainerClusters extends com.vmware.vapi.bindings.Service, com.vmware.nsx.fabric.ContainerClustersTypes {

    /**
     * Returns information about a specific container cluster
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param containerClusterId (required)
     * @return com.vmware.nsx.model.ContainerCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ContainerCluster get(java.lang.String containerClusterId);

    /**
     * Returns information about a specific container cluster
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param containerClusterId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ContainerCluster
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ContainerCluster get(java.lang.String containerClusterId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about a specific container cluster
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ContainerCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param containerClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String containerClusterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ContainerCluster> asyncCallback);

    /**
     * Returns information about a specific container cluster
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ContainerCluster
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param containerClusterId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String containerClusterId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ContainerCluster> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all Container Clusters.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param clusterType Type of container cluster (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param infraType Type of infrastructure (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param scopeId Scope id for container cluster (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.ContainerClusterListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ContainerClusterListResult list(java.lang.String clusterType, java.lang.String cursor, java.lang.String includedFields, java.lang.String infraType, java.lang.Long pageSize, java.lang.String scopeId, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about all Container Clusters.
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param clusterType Type of container cluster (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param infraType Type of infrastructure (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param scopeId Scope id for container cluster (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.ContainerClusterListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.ContainerClusterListResult list(java.lang.String clusterType, java.lang.String cursor, java.lang.String includedFields, java.lang.String infraType, java.lang.Long pageSize, java.lang.String scopeId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all Container Clusters.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ContainerClusterListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusterType Type of container cluster (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param infraType Type of infrastructure (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param scopeId Scope id for container cluster (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String clusterType, java.lang.String cursor, java.lang.String includedFields, java.lang.String infraType, java.lang.Long pageSize, java.lang.String scopeId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ContainerClusterListResult> asyncCallback);

    /**
     * Returns information about all Container Clusters.
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.ContainerClusterListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param clusterType Type of container cluster (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param infraType Type of infrastructure (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param scopeId Scope id for container cluster (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String clusterType, java.lang.String cursor, java.lang.String includedFields, java.lang.String infraType, java.lang.Long pageSize, java.lang.String scopeId, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.ContainerClusterListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
