
/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 */


package com.vmware.nsx.fabric;

/**
 * {@link FabricFactory} is responsible for creating instances of services
 * contained inside the com.vmware.nsx.fabric package and also has the subpackages reference
 * to access respective subpackage services.
 * <p>
*/
public class FabricFactory {

    private com.vmware.vapi.bindings.StubFactory stubFactory;
    private com.vmware.vapi.bindings.StubConfiguration stubConfig;

    // restricting developers to create instance of this class directly
    private FabricFactory() {

    }

    /**
     * Creates the new instance of this class with provided configuration
     * @param stubFactory {@link StubFactory} instance is responsible for creating stubs
     * @param stubConfig {@link StubConfiguration} instance is required to authenticate the request
     * @return {@link FabricFactory} factory instance
     */
    public static FabricFactory getFactory(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        FabricFactory instance = new FabricFactory();
        instance.stubFactory = stubFactory;
        instance.stubConfig = stubConfig;
        return instance;
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.CloudNativeServiceInstances}
     */
    public com.vmware.nsx.fabric.CloudNativeServiceInstances cloudNativeServiceInstancesService() {
        return this.stubFactory.createStub(CloudNativeServiceInstances.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ComputeCollections}
     */
    public com.vmware.nsx.fabric.ComputeCollections computeCollectionsService() {
        return this.stubFactory.createStub(ComputeCollections.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ComputeManagers}
     */
    public com.vmware.nsx.fabric.ComputeManagers computeManagersService() {
        return this.stubFactory.createStub(ComputeManagers.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerApplicationInstances}
     */
    public com.vmware.nsx.fabric.ContainerApplicationInstances containerApplicationInstancesService() {
        return this.stubFactory.createStub(ContainerApplicationInstances.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerApplications}
     */
    public com.vmware.nsx.fabric.ContainerApplications containerApplicationsService() {
        return this.stubFactory.createStub(ContainerApplications.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerClusterNodes}
     */
    public com.vmware.nsx.fabric.ContainerClusterNodes containerClusterNodesService() {
        return this.stubFactory.createStub(ContainerClusterNodes.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerClusters}
     */
    public com.vmware.nsx.fabric.ContainerClusters containerClustersService() {
        return this.stubFactory.createStub(ContainerClusters.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerEgress}
     */
    public com.vmware.nsx.fabric.ContainerEgress containerEgressService() {
        return this.stubFactory.createStub(ContainerEgress.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerEgresses}
     */
    public com.vmware.nsx.fabric.ContainerEgresses containerEgressesService() {
        return this.stubFactory.createStub(ContainerEgresses.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerGateway}
     */
    public com.vmware.nsx.fabric.ContainerGateway containerGatewayService() {
        return this.stubFactory.createStub(ContainerGateway.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerGateways}
     */
    public com.vmware.nsx.fabric.ContainerGateways containerGatewaysService() {
        return this.stubFactory.createStub(ContainerGateways.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerIngressPolicies}
     */
    public com.vmware.nsx.fabric.ContainerIngressPolicies containerIngressPoliciesService() {
        return this.stubFactory.createStub(ContainerIngressPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerIpPool}
     */
    public com.vmware.nsx.fabric.ContainerIpPool containerIpPoolService() {
        return this.stubFactory.createStub(ContainerIpPool.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerIpPools}
     */
    public com.vmware.nsx.fabric.ContainerIpPools containerIpPoolsService() {
        return this.stubFactory.createStub(ContainerIpPools.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerNetworkPolicies}
     */
    public com.vmware.nsx.fabric.ContainerNetworkPolicies containerNetworkPoliciesService() {
        return this.stubFactory.createStub(ContainerNetworkPolicies.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ContainerProjects}
     */
    public com.vmware.nsx.fabric.ContainerProjects containerProjectsService() {
        return this.stubFactory.createStub(ContainerProjects.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.DiscoveredNodes}
     */
    public com.vmware.nsx.fabric.DiscoveredNodes discoveredNodesService() {
        return this.stubFactory.createStub(DiscoveredNodes.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.Ostypes}
     */
    public com.vmware.nsx.fabric.Ostypes ostypesService() {
        return this.stubFactory.createStub(Ostypes.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.PhysicalServers}
     */
    public com.vmware.nsx.fabric.PhysicalServers physicalServersService() {
        return this.stubFactory.createStub(PhysicalServers.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.ScopeAssociations}
     */
    public com.vmware.nsx.fabric.ScopeAssociations scopeAssociationsService() {
        return this.stubFactory.createStub(ScopeAssociations.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.Vifs}
     */
    public com.vmware.nsx.fabric.Vifs vifsService() {
        return this.stubFactory.createStub(Vifs.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.VirtualMachines}
     */
    public com.vmware.nsx.fabric.VirtualMachines virtualMachinesService() {
        return this.stubFactory.createStub(VirtualMachines.class, this.stubConfig);
    }

    /**
     * Returns an instance of class {@link com.vmware.nsx.fabric.VirtualSwitches}
     */
    public com.vmware.nsx.fabric.VirtualSwitches virtualSwitchesService() {
        return this.stubFactory.createStub(VirtualSwitches.class, this.stubConfig);
    }

    public com.vmware.nsx.fabric.compute_collections.ComputeCollectionsFactory computeCollections() {
        return com.vmware.nsx.fabric.compute_collections.ComputeCollectionsFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.fabric.compute_managers.ComputeManagersFactory computeManagers() {
        return com.vmware.nsx.fabric.compute_managers.ComputeManagersFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public com.vmware.nsx.fabric.virtual_machines.VirtualMachinesFactory virtualMachines() {
        return com.vmware.nsx.fabric.virtual_machines.VirtualMachinesFactory.getFactory(this.stubFactory, this.stubConfig);
    }

    public void updateStubConfiguration(com.vmware.vapi.bindings.StubFactory stubFactory, com.vmware.vapi.bindings.StubConfiguration stubConfig) {
        if (this.stubFactory == stubFactory && this.stubConfig == stubConfig)
            return;

        this.stubFactory = stubFactory;
        this.stubConfig = stubConfig;
    }

}
