/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.firewall.sections.
 * Used by client-side stubs.
 */

package com.vmware.nsx.firewall.sections;

public interface Rules extends com.vmware.vapi.bindings.Service, com.vmware.nsx.firewall.sections.RulesTypes {

    /**
     * Adds a new firewall rule in existing firewall section. Adding firewall rule to a
     * section modifies parent section entity and simultaneous update (modify)
     * operations on same section are not allowed to prevent overwriting stale content
     * to firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param firewallRule (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.FirewallRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRule create(java.lang.String sectionId, com.vmware.nsx.model.FirewallRule firewallRule, java.lang.String id, java.lang.String operation);

    /**
     * Adds a new firewall rule in existing firewall section. Adding firewall rule to a
     * section modifies parent section entity and simultaneous update (modify)
     * operations on same section are not allowed to prevent overwriting stale content
     * to firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param firewallRule (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRule create(java.lang.String sectionId, com.vmware.nsx.model.FirewallRule firewallRule, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Adds a new firewall rule in existing firewall section. Adding firewall rule to a
     * section modifies parent section entity and simultaneous update (modify)
     * operations on same section are not allowed to prevent overwriting stale content
     * to firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallRule (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.String sectionId, com.vmware.nsx.model.FirewallRule firewallRule, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRule> asyncCallback);

    /**
     * Adds a new firewall rule in existing firewall section. Adding firewall rule to a
     * section modifies parent section entity and simultaneous update (modify)
     * operations on same section are not allowed to prevent overwriting stale content
     * to firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallRule (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.String sectionId, com.vmware.nsx.model.FirewallRule firewallRule, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRule> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Create multiple firewall rules in existing firewall section bounded by limit of
     * 1000 firewall rules per section. Adding multiple firewall rules in a section
     * modifies parent section entity and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param firewallRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.FirewallRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRuleList createmultiple(java.lang.String sectionId, com.vmware.nsx.model.FirewallRuleList firewallRuleList, java.lang.String id, java.lang.String operation);

    /**
     * Create multiple firewall rules in existing firewall section bounded by limit of
     * 1000 firewall rules per section. Adding multiple firewall rules in a section
     * modifies parent section entity and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param firewallRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallRuleList
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRuleList createmultiple(java.lang.String sectionId, com.vmware.nsx.model.FirewallRuleList firewallRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Create multiple firewall rules in existing firewall section bounded by limit of
     * 1000 firewall rules per section. Adding multiple firewall rules in a section
     * modifies parent section entity and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void createmultiple(java.lang.String sectionId, com.vmware.nsx.model.FirewallRuleList firewallRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRuleList> asyncCallback);

    /**
     * Create multiple firewall rules in existing firewall section bounded by limit of
     * 1000 firewall rules per section. Adding multiple firewall rules in a section
     * modifies parent section entity and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRuleList
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param firewallRuleList (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void createmultiple(java.lang.String sectionId, com.vmware.nsx.model.FirewallRuleList firewallRuleList, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRuleList> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Delete existing firewall rule in a firewall section. Deleting firewall rule in a
     * section modifies parent section and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> DELETE
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.String ruleId);

    /**
     * Delete existing firewall rule in a firewall section. Deleting firewall rule in a
     * section modifies parent section and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> DELETE
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.String ruleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Delete existing firewall rule in a firewall section. Deleting firewall rule in a
     * section modifies parent section and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> DELETE
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.String ruleId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Delete existing firewall rule in a firewall section. Deleting firewall rule in a
     * section modifies parent section and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> DELETE
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String sectionId, java.lang.String ruleId, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return existing firewall rule information in a firewall section. <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @return com.vmware.nsx.model.FirewallRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRule get(java.lang.String sectionId, java.lang.String ruleId);

    /**
     * Return existing firewall rule information in a firewall section. <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRule get(java.lang.String sectionId, java.lang.String ruleId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return existing firewall rule information in a firewall section. <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String sectionId, java.lang.String ruleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRule> asyncCallback);

    /**
     * Return existing firewall rule information in a firewall section. <br/> <br/> Use
     * the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String sectionId, java.lang.String ruleId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRule> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Return all firewall rule(s) information for a given firewall section. <br/>
     * <br/> Use the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param contextProfiles Limits results to sections having rules with specific Context Profiles.
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deepSearch Toggle to search with direct or indirect references. (optional, default to
     * false)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param extendedSources Limits results to sections having rules with specific Extended Sources.
     * (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param searchInvalidReferences Return invalid references in results. (optional, default to false)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @return com.vmware.nsx.model.FirewallRuleListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRuleListResult list(java.lang.String sectionId, java.lang.String appliedTos, java.lang.String contextProfiles, java.lang.String cursor, java.lang.Boolean deepSearch, java.lang.String destinations, java.lang.String extendedSources, java.lang.String filterType, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean searchInvalidReferences, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources);

    /**
     * Return all firewall rule(s) information for a given firewall section. <br/>
     * <br/> Use the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param contextProfiles Limits results to sections having rules with specific Context Profiles.
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deepSearch Toggle to search with direct or indirect references. (optional, default to
     * false)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param extendedSources Limits results to sections having rules with specific Extended Sources.
     * (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param searchInvalidReferences Return invalid references in results. (optional, default to false)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallRuleListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRuleListResult list(java.lang.String sectionId, java.lang.String appliedTos, java.lang.String contextProfiles, java.lang.String cursor, java.lang.Boolean deepSearch, java.lang.String destinations, java.lang.String extendedSources, java.lang.String filterType, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean searchInvalidReferences, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return all firewall rule(s) information for a given firewall section. <br/>
     * <br/> Use the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRuleListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param contextProfiles Limits results to sections having rules with specific Context Profiles.
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deepSearch Toggle to search with direct or indirect references. (optional, default to
     * false)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param extendedSources Limits results to sections having rules with specific Extended Sources.
     * (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param searchInvalidReferences Return invalid references in results. (optional, default to false)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String sectionId, java.lang.String appliedTos, java.lang.String contextProfiles, java.lang.String cursor, java.lang.Boolean deepSearch, java.lang.String destinations, java.lang.String extendedSources, java.lang.String filterType, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean searchInvalidReferences, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRuleListResult> asyncCallback);

    /**
     * Return all firewall rule(s) information for a given firewall section. <br/>
     * <br/> Use the following Policy API - <br/> GET
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRuleListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param appliedTos AppliedTo's referenced by this section or section's Distributed Service Rules .
     * (optional)
     * @param contextProfiles Limits results to sections having rules with specific Context Profiles.
     * (optional)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param deepSearch Toggle to search with direct or indirect references. (optional, default to
     * false)
     * @param destinations Destinations referenced by this section's Distributed Service Rules . (optional)
     * @param extendedSources Limits results to sections having rules with specific Extended Sources.
     * (optional)
     * @param filterType Filter type (optional, default to FILTER)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param searchInvalidReferences Return invalid references in results. (optional, default to false)
     * @param services NSService referenced by this section's Distributed Service Rules . (optional)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param sources Sources referenced by this section's Distributed Service Rules . (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String sectionId, java.lang.String appliedTos, java.lang.String contextProfiles, java.lang.String cursor, java.lang.Boolean deepSearch, java.lang.String destinations, java.lang.String extendedSources, java.lang.String filterType, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean searchInvalidReferences, java.lang.String services, java.lang.Boolean sortAscending, java.lang.String sortBy, java.lang.String sources, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRuleListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies existing firewall rule along with relative position among other
     * firewall rules inside a firewall section. Revising firewall rule in a section
     * modifies parent section entity and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>?action=revise
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param firewallRule (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @return com.vmware.nsx.model.FirewallRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRule revise(java.lang.String sectionId, java.lang.String ruleId, com.vmware.nsx.model.FirewallRule firewallRule, java.lang.String id, java.lang.String operation);

    /**
     * Modifies existing firewall rule along with relative position among other
     * firewall rules inside a firewall section. Revising firewall rule in a section
     * modifies parent section entity and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>?action=revise
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param firewallRule (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRule revise(java.lang.String sectionId, java.lang.String ruleId, com.vmware.nsx.model.FirewallRule firewallRule, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies existing firewall rule along with relative position among other
     * firewall rules inside a firewall section. Revising firewall rule in a section
     * modifies parent section entity and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>?action=revise
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param firewallRule (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void revise(java.lang.String sectionId, java.lang.String ruleId, com.vmware.nsx.model.FirewallRule firewallRule, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRule> asyncCallback);

    /**
     * Modifies existing firewall rule along with relative position among other
     * firewall rules inside a firewall section. Revising firewall rule in a section
     * modifies parent section entity and simultaneous update (modify) operations on
     * same section are not allowed to prevent overwriting stale contents to firewall
     * section. If a concurrent update is performed, HTTP response code 409 will be
     * returned to the client operating on stale data. That client should retrieve the
     * firewall section again and re-apply its update. <br/> <br/> Use the following
     * Policy API - <br/> POST
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>?action=revise
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param firewallRule (required)
     * @param id Identifier of the anchor rule or section. This is a required field in case
     * operation like 'insert_before' and 'insert_after'. (optional)
     * @param operation Operation (optional, default to insert_top)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void revise(java.lang.String sectionId, java.lang.String ruleId, com.vmware.nsx.model.FirewallRule firewallRule, java.lang.String id, java.lang.String operation, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRule> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies existing firewall rule in a firewall section. Updating firewall rule in
     * a section modifies parent section entity and simultaneous update (modify)
     * operations on same section are not allowed to prevent overwriting stale contents
     * to firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param firewallRule (required)
     * @return com.vmware.nsx.model.FirewallRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRule update(java.lang.String sectionId, java.lang.String ruleId, com.vmware.nsx.model.FirewallRule firewallRule);

    /**
     * Modifies existing firewall rule in a firewall section. Updating firewall rule in
     * a section modifies parent section entity and simultaneous update (modify)
     * operations on same section are not allowed to prevent overwriting stale contents
     * to firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param firewallRule (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.FirewallRule
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.FirewallRule update(java.lang.String sectionId, java.lang.String ruleId, com.vmware.nsx.model.FirewallRule firewallRule, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies existing firewall rule in a firewall section. Updating firewall rule in
     * a section modifies parent section entity and simultaneous update (modify)
     * operations on same section are not allowed to prevent overwriting stale contents
     * to firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param firewallRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String sectionId, java.lang.String ruleId, com.vmware.nsx.model.FirewallRule firewallRule, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRule> asyncCallback);

    /**
     * Modifies existing firewall rule in a firewall section. Updating firewall rule in
     * a section modifies parent section entity and simultaneous update (modify)
     * operations on same section are not allowed to prevent overwriting stale contents
     * to firewall section. If a concurrent update is performed, HTTP response code 409
     * will be returned to the client operating on stale data. That client should
     * retrieve the firewall section again and re-apply its update. <br/> <br/> Use the
     * following Policy API - <br/> PUT|PATCH
     * /policy/api/v1/infra/domains/<domain-id>/security-policies/<security-policy-id>/rules/<rule-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.FirewallRule
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param sectionId (required)
     * @param ruleId (required)
     * @param firewallRule (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String sectionId, java.lang.String ruleId, com.vmware.nsx.model.FirewallRule firewallRule, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.FirewallRule> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
