/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.lldp.fabric_nodes.
 * Used by client-side stubs.
 */

package com.vmware.nsx.lldp.fabric_nodes;

public interface Interfaces extends com.vmware.vapi.bindings.Service, com.vmware.nsx.lldp.fabric_nodes.InterfacesTypes {

    /**
     * Read LLDP Neighbor Properties for a specific interface of Fabric Node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param fabricNodeId ID of fabric node (required)
     * @param interfaceName Interface name to read (required)
     * @return com.vmware.nsx.model.InterfaceNeighborProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.InterfaceNeighborProperties get(java.lang.String fabricNodeId, java.lang.String interfaceName);

    /**
     * Read LLDP Neighbor Properties for a specific interface of Fabric Node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param fabricNodeId ID of fabric node (required)
     * @param interfaceName Interface name to read (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.InterfaceNeighborProperties
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.InterfaceNeighborProperties get(java.lang.String fabricNodeId, java.lang.String interfaceName, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read LLDP Neighbor Properties for a specific interface of Fabric Node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InterfaceNeighborProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param fabricNodeId ID of fabric node (required)
     * @param interfaceName Interface name to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void get(java.lang.String fabricNodeId, java.lang.String interfaceName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InterfaceNeighborProperties> asyncCallback);

    /**
     * Read LLDP Neighbor Properties for a specific interface of Fabric Node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InterfaceNeighborProperties
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param fabricNodeId ID of fabric node (required)
     * @param interfaceName Interface name to read (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void get(java.lang.String fabricNodeId, java.lang.String interfaceName, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InterfaceNeighborProperties> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * List LLDP Neighbor Properties for all interfaces of Fabric Node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param fabricNodeId ID of fabric node (required)
     * @return com.vmware.nsx.model.InterfaceNeighborPropertyListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.InterfaceNeighborPropertyListResult list(java.lang.String fabricNodeId);

    /**
     * List LLDP Neighbor Properties for all interfaces of Fabric Node
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param fabricNodeId ID of fabric node (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.InterfaceNeighborPropertyListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    public com.vmware.nsx.model.InterfaceNeighborPropertyListResult list(java.lang.String fabricNodeId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * List LLDP Neighbor Properties for all interfaces of Fabric Node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InterfaceNeighborPropertyListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param fabricNodeId ID of fabric node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    public void list(java.lang.String fabricNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InterfaceNeighborPropertyListResult> asyncCallback);

    /**
     * List LLDP Neighbor Properties for all interfaces of Fabric Node
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.InterfaceNeighborPropertyListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param fabricNodeId ID of fabric node (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    public void list(java.lang.String fabricNodeId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.InterfaceNeighborPropertyListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
