/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_router_ports.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_router_ports;

public interface State extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_router_ports.StateTypes {

    /**
     * Return realized state information of a logical router port. Any configuration
     * update that affects the logical router port can use this API to get its realized
     * state by passing a request_id returned by the configuration change operation.
     * e.g. Update configuration of logical router ports, dhcp relays, etc. <br/> <br/>
     * To get all realized entities for the intent use below Policy API. <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entities?intent_path=<intent-path>
     * <br/> For realized status of the intent use below Policy API. <br/> GET
     * /policy/api/v1/infra/realized-state/status?intent_path=<intent-path> <br/>
     * <intent-path> can be one of the following. <br/>
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/>
     * /infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> /infra/tier-1s/<tier-1-id>/segments/<segment-id> for DOWNLINK <br/>
     * /infra/segments/<segment-id> for DOWNLINK <br/> There are specific Policy APIs
     * to get Segment state. <br/> GET /policy/api/v1/infra/segments/<segment-id>/state
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/state
     * <br/> For DAD status use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/segments/<segment-id>/gateway-interface-dad-state <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/gateway-interface-dad-state
     * <br/> For DAD status of all interfaces created on Gateway use below Policy APIs.
     * <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/state <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/state
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterPortId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @return com.vmware.nsx.model.LogicalRouterPortState
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterPortState get(java.lang.String logicalRouterPortId, java.lang.Long barrierId, java.lang.String requestId);

    /**
     * Return realized state information of a logical router port. Any configuration
     * update that affects the logical router port can use this API to get its realized
     * state by passing a request_id returned by the configuration change operation.
     * e.g. Update configuration of logical router ports, dhcp relays, etc. <br/> <br/>
     * To get all realized entities for the intent use below Policy API. <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entities?intent_path=<intent-path>
     * <br/> For realized status of the intent use below Policy API. <br/> GET
     * /policy/api/v1/infra/realized-state/status?intent_path=<intent-path> <br/>
     * <intent-path> can be one of the following. <br/>
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/>
     * /infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> /infra/tier-1s/<tier-1-id>/segments/<segment-id> for DOWNLINK <br/>
     * /infra/segments/<segment-id> for DOWNLINK <br/> There are specific Policy APIs
     * to get Segment state. <br/> GET /policy/api/v1/infra/segments/<segment-id>/state
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/state
     * <br/> For DAD status use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/segments/<segment-id>/gateway-interface-dad-state <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/gateway-interface-dad-state
     * <br/> For DAD status of all interfaces created on Gateway use below Policy APIs.
     * <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/state <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/state
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterPortId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.LogicalRouterPortState
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.LogicalRouterPortState get(java.lang.String logicalRouterPortId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Return realized state information of a logical router port. Any configuration
     * update that affects the logical router port can use this API to get its realized
     * state by passing a request_id returned by the configuration change operation.
     * e.g. Update configuration of logical router ports, dhcp relays, etc. <br/> <br/>
     * To get all realized entities for the intent use below Policy API. <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entities?intent_path=<intent-path>
     * <br/> For realized status of the intent use below Policy API. <br/> GET
     * /policy/api/v1/infra/realized-state/status?intent_path=<intent-path> <br/>
     * <intent-path> can be one of the following. <br/>
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/>
     * /infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> /infra/tier-1s/<tier-1-id>/segments/<segment-id> for DOWNLINK <br/>
     * /infra/segments/<segment-id> for DOWNLINK <br/> There are specific Policy APIs
     * to get Segment state. <br/> GET /policy/api/v1/infra/segments/<segment-id>/state
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/state
     * <br/> For DAD status use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/segments/<segment-id>/gateway-interface-dad-state <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/gateway-interface-dad-state
     * <br/> For DAD status of all interfaces created on Gateway use below Policy APIs.
     * <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/state <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/state
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPortState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterPortId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterPortState> asyncCallback);

    /**
     * Return realized state information of a logical router port. Any configuration
     * update that affects the logical router port can use this API to get its realized
     * state by passing a request_id returned by the configuration change operation.
     * e.g. Update configuration of logical router ports, dhcp relays, etc. <br/> <br/>
     * To get all realized entities for the intent use below Policy API. <br/> GET
     * /policy/api/v1/infra/realized-state/realized-entities?intent_path=<intent-path>
     * <br/> For realized status of the intent use below Policy API. <br/> GET
     * /policy/api/v1/infra/realized-state/status?intent_path=<intent-path> <br/>
     * <intent-path> can be one of the following. <br/>
     * /infra/tier-0s/<tier-0-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/>
     * /infra/tier-1s/<tier-1-id>/locale-services/<locale-service-id>/interfaces/<interface-id>
     * <br/> /infra/tier-1s/<tier-1-id>/segments/<segment-id> for DOWNLINK <br/>
     * /infra/segments/<segment-id> for DOWNLINK <br/> There are specific Policy APIs
     * to get Segment state. <br/> GET /policy/api/v1/infra/segments/<segment-id>/state
     * <br/> GET /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/state
     * <br/> For DAD status use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/segments/<segment-id>/gateway-interface-dad-state <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/segments/<segment-id>/gateway-interface-dad-state
     * <br/> For DAD status of all interfaces created on Gateway use below Policy APIs.
     * <br/> GET /policy/api/v1/infra/tier-0s/<tier-0-id>/state <br/> GET
     * /policy/api/v1/infra/tier-1s/<tier-1-id>/state
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.LogicalRouterPortState
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterPortId (required)
     * @param barrierId (optional)
     * @param requestId Realization request ID (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterPortId, java.lang.Long barrierId, java.lang.String requestId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.LogicalRouterPortState> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
