/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Interface file for package: com.vmware.nsx.logical_routers.routing.static_routes.
 * Used by client-side stubs.
 */

package com.vmware.nsx.logical_routers.routing.static_routes;

public interface BfdPeers extends com.vmware.vapi.bindings.Service, com.vmware.nsx.logical_routers.routing.static_routes.BfdPeersTypes {

    /**
     * Creates a BFD peer for static route. The required parameters includes peer IP
     * address. <br/> <br/> Please use below Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param staticHopBfdPeer (required)
     * @return com.vmware.nsx.model.StaticHopBfdPeer
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticHopBfdPeer create(java.lang.String logicalRouterId, com.vmware.nsx.model.StaticHopBfdPeer staticHopBfdPeer);

    /**
     * Creates a BFD peer for static route. The required parameters includes peer IP
     * address. <br/> <br/> Please use below Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param staticHopBfdPeer (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.StaticHopBfdPeer
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticHopBfdPeer create(java.lang.String logicalRouterId, com.vmware.nsx.model.StaticHopBfdPeer staticHopBfdPeer, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Creates a BFD peer for static route. The required parameters includes peer IP
     * address. <br/> <br/> Please use below Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticHopBfdPeer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param staticHopBfdPeer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void create(java.lang.String logicalRouterId, com.vmware.nsx.model.StaticHopBfdPeer staticHopBfdPeer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticHopBfdPeer> asyncCallback);

    /**
     * Creates a BFD peer for static route. The required parameters includes peer IP
     * address. <br/> <br/> Please use below Policy APIs. <br/> POST
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticHopBfdPeer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param staticHopBfdPeer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void create(java.lang.String logicalRouterId, com.vmware.nsx.model.StaticHopBfdPeer staticHopBfdPeer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticHopBfdPeer> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Deletes the specified BFD peer present on specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String bfdPeerId, java.lang.Boolean force);

    /**
     * Deletes the specified BFD peer present on specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param invocationConfig Configuration for the method invocation.
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String bfdPeerId, java.lang.Boolean force, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Deletes the specified BFD peer present on specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String bfdPeerId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback);

    /**
     * Deletes the specified BFD peer present on specified logical router. <br/> <br/>
     * Please use below Policy APIs. <br/> DELETE
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param force Force delete the resource even if it is being used somewhere (optional, default
     * to false)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void delete(java.lang.String logicalRouterId, java.lang.String bfdPeerId, java.lang.Boolean force, com.vmware.vapi.bindings.client.AsyncCallback<java.lang.Void> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Read the BFD peer having specified ID. <br/> <br/> Please use below Policy APIs.
     * <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @return com.vmware.nsx.model.StaticHopBfdPeer
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticHopBfdPeer get(java.lang.String logicalRouterId, java.lang.String bfdPeerId);

    /**
     * Read the BFD peer having specified ID. <br/> <br/> Please use below Policy APIs.
     * <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.StaticHopBfdPeer
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticHopBfdPeer get(java.lang.String logicalRouterId, java.lang.String bfdPeerId, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Read the BFD peer having specified ID. <br/> <br/> Please use below Policy APIs.
     * <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticHopBfdPeer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.String bfdPeerId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticHopBfdPeer> asyncCallback);

    /**
     * Read the BFD peer having specified ID. <br/> <br/> Please use below Policy APIs.
     * <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticHopBfdPeer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void get(java.lang.String logicalRouterId, java.lang.String bfdPeerId, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticHopBfdPeer> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Returns information about all BFD peers created on specified logical router for
     * static routes. <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @return com.vmware.nsx.model.StaticHopBfdPeerListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticHopBfdPeerListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy);

    /**
     * Returns information about all BFD peers created on specified logical router for
     * static routes. <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.StaticHopBfdPeerListResult
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticHopBfdPeerListResult list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Returns information about all BFD peers created on specified logical router for
     * static routes. <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticHopBfdPeerListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticHopBfdPeerListResult> asyncCallback);

    /**
     * Returns information about all BFD peers created on specified logical router for
     * static routes. <br/> <br/> Please use below Policy APIs. <br/> GET
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticHopBfdPeerListResult
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param cursor Opaque cursor to be used for getting next page of records (supplied by current
     * result page) (optional)
     * @param includedFields Comma separated list of fields that should be included in query result
     * (optional)
     * @param pageSize Maximum number of results to return in this page (server may return fewer)
     * (optional, default to 1000)
     * @param sortAscending (optional)
     * @param sortBy Field by which records are sorted (optional)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void list(java.lang.String logicalRouterId, java.lang.String cursor, java.lang.String includedFields, java.lang.Long pageSize, java.lang.Boolean sortAscending, java.lang.String sortBy, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticHopBfdPeerListResult> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

    /**
     * Modifies the static route BFD peer. Modifiable parameters includes peer IP,
     * enable flag and configuration of the BFD peer. <br/> <br/> Please use below
     * Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param staticHopBfdPeer (required)
     * @return com.vmware.nsx.model.StaticHopBfdPeer
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticHopBfdPeer update(java.lang.String logicalRouterId, java.lang.String bfdPeerId, com.vmware.nsx.model.StaticHopBfdPeer staticHopBfdPeer);

    /**
     * Modifies the static route BFD peer. Modifiable parameters includes peer IP,
     * enable flag and configuration of the BFD peer. <br/> <br/> Please use below
     * Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Synchronous method overload. Result of the invocation will be
     * reported as a method return value.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param staticHopBfdPeer (required)
     * @param invocationConfig Configuration for the method invocation.
     * @return com.vmware.nsx.model.StaticHopBfdPeer
     * @throws com.vmware.vapi.std.errors.InvalidRequest Bad Request, Precondition Failed
     * @throws com.vmware.vapi.std.errors.Unauthorized Forbidden
     * @throws com.vmware.vapi.std.errors.ServiceUnavailable Service Unavailable
     * @throws com.vmware.vapi.std.errors.InternalServerError Internal Server Error
     * @throws com.vmware.vapi.std.errors.NotFound Not Found
     */
    @Deprecated
    public com.vmware.nsx.model.StaticHopBfdPeer update(java.lang.String logicalRouterId, java.lang.String bfdPeerId, com.vmware.nsx.model.StaticHopBfdPeer staticHopBfdPeer, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);


    /**
     * Modifies the static route BFD peer. Modifiable parameters includes peer IP,
     * enable flag and configuration of the BFD peer. <br/> <br/> Please use below
     * Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticHopBfdPeer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param staticHopBfdPeer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, java.lang.String bfdPeerId, com.vmware.nsx.model.StaticHopBfdPeer staticHopBfdPeer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticHopBfdPeer> asyncCallback);

    /**
     * Modifies the static route BFD peer. Modifiable parameters includes peer IP,
     * enable flag and configuration of the BFD peer. <br/> <br/> Please use below
     * Policy APIs. <br/> PUT
     * /policy/api/v1/infra/tier-0s/<tier-0-id>/static-routes/bfd-peers/<bfd-peer-id>
     *
     * <p>Asynchronous method overload. Result of the invocation will be
     * reported via the specified {@code asyncCallback}.
     * Use {@code invocationConfig} to specify configuration for this particular invocation.
     *
     * <p><b>Invocation Result</b>:<br>
     * com.vmware.nsx.model.StaticHopBfdPeer
     * </p>
     *
     * <p><b>Operation Errors:</b><br>
     * {@link com.vmware.vapi.std.errors.InvalidRequest} - Bad Request, Precondition Failed<br>
     * {@link com.vmware.vapi.std.errors.Unauthorized} - Forbidden<br>
     * {@link com.vmware.vapi.std.errors.ServiceUnavailable} - Service Unavailable<br>
     * {@link com.vmware.vapi.std.errors.InternalServerError} - Internal Server Error<br>
     * {@link com.vmware.vapi.std.errors.NotFound} - Not Found<br>
     * </p>
     *
     * @param logicalRouterId (required)
     * @param bfdPeerId (required)
     * @param staticHopBfdPeer (required)
     * @param asyncCallback Receives the status (progress, result or error) of the operation invocation.
     * @param invocationConfig Configuration for the method invocation.
     */
    @Deprecated
    public void update(java.lang.String logicalRouterId, java.lang.String bfdPeerId, com.vmware.nsx.model.StaticHopBfdPeer staticHopBfdPeer, com.vmware.vapi.bindings.client.AsyncCallback<com.vmware.nsx.model.StaticHopBfdPeer> asyncCallback, com.vmware.vapi.bindings.client.InvocationConfig invocationConfig);

}
