/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Configuration for taking manual/automated backup
 */
public final class BackupConfiguration implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.Long afterInventoryUpdateInterval;

    private java.lang.Boolean backupEnabled;

    private com.vmware.vapi.bindings.Structure backupSchedule;

    private java.lang.Long inventorySummaryInterval;

    private java.lang.String passphrase;

    private com.vmware.nsx.model.RemoteFileServer remoteFileServer;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public BackupConfiguration() {
    }

    protected BackupConfiguration(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * A number of seconds after a last backup, that needs to pass, before a topology
     * change will trigger a generation of a new cluster/node backups. If parameter is
     * not provided, then changes in a topology will not trigger a generation of
     * cluster/node backups. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getAfterInventoryUpdateInterval() {
        return this.afterInventoryUpdateInterval;
    }

    /**
     * A number of seconds after a last backup, that needs to pass, before a topology
     * change will trigger a generation of a new cluster/node backups. If parameter is
     * not provided, then changes in a topology will not trigger a generation of
     * cluster/node backups. format: int64
     *
     * @param afterInventoryUpdateInterval New value for the property.
     */
    public void setAfterInventoryUpdateInterval(java.lang.Long afterInventoryUpdateInterval) {
        this.afterInventoryUpdateInterval = afterInventoryUpdateInterval;
    }

    /**
     * true if automated backup is enabled
     *
     * @return The current value of the property.
     */
    public java.lang.Boolean getBackupEnabled() {
        return this.backupEnabled;
    }

    /**
     * true if automated backup is enabled
     *
     * @param backupEnabled New value for the property.
     */
    public void setBackupEnabled(java.lang.Boolean backupEnabled) {
        this.backupEnabled = backupEnabled;
    }

    /**
     *
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.BackupSchedule}. When methods return a value of this class
     * as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.BackupSchedule}.
     */
    public com.vmware.vapi.bindings.Structure getBackupSchedule() {
        return this.backupSchedule;
    }

    /**
     *
     *
     * @param backupSchedule New value for the property.
     * When clients pass a value of this class as a parameter, the property must
     * contain all the properties defined in {@link
     * com.vmware.nsx.model.BackupSchedule}. When methods return a value of this class
     * as a return value, the property will contain all the properties defined in
     * {@link com.vmware.nsx.model.BackupSchedule}.
     */
    public void setBackupSchedule(com.vmware.vapi.bindings.Structure backupSchedule) {
        this.backupSchedule = backupSchedule;
    }

    /**
     * The minimum number of seconds between each upload of the inventory summary to
     * backup server. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getInventorySummaryInterval() {
        return this.inventorySummaryInterval;
    }

    /**
     * The minimum number of seconds between each upload of the inventory summary to
     * backup server. format: int64
     *
     * @param inventorySummaryInterval New value for the property.
     */
    public void setInventorySummaryInterval(java.lang.Long inventorySummaryInterval) {
        this.inventorySummaryInterval = inventorySummaryInterval;
    }

    /**
     * Passphrase used to encrypt backup files. The passphrase specified must be at
     * least 8 characters in length and must contain at least one lowercase, one
     * uppercase, one numeric character and one special character (any other non-space
     * character).
     *
     * @return The current value of the property.
     */
    public java.lang.String getPassphrase() {
        return this.passphrase;
    }

    /**
     * Passphrase used to encrypt backup files. The passphrase specified must be at
     * least 8 characters in length and must contain at least one lowercase, one
     * uppercase, one numeric character and one special character (any other non-space
     * character).
     *
     * @param passphrase New value for the property.
     */
    public void setPassphrase(java.lang.String passphrase) {
        this.passphrase = passphrase;
    }

    /**
     *
     *
     * @return The current value of the property.
     */
    public com.vmware.nsx.model.RemoteFileServer getRemoteFileServer() {
        return this.remoteFileServer;
    }

    /**
     *
     *
     * @param remoteFileServer New value for the property.
     */
    public void setRemoteFileServer(com.vmware.nsx.model.RemoteFileServer remoteFileServer) {
        this.remoteFileServer = remoteFileServer;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.backupConfiguration;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("after_inventory_update_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.afterInventoryUpdateInterval, this._getType().getField("after_inventory_update_interval")));
        structValue.setField("backup_enabled",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.backupEnabled, this._getType().getField("backup_enabled")));
        structValue.setField("backup_schedule",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.backupSchedule, this._getType().getField("backup_schedule")));
        structValue.setField("inventory_summary_interval",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.inventorySummaryInterval, this._getType().getField("inventory_summary_interval")));
        structValue.setField("passphrase",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.passphrase, this._getType().getField("passphrase")));
        structValue.setField("remote_file_server",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.remoteFileServer, this._getType().getField("remote_file_server")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.backupConfiguration;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.backupConfiguration.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static BackupConfiguration _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new BackupConfiguration(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static BackupConfiguration _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new BackupConfiguration(structValue);
    }

    /**
     * Builder class for {@link BackupConfiguration}.
     */
    public static final class Builder {
        private java.lang.Long afterInventoryUpdateInterval;
        private java.lang.Boolean backupEnabled;
        private com.vmware.vapi.bindings.Structure backupSchedule;
        private java.lang.Long inventorySummaryInterval;
        private java.lang.String passphrase;
        private com.vmware.nsx.model.RemoteFileServer remoteFileServer;

        /**
         * Constructor with parameters for the required properties of
         * {@link BackupConfiguration}.
         */
        public Builder() {
        }

        /**
         * A number of seconds after a last backup, that needs to pass, before a topology
         * change will trigger a generation of a new cluster/node backups. If parameter is
         * not provided, then changes in a topology will not trigger a generation of
         * cluster/node backups. format: int64
         *
         * @param afterInventoryUpdateInterval New value for the property.
         */
        public Builder setAfterInventoryUpdateInterval(java.lang.Long afterInventoryUpdateInterval) {
            this.afterInventoryUpdateInterval = afterInventoryUpdateInterval;
            return this;
        }

        /**
         * true if automated backup is enabled
         *
         * @param backupEnabled New value for the property.
         */
        public Builder setBackupEnabled(java.lang.Boolean backupEnabled) {
            this.backupEnabled = backupEnabled;
            return this;
        }

        /**
         *
         *
         * @param backupSchedule New value for the property.
         * When clients pass a value of this class as a parameter, the property must
         * contain all the properties defined in {@link
         * com.vmware.nsx.model.BackupSchedule}. When methods return a value of this class
         * as a return value, the property will contain all the properties defined in
         * {@link com.vmware.nsx.model.BackupSchedule}.
         */
        public Builder setBackupSchedule(com.vmware.vapi.bindings.Structure backupSchedule) {
            this.backupSchedule = backupSchedule;
            return this;
        }

        /**
         * The minimum number of seconds between each upload of the inventory summary to
         * backup server. format: int64
         *
         * @param inventorySummaryInterval New value for the property.
         */
        public Builder setInventorySummaryInterval(java.lang.Long inventorySummaryInterval) {
            this.inventorySummaryInterval = inventorySummaryInterval;
            return this;
        }

        /**
         * Passphrase used to encrypt backup files. The passphrase specified must be at
         * least 8 characters in length and must contain at least one lowercase, one
         * uppercase, one numeric character and one special character (any other non-space
         * character).
         *
         * @param passphrase New value for the property.
         */
        public Builder setPassphrase(java.lang.String passphrase) {
            this.passphrase = passphrase;
            return this;
        }

        /**
         *
         *
         * @param remoteFileServer New value for the property.
         */
        public Builder setRemoteFileServer(com.vmware.nsx.model.RemoteFileServer remoteFileServer) {
            this.remoteFileServer = remoteFileServer;
            return this;
        }

        public BackupConfiguration build() {
            BackupConfiguration result = new BackupConfiguration();
            result.setAfterInventoryUpdateInterval(this.afterInventoryUpdateInterval);
            result.setBackupEnabled(this.backupEnabled);
            result.setBackupSchedule(this.backupSchedule);
            result.setInventorySummaryInterval(this.inventorySummaryInterval);
            result.setPassphrase(this.passphrase);
            result.setRemoteFileServer(this.remoteFileServer);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("after_inventory_update_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("after_inventory_update_interval",
                                                                                "afterInventoryUpdateInterval",
                                                                                "getAfterInventoryUpdateInterval",
                                                                                "setAfterInventoryUpdateInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("backup_enabled", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.BooleanType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("backup_enabled",
                                                                                "backupEnabled",
                                                                                "getBackupEnabled",
                                                                                "setBackupEnabled");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("backup_schedule", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType(java.util.Arrays.<com.vmware.vapi.internal.data.ConstraintValidator>asList(new com.vmware.vapi.internal.bindings.HasFieldsOfValidator(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.backupSchedule; } })))));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("backup_schedule",
                                                                                "backupSchedule",
                                                                                "getBackupSchedule",
                                                                                "setBackupSchedule");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("inventory_summary_interval", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("inventory_summary_interval",
                                                                                "inventorySummaryInterval",
                                                                                "getInventorySummaryInterval",
                                                                                "setInventorySummaryInterval");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("passphrase", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("passphrase",
                                                                                "passphrase",
                                                                                "getPassphrase",
                                                                                "setPassphrase");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("remote_file_server", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.nsx.model.StructDefinitions.remoteFileServer; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("remote_file_server",
                                                                                "remoteFileServer",
                                                                                "getRemoteFileServer",
                                                                                "setRemoteFileServer");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.backup_configuration",
                                                            fields,
                                                            com.vmware.nsx.model.BackupConfiguration.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

