/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

/**
 * Relative to the form factor pre-defined reservation value. We recommended that
 * you use the predefined measures of CPU reservation shares to reduce the CPU
 * reservation of a VM. Reservation shares are relative to the default form-factor
 * value. Though absolute values for CPU reservation is supported, we advise to use
 * this option with caution as incorrect or high reservation values could lead to
 * deployment failure or lead to resource starvation for other VMs running on the
 * same host.
 */
public final class CPUReservation implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String RESERVATION_IN_SHARES_EXTRA_HIGH_PRIORITY = "EXTRA_HIGH_PRIORITY";

    public static final java.lang.String RESERVATION_IN_SHARES_HIGH_PRIORITY = "HIGH_PRIORITY";

    public static final java.lang.String RESERVATION_IN_SHARES_NORMAL_PRIORITY = "NORMAL_PRIORITY";

    public static final java.lang.String RESERVATION_IN_SHARES_LOW_PRIORITY = "LOW_PRIORITY";

    private java.lang.Long reservationInMhz;

    private java.lang.String reservationInShares;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CPUReservation() {
    }

    protected CPUReservation(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The CPU reservation in MHz is the guaranteed minimum amount of clock cycles that
     * the vmkernel CPU scheduler will give the Edge VM in case of contention. If an
     * Edge VM is not using its reserved resources, then other machines can use them
     * thus preventing waste of CPU cycles on the physical host. Note: We recommend use
     * of reservation_in_shares instead of this absolute configuration. When you
     * specify this value, set reservation_in_shares to LOW_PRIORITY. format: int32
     *
     * @return The current value of the property.
     */
    public java.lang.Long getReservationInMhz() {
        return this.reservationInMhz;
    }

    /**
     * The CPU reservation in MHz is the guaranteed minimum amount of clock cycles that
     * the vmkernel CPU scheduler will give the Edge VM in case of contention. If an
     * Edge VM is not using its reserved resources, then other machines can use them
     * thus preventing waste of CPU cycles on the physical host. Note: We recommend use
     * of reservation_in_shares instead of this absolute configuration. When you
     * specify this value, set reservation_in_shares to LOW_PRIORITY. format: int32
     *
     * @param reservationInMhz New value for the property.
     */
    public void setReservationInMhz(java.lang.Long reservationInMhz) {
        this.reservationInMhz = reservationInMhz;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_EXTRA_HIGH_PRIORITY}</li>
     * <li> {@link
     * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_HIGH_PRIORITY}</li>
     * <li> {@link
     * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_NORMAL_PRIORITY}</li>
     * <li> {@link
     * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_LOW_PRIORITY}</li>
     * </ul> Shares specify the relative importance of a virtual machine on a given
     * host. When you assign shares to a virtual machine, you always specify the
     * priority for that virtual machine relative to other powered-on virtual machines
     * on the same host. The default priority for shares is HIGH_PRIORITY.
     *
     * @return The current value of the property.
     */
    public java.lang.String getReservationInShares() {
        return this.reservationInShares;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_EXTRA_HIGH_PRIORITY}</li>
     * <li> {@link
     * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_HIGH_PRIORITY}</li>
     * <li> {@link
     * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_NORMAL_PRIORITY}</li>
     * <li> {@link
     * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_LOW_PRIORITY}</li>
     * </ul> Shares specify the relative importance of a virtual machine on a given
     * host. When you assign shares to a virtual machine, you always specify the
     * priority for that virtual machine relative to other powered-on virtual machines
     * on the same host. The default priority for shares is HIGH_PRIORITY.
     *
     * @param reservationInShares New value for the property.
     */
    public void setReservationInShares(java.lang.String reservationInShares) {
        this.reservationInShares = reservationInShares;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.CPUReservation;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("reservation_in_mhz",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reservationInMhz, this._getType().getField("reservation_in_mhz")));
        structValue.setField("reservation_in_shares",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.reservationInShares, this._getType().getField("reservation_in_shares")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.CPUReservation;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.CPUReservation.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CPUReservation _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CPUReservation(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CPUReservation _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CPUReservation(structValue);
    }

    /**
     * Builder class for {@link CPUReservation}.
     */
    public static final class Builder {
        private java.lang.Long reservationInMhz;
        private java.lang.String reservationInShares;

        /**
         * Constructor with parameters for the required properties of
         * {@link CPUReservation}.
         */
        public Builder() {
        }

        /**
         * The CPU reservation in MHz is the guaranteed minimum amount of clock cycles that
         * the vmkernel CPU scheduler will give the Edge VM in case of contention. If an
         * Edge VM is not using its reserved resources, then other machines can use them
         * thus preventing waste of CPU cycles on the physical host. Note: We recommend use
         * of reservation_in_shares instead of this absolute configuration. When you
         * specify this value, set reservation_in_shares to LOW_PRIORITY. format: int32
         *
         * @param reservationInMhz New value for the property.
         */
        public Builder setReservationInMhz(java.lang.Long reservationInMhz) {
            this.reservationInMhz = reservationInMhz;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_EXTRA_HIGH_PRIORITY}</li>
         * <li> {@link
         * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_HIGH_PRIORITY}</li>
         * <li> {@link
         * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_NORMAL_PRIORITY}</li>
         * <li> {@link
         * com.vmware.nsx.model.CPUReservation#RESERVATION_IN_SHARES_LOW_PRIORITY}</li>
         * </ul> Shares specify the relative importance of a virtual machine on a given
         * host. When you assign shares to a virtual machine, you always specify the
         * priority for that virtual machine relative to other powered-on virtual machines
         * on the same host. The default priority for shares is HIGH_PRIORITY.
         *
         * @param reservationInShares New value for the property.
         */
        public Builder setReservationInShares(java.lang.String reservationInShares) {
            this.reservationInShares = reservationInShares;
            return this;
        }

        public CPUReservation build() {
            CPUReservation result = new CPUReservation();
            result.setReservationInMhz(this.reservationInMhz);
            result.setReservationInShares(this.reservationInShares);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("reservation_in_mhz", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reservation_in_mhz",
                                                                                "reservationInMhz",
                                                                                "getReservationInMhz",
                                                                                "setReservationInMhz");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("reservation_in_shares", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("reservation_in_shares",
                                                                                "reservationInShares",
                                                                                "getReservationInShares",
                                                                                "setReservationInShares");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.CPU_reservation",
                                                            fields,
                                                            com.vmware.nsx.model.CPUReservation.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

