/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class ClientSslProfileBinding implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String CLIENT_AUTH_REQUIRED = "REQUIRED";

    public static final java.lang.String CLIENT_AUTH_IGNORE = "IGNORE";

    private java.lang.Long certificateChainDepth;

    private java.lang.String clientAuth;

    private java.util.List<java.lang.String> clientAuthCaIds;

    private java.util.List<java.lang.String> clientAuthCrlIds;

    private java.lang.String defaultCertificateId;

    private java.util.List<java.lang.String> sniCertificateIds;

    private java.lang.String sslProfileId;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public ClientSslProfileBinding() {
    }

    protected ClientSslProfileBinding(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * authentication depth is used to set the verification depth in the client
     * certificates chain. format: int64
     *
     * @return The current value of the property.
     */
    public java.lang.Long getCertificateChainDepth() {
        return this.certificateChainDepth;
    }

    /**
     * authentication depth is used to set the verification depth in the client
     * certificates chain. format: int64
     *
     * @param certificateChainDepth New value for the property.
     */
    public void setCertificateChainDepth(java.lang.Long certificateChainDepth) {
        this.certificateChainDepth = certificateChainDepth;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ClientSslProfileBinding#CLIENT_AUTH_REQUIRED}</li> <li>
     * {@link com.vmware.nsx.model.ClientSslProfileBinding#CLIENT_AUTH_IGNORE}</li>
     * </ul> client authentication mode
     *
     * @return The current value of the property.
     */
    public java.lang.String getClientAuth() {
        return this.clientAuth;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.ClientSslProfileBinding#CLIENT_AUTH_REQUIRED}</li> <li>
     * {@link com.vmware.nsx.model.ClientSslProfileBinding#CLIENT_AUTH_IGNORE}</li>
     * </ul> client authentication mode
     *
     * @param clientAuth New value for the property.
     */
    public void setClientAuth(java.lang.String clientAuth) {
        this.clientAuth = clientAuth;
    }

    /**
     * If client auth type is REQUIRED, client certificate must be signed by one of the
     * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
     * signed certificates are specified.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getClientAuthCaIds() {
        return this.clientAuthCaIds;
    }

    /**
     * If client auth type is REQUIRED, client certificate must be signed by one of the
     * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
     * signed certificates are specified.
     *
     * @param clientAuthCaIds New value for the property.
     */
    public void setClientAuthCaIds(java.util.List<java.lang.String> clientAuthCaIds) {
        this.clientAuthCaIds = clientAuthCaIds;
    }

    /**
     * A Certificate Revocation List (CRL) can be specified in the client-side SSL
     * profile binding to disallow compromised client certificates.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getClientAuthCrlIds() {
        return this.clientAuthCrlIds;
    }

    /**
     * A Certificate Revocation List (CRL) can be specified in the client-side SSL
     * profile binding to disallow compromised client certificates.
     *
     * @param clientAuthCrlIds New value for the property.
     */
    public void setClientAuthCrlIds(java.util.List<java.lang.String> clientAuthCrlIds) {
        this.clientAuthCrlIds = clientAuthCrlIds;
    }

    /**
     * A default certificate should be specified which will be used if the server does
     * not host multiple hostnames on the same IP address or if the client does not
     * support SNI extension.
     *
     * @return The current value of the property.
     */
    public java.lang.String getDefaultCertificateId() {
        return this.defaultCertificateId;
    }

    /**
     * A default certificate should be specified which will be used if the server does
     * not host multiple hostnames on the same IP address or if the client does not
     * support SNI extension.
     *
     * @param defaultCertificateId New value for the property.
     */
    public void setDefaultCertificateId(java.lang.String defaultCertificateId) {
        this.defaultCertificateId = defaultCertificateId;
    }

    /**
     * Client-side SSL profile binding allows multiple certificates, for different
     * hostnames, to be bound to the same virtual server.
     *
     * @return The current value of the property.
     */
    public java.util.List<java.lang.String> getSniCertificateIds() {
        return this.sniCertificateIds;
    }

    /**
     * Client-side SSL profile binding allows multiple certificates, for different
     * hostnames, to be bound to the same virtual server.
     *
     * @param sniCertificateIds New value for the property.
     */
    public void setSniCertificateIds(java.util.List<java.lang.String> sniCertificateIds) {
        this.sniCertificateIds = sniCertificateIds;
    }

    /**
     * Client SSL profile defines reusable, application-independent client side SSL
     * properties.
     *
     * @return The current value of the property.
     */
    public java.lang.String getSslProfileId() {
        return this.sslProfileId;
    }

    /**
     * Client SSL profile defines reusable, application-independent client side SSL
     * properties.
     *
     * @param sslProfileId New value for the property.
     */
    public void setSslProfileId(java.lang.String sslProfileId) {
        this.sslProfileId = sslProfileId;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.clientSslProfileBinding;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("certificate_chain_depth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.certificateChainDepth, this._getType().getField("certificate_chain_depth")));
        structValue.setField("client_auth",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientAuth, this._getType().getField("client_auth")));
        structValue.setField("client_auth_ca_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientAuthCaIds, this._getType().getField("client_auth_ca_ids")));
        structValue.setField("client_auth_crl_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.clientAuthCrlIds, this._getType().getField("client_auth_crl_ids")));
        structValue.setField("default_certificate_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.defaultCertificateId, this._getType().getField("default_certificate_id")));
        structValue.setField("sni_certificate_ids",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sniCertificateIds, this._getType().getField("sni_certificate_ids")));
        structValue.setField("ssl_profile_id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.sslProfileId, this._getType().getField("ssl_profile_id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.clientSslProfileBinding;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.clientSslProfileBinding.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static ClientSslProfileBinding _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new ClientSslProfileBinding(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static ClientSslProfileBinding _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new ClientSslProfileBinding(structValue);
    }

    /**
     * Builder class for {@link ClientSslProfileBinding}.
     */
    public static final class Builder {
        private java.lang.Long certificateChainDepth;
        private java.lang.String clientAuth;
        private java.util.List<java.lang.String> clientAuthCaIds;
        private java.util.List<java.lang.String> clientAuthCrlIds;
        private java.lang.String defaultCertificateId;
        private java.util.List<java.lang.String> sniCertificateIds;
        private java.lang.String sslProfileId;

        /**
         * Constructor with parameters for the required properties of
         * {@link ClientSslProfileBinding}.
         */
        public Builder() {
        }

        /**
         * authentication depth is used to set the verification depth in the client
         * certificates chain. format: int64
         *
         * @param certificateChainDepth New value for the property.
         */
        public Builder setCertificateChainDepth(java.lang.Long certificateChainDepth) {
            this.certificateChainDepth = certificateChainDepth;
            return this;
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.ClientSslProfileBinding#CLIENT_AUTH_REQUIRED}</li> <li>
         * {@link com.vmware.nsx.model.ClientSslProfileBinding#CLIENT_AUTH_IGNORE}</li>
         * </ul> client authentication mode
         *
         * @param clientAuth New value for the property.
         */
        public Builder setClientAuth(java.lang.String clientAuth) {
            this.clientAuth = clientAuth;
            return this;
        }

        /**
         * If client auth type is REQUIRED, client certificate must be signed by one of the
         * trusted Certificate Authorities (CAs), also referred to as root CAs, whose self
         * signed certificates are specified.
         *
         * @param clientAuthCaIds New value for the property.
         */
        public Builder setClientAuthCaIds(java.util.List<java.lang.String> clientAuthCaIds) {
            this.clientAuthCaIds = clientAuthCaIds;
            return this;
        }

        /**
         * A Certificate Revocation List (CRL) can be specified in the client-side SSL
         * profile binding to disallow compromised client certificates.
         *
         * @param clientAuthCrlIds New value for the property.
         */
        public Builder setClientAuthCrlIds(java.util.List<java.lang.String> clientAuthCrlIds) {
            this.clientAuthCrlIds = clientAuthCrlIds;
            return this;
        }

        /**
         * A default certificate should be specified which will be used if the server does
         * not host multiple hostnames on the same IP address or if the client does not
         * support SNI extension.
         *
         * @param defaultCertificateId New value for the property.
         */
        public Builder setDefaultCertificateId(java.lang.String defaultCertificateId) {
            this.defaultCertificateId = defaultCertificateId;
            return this;
        }

        /**
         * Client-side SSL profile binding allows multiple certificates, for different
         * hostnames, to be bound to the same virtual server.
         *
         * @param sniCertificateIds New value for the property.
         */
        public Builder setSniCertificateIds(java.util.List<java.lang.String> sniCertificateIds) {
            this.sniCertificateIds = sniCertificateIds;
            return this;
        }

        /**
         * Client SSL profile defines reusable, application-independent client side SSL
         * properties.
         *
         * @param sslProfileId New value for the property.
         */
        public Builder setSslProfileId(java.lang.String sslProfileId) {
            this.sslProfileId = sslProfileId;
            return this;
        }

        public ClientSslProfileBinding build() {
            ClientSslProfileBinding result = new ClientSslProfileBinding();
            result.setCertificateChainDepth(this.certificateChainDepth);
            result.setClientAuth(this.clientAuth);
            result.setClientAuthCaIds(this.clientAuthCaIds);
            result.setClientAuthCrlIds(this.clientAuthCrlIds);
            result.setDefaultCertificateId(this.defaultCertificateId);
            result.setSniCertificateIds(this.sniCertificateIds);
            result.setSslProfileId(this.sslProfileId);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("certificate_chain_depth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.IntegerType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("certificate_chain_depth",
                                                                                "certificateChainDepth",
                                                                                "getCertificateChainDepth",
                                                                                "setCertificateChainDepth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_auth", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_auth",
                                                                                "clientAuth",
                                                                                "getClientAuth",
                                                                                "setClientAuth");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_auth_ca_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_auth_ca_ids",
                                                                                "clientAuthCaIds",
                                                                                "getClientAuthCaIds",
                                                                                "setClientAuthCaIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("client_auth_crl_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("client_auth_crl_ids",
                                                                                "clientAuthCrlIds",
                                                                                "getClientAuthCrlIds",
                                                                                "setClientAuthCrlIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("default_certificate_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("default_certificate_id",
                                                                                "defaultCertificateId",
                                                                                "getDefaultCertificateId",
                                                                                "setDefaultCertificateId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("sni_certificate_ids", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.StringType())));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("sni_certificate_ids",
                                                                                "sniCertificateIds",
                                                                                "getSniCertificateIds",
                                                                                "setSniCertificateIds");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("ssl_profile_id", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("ssl_profile_id",
                                                                                "sslProfileId",
                                                                                "getSslProfileId",
                                                                                "setSslProfileId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.client_ssl_profile_binding",
                                                            fields,
                                                            com.vmware.nsx.model.ClientSslProfileBinding.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

