/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.nsx.model.
 * Represents a binding of a top level structure.
 */

package com.vmware.nsx.model;

public final class CmThumbprintHashingConfig implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    public static final java.lang.String HASHING_ALGORITHM_TYPE_SHA1 = "SHA1";

    public static final java.lang.String HASHING_ALGORITHM_TYPE_SHA256 = "SHA256";

    private java.lang.String hashingAlgorithmType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * Default constructor.
     */
    public CmThumbprintHashingConfig() {
    }

    protected CmThumbprintHashingConfig(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.CmThumbprintHashingConfig#HASHING_ALGORITHM_TYPE_SHA1}</li>
     * <li> {@link
     * com.vmware.nsx.model.CmThumbprintHashingConfig#HASHING_ALGORITHM_TYPE_SHA256}</li>
     * </ul> This specifies the hashing algorithm to be used for stamping NSX manager
     * thumbprint in compute manager extension. e.g. When a vCenter is registered as
     * compute manager, thumbprint of NSX manager certificate is stamped in NSXT
     * extension on vCenter. If algorithm type is SHA1, then SHA1 thumbprint of NSX
     * manager API certificate is stamped. If algorithm type is SHA256, then SHA256
     * thumbprint of NSX manager certificate is stamped. Changing this setting to
     * SHA256 will result in communication issues between WCP component in VC and NSX
     * manager. Hence it is recommended not to use SHA256 if VC WCP feature is being
     * used with NSX.
     *
     * @return The current value of the property.
     */
    public java.lang.String getHashingAlgorithmType() {
        return this.hashingAlgorithmType;
    }

    /**
     * Possible values are: <ul> <li> {@link
     * com.vmware.nsx.model.CmThumbprintHashingConfig#HASHING_ALGORITHM_TYPE_SHA1}</li>
     * <li> {@link
     * com.vmware.nsx.model.CmThumbprintHashingConfig#HASHING_ALGORITHM_TYPE_SHA256}</li>
     * </ul> This specifies the hashing algorithm to be used for stamping NSX manager
     * thumbprint in compute manager extension. e.g. When a vCenter is registered as
     * compute manager, thumbprint of NSX manager certificate is stamped in NSXT
     * extension on vCenter. If algorithm type is SHA1, then SHA1 thumbprint of NSX
     * manager API certificate is stamped. If algorithm type is SHA256, then SHA256
     * thumbprint of NSX manager certificate is stamped. Changing this setting to
     * SHA256 will result in communication issues between WCP component in VC and NSX
     * manager. Hence it is recommended not to use SHA256 if VC WCP feature is being
     * used with NSX.
     *
     * @param hashingAlgorithmType New value for the property.
     */
    public void setHashingAlgorithmType(java.lang.String hashingAlgorithmType) {
        this.hashingAlgorithmType = hashingAlgorithmType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.nsx.model.StructDefinitions.cmThumbprintHashingConfig;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("hashing_algorithm_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.hashingAlgorithmType, this._getType().getField("hashing_algorithm_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.nsx.model.StructDefinitions.cmThumbprintHashingConfig;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.nsx.model.StructDefinitions.cmThumbprintHashingConfig.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static CmThumbprintHashingConfig _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new CmThumbprintHashingConfig(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static CmThumbprintHashingConfig _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new CmThumbprintHashingConfig(structValue);
    }

    /**
     * Builder class for {@link CmThumbprintHashingConfig}.
     */
    public static final class Builder {
        private java.lang.String hashingAlgorithmType;

        /**
         * Constructor with parameters for the required properties of
         * {@link CmThumbprintHashingConfig}.
         */
        public Builder() {
        }

        /**
         * Possible values are: <ul> <li> {@link
         * com.vmware.nsx.model.CmThumbprintHashingConfig#HASHING_ALGORITHM_TYPE_SHA1}</li>
         * <li> {@link
         * com.vmware.nsx.model.CmThumbprintHashingConfig#HASHING_ALGORITHM_TYPE_SHA256}</li>
         * </ul> This specifies the hashing algorithm to be used for stamping NSX manager
         * thumbprint in compute manager extension. e.g. When a vCenter is registered as
         * compute manager, thumbprint of NSX manager certificate is stamped in NSXT
         * extension on vCenter. If algorithm type is SHA1, then SHA1 thumbprint of NSX
         * manager API certificate is stamped. If algorithm type is SHA256, then SHA256
         * thumbprint of NSX manager certificate is stamped. Changing this setting to
         * SHA256 will result in communication issues between WCP component in VC and NSX
         * manager. Hence it is recommended not to use SHA256 if VC WCP feature is being
         * used with NSX.
         *
         * @param hashingAlgorithmType New value for the property.
         */
        public Builder setHashingAlgorithmType(java.lang.String hashingAlgorithmType) {
            this.hashingAlgorithmType = hashingAlgorithmType;
            return this;
        }

        public CmThumbprintHashingConfig build() {
            CmThumbprintHashingConfig result = new CmThumbprintHashingConfig();
            result.setHashingAlgorithmType(this.hashingAlgorithmType);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("hashing_algorithm_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.StringType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("hashing_algorithm_type",
                                                                                "hashingAlgorithmType",
                                                                                "getHashingAlgorithmType",
                                                                                "setHashingAlgorithmType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.nsx.model.cm_thumbprint_hashing_config",
                                                            fields,
                                                            com.vmware.nsx.model.CmThumbprintHashingConfig.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

